/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.TreatmentComparator;

public class SplitParameter
implements NetworkParameter,
Comparable<SplitParameter> {
    private final Treatment d_base;
    private final Treatment d_subj;
    private final boolean d_direct;

    public SplitParameter(Treatment base, Treatment subj, boolean direct) {
        this.d_base = base;
        this.d_subj = subj;
        this.d_direct = direct;
    }

    @Override
    public String getName() {
        return "d." + this.d_base.getId() + "." + this.d_subj.getId() + "." + (this.d_direct ? "dir" : "ind");
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SplitParameter) {
            SplitParameter other = (SplitParameter)obj;
            return this.d_base.equals(other.d_base) && this.d_subj.equals(other.d_subj) && this.d_direct == other.d_direct;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.d_base.hashCode() + this.d_subj.hashCode() + (this.d_direct ? 1 : 0);
    }

    @Override
    public int compareTo(SplitParameter other) {
        TreatmentComparator tc = TreatmentComparator.INSTANCE;
        if (tc.compare(this.d_base, other.d_base) != 0) {
            return tc.compare(this.d_base, other.d_base);
        }
        if (tc.compare(this.d_subj, other.d_subj) != 0) {
            return tc.compare(this.d_subj, other.d_subj);
        }
        if (this.d_direct) {
            return other.d_direct ? 0 : -1;
        }
        return other.d_direct ? 1 : 0;
    }

    public Treatment getBaseline() {
        return this.d_base;
    }

    public Treatment getSubject() {
        return this.d_subj;
    }

    public boolean isDirect() {
        return this.d_direct;
    }
}

