/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;

public class FileResults
implements MCMCResults {
    private final int d_nSamples;
    private final Parameter[] d_parameters;
    private final int d_nChains;
    private double[][][] d_samples;
    private boolean d_available = false;
    private List<MCMCResultsListener> d_listeners = new ArrayList<MCMCResultsListener>();

    public FileResults(InputStream is, Parameter[] parameters, int nChains, int nSamples) throws IOException {
        this.d_parameters = parameters;
        this.d_nChains = nChains;
        this.d_nSamples = nSamples;
        this.d_samples = new double[this.d_nChains][this.d_parameters.length][this.d_nSamples];
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        reader.readLine();
        int i = 0;
        while (reader.ready()) {
            String line = reader.readLine();
            StringTokenizer tok = new StringTokenizer(line, ",");
            tok.nextToken();
            int j = 0;
            while (tok.hasMoreTokens()) {
                this.d_samples[i / this.d_nSamples][j][i % this.d_nSamples] = Double.parseDouble(tok.nextToken());
                ++j;
            }
            ++i;
        }
        is.close();
    }

    @Override
    public Parameter[] getParameters() {
        return this.d_parameters;
    }

    @Override
    public int findParameter(Parameter p) {
        return Arrays.asList(this.d_parameters).indexOf(p);
    }

    @Override
    public int getNumberOfChains() {
        return this.d_nChains;
    }

    @Override
    public int getNumberOfSamples() {
        return this.d_available ? this.d_nSamples : 0;
    }

    @Override
    public double getSample(int p, int c, int i) {
        if (!this.d_available) {
            throw new IndexOutOfBoundsException("No samples available");
        }
        return this.d_samples[c][p][i];
    }

    public double[] getSamples(int p, int c) {
        if (!this.d_available) {
            throw new IndexOutOfBoundsException("No samples available");
        }
        return this.d_samples[c][p];
    }

    @Override
    public void addResultsListener(MCMCResultsListener l) {
        this.d_listeners.add(l);
    }

    @Override
    public void removeResultsListener(MCMCResultsListener l) {
        this.d_listeners.remove(l);
    }

    public void makeSamplesAvailable() {
        this.d_available = true;
        for (MCMCResultsListener l : this.d_listeners) {
            l.resultsEvent(new MCMCResultsEvent(this));
        }
    }

    @Override
    public void clear() {
        this.d_samples = null;
    }

    public static class MyParameter
    implements Parameter {
        private String d_name;

        public MyParameter(String name) {
            this.d_name = name;
        }

        @Override
        public String getName() {
            return this.d_name;
        }
    }
}

