/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import java.util.Map;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Derivation {
    private final Map<? extends Parameter, Integer> d_pmtz;

    public Derivation(Map<? extends Parameter, Integer> pmtz) {
        assert (!pmtz.isEmpty());
        this.d_pmtz = pmtz;
    }

    public double[] calculate(MCMCResults results, int c) {
        double[] result = new double[results.getNumberOfSamples()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.calculate(results, c, i);
            ++i;
        }
        return result;
    }

    public double calculate(MCMCResults results, int c, int i) {
        double val = 0.0;
        for (Map.Entry<? extends Parameter, Integer> e : this.d_pmtz.entrySet()) {
            val += (double)e.getValue().intValue() * results.getSample(results.findParameter(e.getKey()), c, i);
        }
        return val;
    }
}

