% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_preprocessbigVCF.R
\name{filterLargep.link}
\alias{filterLargep.link}
\alias{filterLargeP.link}
\title{Pre-process of Large VCF File(s)}
\usage{
filterLargeP.link(
  root,
  rootOut = rootOut,
  Chr = Chr,
  POS = NULL,
  start = start,
  end = end,
  override = TRUE,
  sep = "\\t"
)
}
\arguments{
\item{root}{The file name without suffix. This function only support p.link file
format stored in "map" and "ped" format, the file names after removed suffix
should be same with each other.}

\item{rootOut}{Path(s) of output \code{p.link} file stored in "ped&map" format.}

\item{Chr}{a single CHROM name or CHROM names vector.}

\item{POS, start, end}{provide the chromosome name should be extract from orignal p.link dataset.
\code{POS}: a vector consist with start and end position, eg.: \code{c(1,200)}
indicates 3 ranges (1~200, 300~500 and 300~400).
if \code{POS} is \code{NULL}, \code{start} and \code{end} are needed.}

\item{override}{whether override existed file or not, default as \code{TRUE}.}

\item{sep}{a character indicate the separation of map and ped file, default is \verb{\\t}.}
}
\value{
No return value
}
\description{
Filter/extract one or multiple gene(s)/range(s) from a large
\code{p.link} file.
}
\details{
This package import P.link files. However, import a large P.link file is time and
memory consuming. It's suggested that extract variants in target
range with \code{filterLargeP.link()} before identification of haplotype.

When filter/extract multi genes/ranges, the parameter of \code{Chr} and \code{POS}
must have equal length. Results will save to a single file if the user
provide a single file path or save to multiple P.link file(s) when a equal length
vector consist with file paths is provided.
}
\examples{
\donttest{
 # The filteration of P.link of regular size should be done with `filter_plink.pedmap()`.
 # however, here, we use a mini vcf instead just for example and test

 pedfile <- system.file("extdata",
                        "snp3kvars-CHR8-25947258-25951166-plink.ped",
                        package = "geneHapR")
 mapfile <- system.file("extdata",
                        "snp3kvars-CHR8-25947258-25951166-plink.map",
                        package = "geneHapR")
 oldDir <- getwd()
 tmpdir <- tempdir()
 setwd(tmpdir)
 file.copy(pedfile, "test.ped")
 file.copy(mapfile, "test.map")

 # extract a single gene/range from large vcf
 filterLargeP.link(root = "test",
                   rootOut = "filtered_test",
                   Chr = "scaffold_1", POS = c(4300,5000), override = TRUE)

setwd(oldDir)

# delete tempDir
unlink(tmpdir, recursive = TRUE)
}
}
