% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genInfo.R
\name{genInfo}
\alias{genInfo}
\title{Get gene related information}
\usage{
genInfo(id, org, unique = FALSE)
}
\arguments{
\item{id}{Gene id (symbol, ensembl or entrez id) or uniprot id.}

\item{org}{Species name from `biocOrg_name`, both full name and short name are fine.}

\item{unique}{Logical to keep only one matched ID, default is FALSE.}
}
\value{
A `data.frame`.
}
\description{
Get gene related information
}
\examples{
\donttest{
# input id contains fake id and one-to-many match id
x <- genInfo(id = c(
  "MCM10", "CDC20", "S100A9", "MMP1", "BCC7",
  "FAKEID", "TP53", "HBD", "NUDT10"
), org = "hg", unique = TRUE)
head(x)
}
}
