% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{coercion-time-difference}
\alias{coercion-time-difference}
\alias{as.difftime}
\alias{as.difftime.default}
\title{Time difference coercion}
\usage{
as.difftime(tim, ...)

\method{as.difftime}{default}(tim, format = "\%X", units = "auto", ...)
}
\arguments{
\item{tim}{A vector specifying a time interval.}

\item{...}{Other arguments passed on to methods.}

\item{format}{A single character specifying the format of \code{tim} when it is
a character. The default is a locale-specific time format.}

\item{units}{A single character specifying units in which the results are
desired. Required if \code{tim} is a numeric.}
}
\value{
A \code{difftime} object with an attribute indicating the units.
}
\description{
Coercion functions for creating \code{difftime} objects from other
existing objects.
}
\details{
This function overrides the non-generic \code{as.difftime()} function
provided in base so that packages can provide methods for different data
types. The default method call the base version.
}
\section{Methods}{

\Sexpr[stage=render,results=rd]{generics:::methods_rd("as.difftime")}
}

\examples{
as.difftime(1:5, units = "secs")

as.difftime(c("01:55:22", "01:55:25"))

as.difftime("01", format = "\%H")
as.difftime("01", format = "\%H", units = "secs")

}
