% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_data_synapse.R
\name{pull_data_synapse}
\alias{pull_data_synapse}
\title{Obtain clinical & genomic data files for GENIE BPC Project}
\usage{
pull_data_synapse(
  cohort = NULL,
  version = NULL,
  download_location = NULL,
  username = NULL,
  password = NULL
)
}
\arguments{
\item{cohort}{Vector or list specifying the cohort(s) of interest. Must be
one of "NSCLC" (Non-Small Cell Lung Cancer), "CRC" (Colorectal Cancer), or
"BrCa" (Breast Cancer), "PANC" (Pancreatic Cancer), "Prostate" (Prostate Cancer),
and "BLADDER" (Bladder Cancer).}

\item{version}{Vector specifying the version of the data. Must be one of the
following: "v1.1-consortium", "v1.2-consortium", "v2.1-consortium",
"v2.0-public". When entering multiple cohorts, the order of the version
numbers corresponds to the order that the cohorts are specified; the cohort
and version number must be in the same order in order to pull the correct
data. See examples below.}

\item{download_location}{if `NULL` (default), data will be returned as a list
of dataframes with requested data as list items. Otherwise, specify a
folder path to have data automatically downloaded there. When a path is
specified, data are not read into the R environment.}

\item{username}{'Synapse' username}

\item{password}{'Synapse' password}
}
\value{
Returns a nested list of clinical and genomic data corresponding to
the specified cohort(s).
}
\description{
Function to access specified
 versions of clinical and genomic GENIE BPC data from
 \href{https://www.synapse.org/#!Synapse:syn21226493/wiki/599164}{Synapse}
 and read them into the R environment. See the \href{https://genie-bpc.github.io/genieBPC/articles/pull_data_synapse_vignette.html}{pull_data_synapse vignette}
for further documentation and examples.
}
\section{Authentication}{

To access data, users must have a valid 'Synapse' account with permission to
access the data set and they must have accepted any necessary 'Terms of Use'.
Users must always authenticate themselves in their current R session.
(see \href{https://genie-bpc.github.io/genieBPC/articles/pull_data_synapse_vignette.html}{README: Data Access and Authentication}

for details).
To set your 'Synapse' credentials during each session, call:

`set_synapse_credentials(username = "your_username", password = "your_password")`

If your credentials are stored as environmental variables, you do not need to
call `set_synapse_credentials()` explicitly each session. To store
authentication information in your environmental variables, add the following
to your .Renviron file, then restart your R session ' (tip: you can use
`usethis::edit_r_environ()` to easily open/edit this file):

\itemize{
   \item `SYNAPSE_USERNAME = <your-username>`
   \item `SYNAPSE_PASSWORD = <your-password>`
   }
Alternatively, you can pass your username and password to each individual
data pull function if preferred, although it is recommended that you manage
your passwords outside of your scripts for security purposes.
}

\section{Analytic Data Guides}{

  Documentation corresponding to the clinical data files
  can be found on 'Synapse' in the Analytic Data Guides:
\itemize{
  \item \href{https://www.synapse.org/#!Synapse:syn23002641}{NSCLC v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn26008058}{NSCLC v2.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn30557304}{NSCLC v2.0-Public Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn23764204}{CRC v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn26077308}{CRC v1.2-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn31751466}{CRC v2.0-Public Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn26077313}{BrCa v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn32330194}{BrCa v1.2-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn30787692}{BLADDER v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn29787285}{PANC v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn50612821}{PANC v1.2-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn30148714}{Prostate v1.1-Consortium Analytic Data Guide}
  \item \href{https://www.synapse.org/#!Synapse:syn50612204}{Prostate v1.2-Consortium Analytic Data Guide}
}
}

\examples{
\dontshow{if (genieBPC::.is_connected_to_genie()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# Set up 'Synapse' credentials
set_synapse_credentials()

# Print available versions of the data
synapse_version(most_recent = TRUE)

# Pull version 2.0-public for non-small cell lung cancer
# and version 1.1-consortium for colorectal cancer data

 ex1 <- pull_data_synapse(
   cohort = c("NSCLC", "BrCa"),
   version = c("v2.0-public", "v1.1-consortium")
 )

 names(ex1)
\dontshow{\}) # examplesIf}
}
\author{
Karissa Whiting, Michael Curry
}
