% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require_files_plink.R
\name{require_files_plink}
\alias{require_files_plink}
\title{Require that plink binary files are present}
\usage{
require_files_plink(file)
}
\arguments{
\item{file}{The shared file path (excluding BED/BIM/FAM extensions).}
}
\value{
Nothing
}
\description{
This function checks that each of the plink binary files (BED/BIM/FAM extensions) are present, given the shared base file path, stopping with an informative message if any of the files is missing.
This function aids troubleshooting, as various downstream external software report missing files differently and sometimes using confusing or obscure messages.
}
\examples{
# check that the samples we want exist
# start with bed file
file <- system.file("extdata", 'sample.bed', package = "genio", mustWork = TRUE)
# remove extension
file <- sub('\\\\.bed$', '', file)
# since all sample.{bed,bim,fam} files exist, this will not stop with error messages:
require_files_plink(file)

}
