% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_bed.R
\name{write_bed}
\alias{write_bed}
\title{Write a genotype matrix into Plink BED format}
\usage{
write_bed(file, X, verbose = TRUE, append = FALSE)
}
\arguments{
\item{file}{Output file path.  .bed extension may be omitted (will be added automatically if it is missing).}

\item{X}{The \code{m}-by-\code{n} genotype matrix.
Row and column names, if present, are ignored.}

\item{verbose}{If \code{TRUE} (default), function reports the path of the file being written (after autocompleting the extension).}

\item{append}{If \code{TRUE}, appends variants onto the file. (Default is \code{FALSE}).}
}
\value{
Nothing
}
\description{
This function accepts a standard R matrix containing genotypes (values in \code{c( 0, 1, 2, NA )}) and writes it into a Plink-formatted BED (binary) file.
Each genotype per locus (\code{m} loci) and individual (\code{n} total) counts the number of alternative alleles or \code{NA} for missing data.
No *.fam or *.bim files are created by this basic function.
}
\details{
Genotypes with values outside of [0, 2] cause an error, in which case the partial output is deleted.
However, beware that decimals get truncated internally, so values that truncate to 0, 1, or 2 will not raise errors.
The BED format does not accept fractional dosages, so such data will not be written as expected.
}
\examples{
# to write an existing matrix `X` into file "data.bed", run like this:
# write_bed("data", X)
# this also works
# write_bed("data.bed", X)

# The following example is more detailed but also more awkward
# because (only for these examples) the package must create the file in a *temporary* location

file_out <- tempfile('delete-me-example', fileext = '.bed') # will also work without extension
# create 10 random genotypes
X <- rbinom(10, 2, 0.5)
# replace 3 random genotypes with missing values
X[sample(10, 3)] <- NA
# turn into 5x2 matrix
X <- matrix(X, nrow = 5, ncol = 2)
# write this data to file in BED format
# (only *.bed gets created, no *.fam or *.bim in this call)
write_bed(file_out, X)
# delete output when done
file.remove(file_out)

}
\seealso{
\code{\link[=write_plink]{write_plink()}} for writing a set of BED/BIM/FAM files.

Plink BED format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#bed}
}
