% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_in_sequenom_data.R
\name{read_in_sequenom_data}
\alias{read_in_sequenom_data}
\title{Read in Sequenom Data}
\usage{
read_in_sequenom_data(x, sort_char = "chr|contig", ...)
}
\arguments{
\item{x}{This is a csv formatted Genotypes tab of exported sequenom data that you would like to read in.}

\item{sort_char}{is the character string output by the PERL pipeline in the marker design phase
(i.e., chr 1000 1050 AAA[A/T]GTC; the chr is the sort_char. Defaults to chr or contig.}

\item{...}{Other arguments passed to the function}
}
\value{
A data frame suited for the genotypeR package
}
\description{
\code{read_in_sequenom_data} reads in a csv file produced from
the Sequenom platform (i.e., sequenom excel output saved as a csv).

This function is a wrapper function around read.csv in order to read genotype data from the Sequenom Platform,
and provide data compatible with the genotypeR package.
}
\examples{

sequenom_file <- system.file("extdata/sequenom_test_data.csv", package = "genotypeR")

sequenom_data <- read_in_sequenom_data(sequenom_file)

}
\keyword{read}
\keyword{sequenom}
