% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{make_folds}
\alias{make_folds}
\title{Helper function for making fold IDs for cross validation.}
\usage{
make_folds(nsamp, nfold, cv_fold_seed)
}
\arguments{
\item{nsamp}{Number of samples.}

\item{nfold}{Number of cross validation folds.}

\item{cv_fold_seed}{Seed for random shuffling.}
}
\value{
A list of \code{nsamp} vectors, numbers 1 to \code{nsamp} shuffled and groupped into vectors of length \code{floor(nsamp/nfold)} followed by vectors of length \code{floor(nsamp/nfold)+1}.
}
\description{
Helper function for making fold IDs for cross validation.
}
\examples{
make_folds(37, 5, NULL)
make_folds(100, 5, 2)
make_folds(100, 10, 3)
}
