% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{rsglmm}
\alias{rsglmm}
\alias{rstrga}
\alias{rsgrf}
\title{Simulation from a spatial model}
\usage{
rsglmm(
  n,
  formula,
  family = "gaussian",
  data,
  weights,
  subset,
  offset,
  atsample,
  beta,
  linkp,
  phi,
  omg,
  kappa,
  ssq,
  corrfcn = "matern",
  longlat = FALSE,
  dispersion = 1,
  returnGRF = FALSE,
  warndisp = TRUE
)

rstrga(
  n,
  formula,
  data,
  weights,
  subset,
  offset,
  atsample,
  beta,
  linkp,
  phi,
  omg,
  kappa,
  ssq,
  corrfcn = "matern",
  longlat = FALSE,
  dispersion = 1,
  returnGRF = FALSE
)

rsgrf(
  n,
  formula,
  data,
  subset,
  offset,
  atsample,
  beta,
  phi,
  omg,
  kappa,
  ssq,
  corrfcn = "matern",
  longlat = FALSE
)
}
\arguments{
\item{n}{The number of instances to simulate}

\item{formula}{A representation of the model in the form
\code{response ~ terms}. The LHS can be omitted. If the LHS
exists, it can be of the form \code{y}, \code{y|z}, or sums of
terms at either side of the \code{|} to specify the names of the
variables to include in the data frame.}

\item{family}{The distribution of the data to simulate from.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional set of indices. Simulations will be
provided for those locations only.}

\item{offset}{See \code{\link[stats]{lm}}.}

\item{atsample}{A formula of the form \code{~ Xcoord + Ycoord}
specifying the sampled locations.}

\item{beta}{A vector of the regressor coefficents to use.}

\item{linkp}{The link function parameter.}

\item{phi}{The spatial range parameter.}

\item{omg}{The relative nugget parameter.}

\item{kappa}{The spatial smoothness parameter.}

\item{ssq}{The partial sill parameter.}

\item{corrfcn}{The correlation function to use.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{dispersion}{The fixed dispersion parameter. When this is not
1 and the sample is from a binomial or a Poisson distribution,
no such distribution exists so an approximate sample is
returned. Use with caution.}

\item{returnGRF}{Whether to return the simulate Gaussian random
field as well.}

\item{warndisp}{Whether to warn when sampling from a quasi
distribution. This is the case for binomial and Poisson when the
dispersion is not one.}
}
\value{
A data frame containing the predictors, sampling
  locations, optional weights, and samples.
}
\description{
Simulate from a variety of spatial models.
}
\details{
The spatial Gaussian random field is simulated using the Cholesky
decomposition of the covariance matrix.

The sample from a quasi distribution uses a hack which matches the
mean and the variance of the distribution. See the source code for
details.
}
\examples{
\dontrun{
n <- 100
beta <- c(-2, 1)
phi <- .2
omg <- .3
linkp <- 0
ssq <- 1
l <- rep(10, n)
corrf <- "matern"
kappa <- .5
family <- "poisson"
Xcoord <- runif(n)
Ycoord <- runif(n)
f <- Xcoord + Ycoord
formula <- y|z ~ f
mydata <- rsglmm(1, formula, family, weights = l,
                 atsample = ~ Xcoord + Ycoord, beta = beta, linkp = linkp,
                 phi = phi, omg = omg, kappa = kappa, ssq = ssq,
                 corrfcn = corrf, returnGRF = TRUE)
}
}
