% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_capitals.R
\name{read_capitals}
\alias{read_capitals}
\title{Download data of state capitals}
\usage{
read_capitals(as_sf = TRUE, showProgress = TRUE)
}
\arguments{
\item{as_sf}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function should
return a spatial data in \code{sf} format (Defaults to \code{TRUE}) or in a
\code{data.frame} format without spatial information (\code{FALSE}).}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object or a \code{"data.frame"}
}
\description{
This function downloads either a spatial \code{sf} object with the location of the
municipal seats (sede dos municipios) of state capitals, or a \code{data.frame}
with the names and codes of state capitals. Data downloaded for the latest
available year.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read spatial data with the  municipal seats of state capitals
capitals_sf <- read_capitals(as_sf = TRUE)

# Read simple data.frame of state capitals
capitals_df <- read_capitals(as_sf = FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_facilities}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_metro_area}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_schools}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_area}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
