% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hist.R
\name{get_hist}
\alias{get_hist}
\title{Obtain histories of treatment or outcome events}
\usage{
get_hist(tt, Xt, Yt = NA, lag, window, x_only = TRUE)
}
\arguments{
\item{tt}{values of the time variable of interest for which `get_hist()` generates histories}

\item{Xt}{the name of a treatment column}

\item{Yt}{the name of an outcome column}

\item{lag}{numeric. `lag` specifies the number of time periods over which 
`get_hist()` aggregates treatment and outcome columns.}

\item{window}{owin object.}

\item{x_only}{logical. `x_only` specifies whether to generate only treatment history (no outcome history). By default, `FALSE`.}
}
\value{
list of treatment and outcome histories
}
\description{
`get_hist()` takes a hyperframe and time and columns of interest, and generates histories of events of interest.
}
\examples{
dat_out <- insurgencies[1:100, ]
dat_out$time <- as.numeric(dat_out$date - min(dat_out$date) + 1)

# Hyperframe
dat_hfr <- get_hfr(data = dat_out,
                   subtype_column = "type",
                   window = iraq_window,
                   time_column = "time",
                   time_range = c(1, max(dat_out$time)),
                   coordinates = c("longitude", "latitude"),
                   combined = TRUE)

# Histories
lapply(1:nrow(dat_hfr), get_hist,
       Xt = dat_hfr$all_outcome,
       lag = 1, window = iraq_window)
}
