% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_detector.r
\name{risk_detector}
\alias{risk_detector}
\title{risk detector}
\usage{
risk_detector(y_column, x_column_nn, tabledata)
}
\arguments{
\item{y_column}{The index or field name of explained variable in input dataset.}

\item{x_column_nn}{The index or field name of explanatory variable(s) in input dataset.}

\item{tabledata}{The dataset (dataframe) contains fields of explained variable and explanatory variables.}
}
\value{
Results of risk detector include the means of explained variable in each stratum derived from an explanatory variable and the t-test for difference between two strata.
}
\description{
This function calculates the average values in each stratum of explanatory variable (X), and presents if there exists difference between two strata.
}
\examples{
data(CollectData)
risk_detector("incidence","soiltype",CollectData)
risk_detector(1,2,CollectData)
risk_detector(1,c(2,3,4),CollectData)
risk_detector("incidence",c("soiltype","watershed","elevation"),CollectData)
}
\keyword{detector}
\keyword{risk}
