% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension_get_higher_level_names.R
\name{get_higher_level_names}
\alias{get_higher_level_names}
\alias{get_higher_level_names.geodimension}
\title{Get higher level names}
\usage{
get_higher_level_names(gd, level_name = NULL, indirect_levels = FALSE)

\method{get_higher_level_names}{geodimension}(gd, level_name = NULL, indirect_levels = FALSE)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level_name}{A string.}

\item{indirect_levels}{A boolean.}
}
\value{
A vector of names.
}
\description{
Get the names of levels included in the \code{geodimension} that are at a higher
level than the indicated level. You can get only the direct levels or the
levels reached by passing through other levels.
}
\details{
The indicated level may inherit properties of the obtained levels.
}
\examples{
library(tidyr)

ln <- gd_us \%>\%
  get_higher_level_names(level_name = "state",
                         indirect_levels = TRUE)

}
\seealso{


Other information output functions: 
\code{\link{get_level_data}()},
\code{\link{get_level_geometries}()},
\code{\link{get_level_layer}()},
\code{\link{get_level_names}()}
}
\concept{information output functions}
