% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourier.R
\name{std}
\alias{std}
\title{Texture Direction Metrics}
\usage{
std(x, plot = FALSE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{plot}{Logical. If \code{TRUE}, returns a plot of the
amplitude spectrum with lines showing directions in which
amplitude is summed for the Std and Stdi calculations.
Plotting is not possible when input is a matrix.}
}
\value{
A vector containing numeric values for the angle of
  dominating texture and the texture direction index.
}
\description{
Calculates the angle of dominating texture and the texture
direction index of the Fourier spectrum image calculated
from a raster image (see Kedron et al. 2018).
}
\examples{
library(raster)

# import raster image
data(normforest)

# calculate Std and Stdi
stdvals <- std(normforest)

# extract each value
Std <- stdvals[1]
Stdi <- stdvals[2]
}
