% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{spk}
\alias{spk}
\title{Reduced Peak Height}
\usage{
spk(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the reduced peak height.
}
\description{
Determines the reduced peak height (Spk), the
height difference between the maximum y value of the
bearing area curve and the y value of the highest
intersection point of the least mean square line
fit to the flattest 40\% of the bearing area curve.
See Figure 2a from Kedron et al. (2018) for more details.
}
\examples{
# import raster image
data(normforest)

# determine the reduced peak height
Spk <- spk(normforest)
}
