#' Geo Grids
#'
#' @name grids
#' @docType data
#' @keywords data
#' @description There are now 141 grids available in this package and more online. To view a full list of available grids, see [here](https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json). To create and submit your own grid, see [here](https://hafen.github.io/grid-designer/). To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.
#' @rdname grids
#' @md
NULL

#' @name us_state_grid1
#' @description
#' * **us_state_grid1:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid2
#' @description
#' * **us_state_grid2:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid2
#' @rdname grids
#' @md
NULL

#' @name eu_grid1
#' @description
#' * **eu_grid1:** Grid layout for the 28 EU Countries Image reference [here](https://ichef.bbci.co.uk/news/660/media/images/70233000/gif/_70233868_eunames.gif).
#' @usage eu_grid1
#' @rdname grids
#' @md
NULL

#' @name aus_grid1
#' @description
#' * **aus_grid1:** Grid layout for the Australian States and Territories. Image reference [here](https://cloud.githubusercontent.com/assets/9496865/26334627/75a729d2-3fa5-11e7-88af-a1dd86b7ddf3.png). Thanks to [jonocarroll](https://github.com/jonocarroll).
#' @usage aus_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid1
#' @description
#' * **sa_prov_grid1:** Grid layout for the provinces of South Africa Image reference [here](https://camo.githubusercontent.com/14e357c36b6b72c0ef60e700d832b57aac87bddd/68747470733a2f2f7777772e736f7574686166726963612e746f2f70726f76696e6365732f5253415f62795f70726f76696e6365732e6a7067). Thanks to [jonmcalder](https://github.com/jonmcalder).
#' @usage sa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name gb_london_boroughs_grid
#' @description
#' * **gb_london_boroughs_grid:** Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the codes used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/13021448/26399784/3133d684-4076-11e7-8eac-1e74d023bf18.jpg). Thanks to [eldenvo](https://github.com/eldenvo).
#' @usage gb_london_boroughs_grid
#' @rdname grids
#' @md
NULL

#' @name nhs_scot_grid
#' @description
#' * **nhs_scot_grid:** Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the codes used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/24879214/26426113/253658d0-40cf-11e7-88b5-fe5ee7fda44f.png). Thanks to [jsphdms](https://github.com/jsphdms).
#' @usage nhs_scot_grid
#' @rdname grids
#' @md
NULL

#' @name india_grid1
#' @description
#' * **india_grid1:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg). Thanks to [meysubb](https://github.com/meysubb).
#' @usage india_grid1
#' @rdname grids
#' @md
NULL

#' @name india_grid2
#' @description
#' * **india_grid2:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg).
#' @usage india_grid2
#' @rdname grids
#' @md
NULL

#' @name argentina_grid1
#' @description
#' * **argentina_grid1:** Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations). Image reference [here](https://i.pinimg.com/736x/bf/cb/96/bfcb9654477c127d3b0e0b72d5be65fc.jpg). Thanks to [eliocamp](https://github.com/eliocamp).
#' @usage argentina_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid1
#' @description
#' * **br_states_grid1:** Grid for the 27 states of Brazil. Image reference [here](https://camo.githubusercontent.com/477627dce2610f18f1bf3850cd32fca01610656e/687474703a2f2f63656a656475696e66616e74696c2e7062776f726b732e636f6d2f662f313435383034313938342f4d61706142726173696c5369676c61732e676966). Thanks to [italocegatta](https://github.com/italocegatta).
#' @usage br_states_grid1
#' @rdname grids
#' @md
NULL

#' @name sea_grid1
#' @description
#' * **sea_grid1:** Grid for South East Asian countries. Image reference [here](https://camo.githubusercontent.com/694a275db0e89984f347ce8b49221352416d2c48/68747470733a2f2f7669676e65747465322e77696b69612e6e6f636f6f6b69652e6e65742f757461752f696d616765732f382f38322f536f757468656173745f617369612e6a70672f7265766973696f6e2f6c61746573743f63623d3230313130313230303431383034). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage sea_grid1
#' @rdname grids
#' @md
NULL

#' @name mys_grid1
#' @description
#' * **mys_grid1:** Grid for Malaysian states and territories. Image reference [here](https://camo.githubusercontent.com/cd22848f0b7b53d4ef7afc6d178a0e9579ecf2aa/68747470733a2f2f7777772e6d6170736f66776f726c642e636f6d2f6d616c61797369612f6d6170732f6d616c61797369612d706f6c69746963616c2d6d61702e6a7067). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage mys_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_regions_grid1
#' @description
#' * **fr_regions_grid1:** Land and overseas regions of France. Codes are INSEE codes. Image reference [here](https://camo.githubusercontent.com/b526c357a4c30cdd2e90700c6559381348111377/687474703a2f2f7777772e6361727465736672616e63652e66722f6361727465732f67656f677261706869652f63617274652d726567696f6e732e6a7067). Thanks to [mtmx](https://github.com/mtmx).
#' @usage fr_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name de_states_grid1
#' @description
#' * **de_states_grid1:** Grid for the German states ('Länder') Image reference [here](https://camo.githubusercontent.com/e144ebb2bdd2d82d8a4c34908cd68ab2b2388425/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f642f64332f5374617465735f6f665f4765726d616e792e737667). Thanks to [DominikVogel](https://github.com/DominikVogel).
#' @usage de_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_or_counties_grid1
#' @description
#' * **us_or_counties_grid1:** Grid for Oregon counties. Image reference [here](https://user-images.githubusercontent.com/11638312/27445795-01b77804-5730-11e7-919b-36cde8027706.jpg). Thanks to [aosmith16](https://github.com/aosmith16).
#' @usage us_or_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_wa_counties_grid1
#' @description
#' * **us_wa_counties_grid1:** Grid for Washington counties. Image reference [here](https://countymapsofwashington.com/aapics/washingstate.gif).
#' @usage us_wa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_counties_grid1
#' @description
#' * **us_in_counties_grid1:** Grid for Indiana counties. Image reference [here](https://upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Indiana_county_map.png/640px-Indiana_county_map.png). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage us_in_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_central_counties_grid1
#' @description
#' * **us_in_central_counties_grid1:** Grid for central Indiana counties. Image reference [here](https://camo.githubusercontent.com/eb31e821890a0c600f59234fb184335c2bf84423/687474703a2f2f7777772e736176692e6f72672f77702d636f6e74656e742f75706c6f6164732f323031352f30322f6d61702d312e6a7067). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage us_in_central_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid1
#' @description
#' * **se_counties_grid1:** Grid for counties of Sweden. Image reference [here](https://www.worldatlas.com/webimage/countrys/europe/lgcolor/secounties.gif). Thanks to [duleise](https://github.com/duleise).
#' @usage se_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sf_bay_area_counties_grid1
#' @description
#' * **sf_bay_area_counties_grid1:** Grid of the 9 San Francisco Bay Area counties. Image reference [here](https://user-images.githubusercontent.com/1275592/28043128-53be650a-6585-11e7-920e-4ad9a13bf1a5.png). Thanks to [Eunoia](https://github.com/Eunoia).
#' @usage sf_bay_area_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ua_region_grid1
#' @description
#' * **ua_region_grid1:** Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities). Image reference [here](https://camo.githubusercontent.com/0615706478de63da2c7c3c3b21fe92c6db6a2fee/687474703a2f2f696d61676573312e66616e706f702e636f6d2f696d616765732f696d6167655f75706c6f6164732f556b7261696e69616e2d6d61702d756b7261696e652d313135333138375f3733305f3530352e676966). Thanks to [woldemarg](https://github.com/woldemarg).
#' @usage ua_region_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid1
#' @description
#' * **mx_state_grid1:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [ikashnitsky](https://github.com/ikashnitsky).
#' @usage mx_state_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid2
#' @description
#' * **mx_state_grid2:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [diegovalle](https://github.com/diegovalle).
#' @usage mx_state_grid2
#' @rdname grids
#' @md
NULL

#' @name scotland_local_authority_grid1
#' @description
#' * **scotland_local_authority_grid1:** Grid layout for the local authorities of Scotland. Image reference [here](https://user-images.githubusercontent.com/1275592/28044967-3b508570-658f-11e7-99b5-b1d73c765c2e.png). Thanks to [davidhen](https://github.com/davidhen).
#' @usage scotland_local_authority_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid1
#' @description
#' * **us_state_without_DC_grid1:** Grid layout for US states (excluding DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [ejr248](https://github.com/ejr248).
#' @usage us_state_without_DC_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid1
#' @description
#' * **italy_grid1:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid2
#' @description
#' * **italy_grid2:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid2
#' @rdname grids
#' @md
NULL

#' @name be_province_grid1
#' @description
#' * **be_province_grid1:** Grid layout for provinces of Belgium plus Brussels, including names in three languages (French, Dutch, English) and Belgium internal codes (NIS). Image reference [here](https://camo.githubusercontent.com/efa2c894793585141da8f7b9789b184eacc8d781/687474703a2f2f7777772e657570656469612e636f6d2f696d616765732f636f6e74656e742f42656c6769756d5f526567696f6e732e676966). Thanks to [ericlecoutre](https://github.com/ericlecoutre).
#' @usage be_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid3
#' @description
#' * **us_state_grid3:** Grid layout for US states (including DC). Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [kanishkamisra](https://github.com/kanishkamisra).
#' @usage us_state_grid3
#' @rdname grids
#' @md
NULL

#' @name jp_prefs_grid1
#' @description
#' * **jp_prefs_grid1:** Grid layout for the prefectures of Japan. Image reference [here](https://camo.githubusercontent.com/bffec5ac4ae6507c1ca1b83570544f405b86b048/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f382f38372f49534f2d333136362d322d4a502e706e672f35313270782d49534f2d333136362d322d4a502e706e67). Thanks to [uribo](https://github.com/uribo).
#' @usage jp_prefs_grid1
#' @rdname grids
#' @md
NULL

#' @name ng_state_grid1
#' @description
#' * **ng_state_grid1:** Grid layout for the 37 Federal States of Nigeria. Image reference [here](https://camo.githubusercontent.com/fa12bca8fe3f3de3d7af707400adbc7fc4656cc3/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f382f38332f4e6967657269615f7374617465732e706e67). Thanks to [aledemogr](https://github.com/aledemogr).
#' @usage ng_state_grid1
#' @rdname grids
#' @md
NULL

#' @name bd_upazila_grid1
#' @description
#' * **bd_upazila_grid1:** Grid layout for Bangladesh 64 Upazilas. Image reference [here](https://camo.githubusercontent.com/df1e4aff5a3e0238afef97586d324d9b23acf27b/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32382f42445f4d61705f61646d696e2e7376672f38303070782d42445f4d61705f61646d696e2e7376672e706e67). Thanks to [aledemogr](https://github.com/aledemogr).
#' @usage bd_upazila_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid1
#' @description
#' * **spain_prov_grid1:** Grid layout for Provinces of Spain. Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [kintero](https://github.com/kintero).
#' @usage spain_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid1
#' @description
#' * **ch_cantons_grid1:** Grid layout for Cantons of Switzerland. Image reference [here](https://camo.githubusercontent.com/b3c99e5725cdb60fd60a66731c8492fdb0e09ab6/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f342f34612f537769747a65726c616e642532435f61646d696e6973747261746976655f6469766973696f6e735f2d5f64655f2d5f636f6c6f7265642e737667). Thanks to [tinu-schneider](https://github.com/tinu-schneider).
#' @usage ch_cantons_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid2
#' @description
#' * **ch_cantons_grid2:** Grid layout for Cantons of Switzerland. Image reference [here](https://user-images.githubusercontent.com/4510815/29034578-0485df5c-7b99-11e7-9ff8-67a7b687de12.png). Thanks to [rastrau](https://github.com/rastrau).
#' @usage ch_cantons_grid2
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid1
#' @description
#' * **china_prov_grid1:** Grid layout for Provinces of China. Image reference [here](https://user-images.githubusercontent.com/1275592/30039720-cf9c8532-9189-11e7-856b-a6ecf449ee0c.png). Thanks to [weiyunna](https://github.com/weiyunna).
#' @usage china_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name world_86countries_grid
#' @description
#' * **world_86countries_grid:** Grid layout for 86 countries in the world. Image reference [here](https://user-images.githubusercontent.com/1275592/30190118-0678aeb8-93ed-11e7-91b2-49738beb6f04.png). Thanks to [akangsha](https://github.com/akangsha).
#' @usage world_86countries_grid
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid2
#' @description
#' * **se_counties_grid2:** Grid for counties of Sweden. Image reference [here](https://user-images.githubusercontent.com/6022947/31674182-71150350-b361-11e7-9873-ffe319344c90.jpg). Thanks to [richardohrvall](https://github.com/richardohrvall).
#' @usage se_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name uk_regions1
#' @description
#' * **uk_regions1:** Grid for regions of the UK (aka EU standard NUTS 1 areas). Image reference [here](https://user-images.githubusercontent.com/1275592/32032394-d394b24a-b9bb-11e7-91e8-fe4da69ba005.jpg). Thanks to [paulb20](https://github.com/paulb20).
#' @usage uk_regions1
#' @rdname grids
#' @md
NULL

#' @name us_state_contiguous_grid1
#' @description
#' * **us_state_contiguous_grid1:** Grid layout for the contiguous US states (including DC). Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [andrewsr](https://github.com/andrewsr).
#' @usage us_state_contiguous_grid1
#' @rdname grids
#' @md
NULL

#' @name sk_province_grid1
#' @description
#' * **sk_province_grid1:** Grid layout for South Korean sis and dos (metropolitan/special/autonomous cities and provinces). Image reference [here](https://tong.visitkorea.or.kr/enu/images/koreastay/korea_map.jpg). Thanks to [heon131](https://github.com/heon131).
#' @usage sk_province_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_aargau_districts_grid1
#' @description
#' * **ch_aargau_districts_grid1:** Grid layout for Districts of the Canton of Aargau, Switzerland. Image reference [here](https://user-images.githubusercontent.com/31518032/32281394-fcd761d0-bf1e-11e7-9dcc-ae52307eeafd.png). Thanks to [zumbov2](https://github.com/zumbov2).
#' @usage ch_aargau_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name jo_gov_grid1
#' @description
#' * **jo_gov_grid1:** Grid layout for Governorates of Jordan. Image reference [here](https://user-images.githubusercontent.com/1275592/82837533-32964c00-9e7e-11ea-841f-8ab3a202b888.png). Thanks to [aledemogr](https://github.com/aledemogr).
#' @usage jo_gov_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_ccaa_grid1
#' @description
#' * **spain_ccaa_grid1:** Grid layout for Spanish 'Comunidades Autónomas'. Image reference [here](https://user-images.githubusercontent.com/1275592/54301007-558b5780-457b-11e9-8796-9f7a3859820d.jpg). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage spain_ccaa_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid2
#' @description
#' * **spain_prov_grid2:** Grid layout for Provinces of Spain. Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage spain_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name world_countries_grid1
#' @description
#' * **world_countries_grid1:** Grid layout for countries of the world, with a few exclusions. See . Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage world_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid2
#' @description
#' * **br_states_grid2:** Grid for the 27 states of Brazil. Image reference [here](https://brazil-help.com/mapa_do_brasil.gif). Thanks to [hafen](https://github.com/hafen).
#' @usage br_states_grid2
#' @rdname grids
#' @md
NULL

#' @name china_city_grid1
#' @description
#' * **china_city_grid1:** Grid layout of cities in China. Image reference [here](https://user-images.githubusercontent.com/1275592/82846130-3f299d00-9e9c-11ea-8a38-efb4ade0e502.png). Thanks to [CharleneDeng1](https://github.com/CharleneDeng1).
#' @usage china_city_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_seoul_district_grid1
#' @description
#' * **kr_seoul_district_grid1:** Grid layout of Seoul's 25 districts. Image reference [here](https://user-images.githubusercontent.com/1275592/38068875-494e49a8-32c8-11e8-8ace-b91982fe486f.png). Thanks to [yonghah](https://github.com/yonghah).
#' @usage kr_seoul_district_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid1
#' @description
#' * **nz_regions_grid1:** Grid layout for regions of New Zealand. Image reference [here](https://camo.githubusercontent.com/3db8d49d196be1e70ed0ebd4dcedf6fefc8fcfed/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32312f4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672f3130303070782d4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672e706e67). Thanks to [pierreroudier](https://github.com/pierreroudier).
#' @usage nz_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name sl_regions_grid1
#' @description
#' * **sl_regions_grid1:** Grid layout of Slovenian regions. Image reference [here](https://user-images.githubusercontent.com/1275592/38069181-df2cbcb0-32c9-11e8-8a5b-0528f3e9e81c.png). Thanks to [SR1986](https://github.com/SR1986).
#' @usage sl_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_census_div_grid1
#' @description
#' * **us_census_div_grid1:** Grid layout of US Census divisions. Image reference [here](https://camo.githubusercontent.com/154dc45aaff776642ac7a5ce257106f70c97d441/68747470733a2f2f7777772e6569612e676f762f636f6e73756d7074696f6e2f636f6d6d65726369616c2f696d616765732f63656e646976636f2e676966). Thanks to [mkiang](https://github.com/mkiang).
#' @usage us_census_div_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_tucuman_province_grid1
#' @description
#' * **ar_tucuman_province_grid1:** Grid layout for Argentina Tucumán Province political divisions (departments) Image reference [here](https://camo.githubusercontent.com/03faf8f653fffe62e0beb2ad9d36cbcbce094c10/687474703a2f2f7777772e636f6d6f6c6c65676172612e636f6d2f696d616765732f617267656e74696e612f646570617274616d656e746f732d64652d6c612d70726f76696e6369612d64652d747563756d616e2e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_tucuman_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nh_counties_grid1
#' @description
#' * **us_nh_counties_grid1:** Grid layout for the 10 counties in New Hampshire. Image reference [here](https://en.wikipedia.org/wiki/List_of_counties_in_New_Hampshire#/media/File:New_Hampshire_Locator_Map.PNG). Thanks to [ghost](https://github.com/ghost).
#' @usage us_nh_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid2
#' @description
#' * **china_prov_grid2:** Grid layout for Provinces of China. Image reference [here](https://user-images.githubusercontent.com/36669758/37746305-f5c138f4-2d4f-11e8-8a48-2a21513ea828.png). Thanks to [jw2531](https://github.com/jw2531).
#' @usage china_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name pl_voivodeships_grid1
#' @description
#' * **pl_voivodeships_grid1:** Grid layout for Polish voivodeships (provinces) Image reference [here](https://user-images.githubusercontent.com/5550348/37672220-69c03caa-2c65-11e8-857e-2955f25f55bf.png). Thanks to [erzk](https://github.com/erzk).
#' @usage pl_voivodeships_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ia_counties_grid1
#' @description
#' * **us_ia_counties_grid1:** Grid layout for counties in Iowa Image reference [here](https://camo.githubusercontent.com/9a5e5d3c974c85a6d3ee87b1d2858940476e74c0/68747470733a2f2f7777772e6469676974616c2d746f706f2d6d6170732e636f6d2f636f756e74792d6d61702f696f77612d636f756e74792d6d61702e676966). Thanks to [jrennyb](https://github.com/jrennyb).
#' @usage us_ia_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_id_counties_grid1
#' @description
#' * **us_id_counties_grid1:** Grid layout for counties in Idaho Image reference [here](https://camo.githubusercontent.com/dbe964d952ecd106d2a9f677950852f957be1281/68747470733a2f2f67656f6c6f67792e636f6d2f636f756e74792d6d61702f696461686f2d636f756e74792d6d61702e676966). Thanks to [hathawayj](https://github.com/hathawayj).
#' @usage us_id_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_cordoba_dep_grid1
#' @description
#' * **ar_cordoba_dep_grid1:** Grid layout for departments of Cordoba province in Argentina. Image reference [here](https://user-images.githubusercontent.com/12114624/38060507-45d03c66-32a8-11e8-81c0-3ef7675dbf4e.png). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_cordoba_dep_grid1
#' @rdname grids
#' @md
NULL

#' @name us_fl_counties_grid1
#' @description
#' * **us_fl_counties_grid1:** Grid for Florida counties. Image reference [here](https://user-images.githubusercontent.com/1275592/38098066-df3a7690-332b-11e8-9e4f-9123379e412e.jpg). Thanks to [ejr248](https://github.com/ejr248).
#' @usage us_fl_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_buenosaires_communes_grid1
#' @description
#' * **ar_buenosaires_communes_grid1:** Grid for communes of Buenos Aires, Argentina. Image reference [here](https://camo.githubusercontent.com/1397b556f643333f5c0afbf074e12b316ea8f063/687474703a2f2f7777772e6e6f746963696172696f7375722e636f6d2e61722f77702d636f6e74656e742f75706c6f6164732f323031322f30322f434f4d4e41532d4d4150412e676966). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_buenosaires_communes_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid2
#' @description
#' * **nz_regions_grid2:** Grid layout for regions of New Zealand. Image reference [here](https://camo.githubusercontent.com/3db8d49d196be1e70ed0ebd4dcedf6fefc8fcfed/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32312f4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672f3130303070782d4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672e706e67). Thanks to [pierreroudier](https://github.com/pierreroudier).
#' @usage nz_regions_grid2
#' @rdname grids
#' @md
NULL

#' @name oecd_grid1
#' @description
#' * **oecd_grid1:** Grid layout for OECD member countries. Image reference [here](https://camo.githubusercontent.com/9afd6ca4c97374e8d5b69c73325937e6de57ade3/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f342f34632f4f4543445f6d656d6265725f7374617465735f6d61702e7376672f3130303070782d4f4543445f6d656d6265725f7374617465735f6d61702e7376672e706e67). Thanks to [arcruz0](https://github.com/arcruz0).
#' @usage oecd_grid1
#' @rdname grids
#' @md
NULL

#' @name ec_prov_grid1
#' @description
#' * **ec_prov_grid1:** Grid layout for provinces of Ecuador Image reference [here](https://camo.githubusercontent.com/7eabd24db749e5335f13c911df65f15516c10bef/68747470733a2f2f65637561646f726e6f7469636961732e636f6d2f77702d636f6e74656e742f75706c6f6164732f323031372f30342f70726f76696e636961732d65637561646f722e6a7067). Thanks to [Ricardo95RM](https://github.com/Ricardo95RM).
#' @usage ec_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name nl_prov_grid1
#' @description
#' * **nl_prov_grid1:** Grid layout for provinces of Netherlands Image reference [here](https://camo.githubusercontent.com/a094b2603eff7e4c45b9fbdbbfd7b5637473354c/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f632f63632f4d61705f70726f76696e6365735f4e65746865726c616e64732d656e2e737667). Thanks to [ruditurksema](https://github.com/ruditurksema).
#' @usage nl_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ca_prov_grid1
#' @description
#' * **ca_prov_grid1:** Grid layout for provinces of Canada Image reference [here](https://camo.githubusercontent.com/5a0ad66e98796b817e506fe3127d48d7277a74a8/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f312f31342f506f6c69746963616c5f6d61705f6f665f43616e6164612e706e672f38303070782d506f6c69746963616c5f6d61705f6f665f43616e6164612e706e67). Thanks to [michael-chong](https://github.com/michael-chong).
#' @usage ca_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nc_counties_grid1
#' @description
#' * **us_nc_counties_grid1:** Grid layout for Counties of North Carolina, United States Image reference [here](https://camo.githubusercontent.com/50bf9a4f4861fa11dba4ea66f8f7712eb1b59593/68747470733a2f2f7765622e6c69622e756e632e6564752f6e632d6d6170732f696d616765732f686f74636f756e74796d61702e676966). Thanks to [mtdukes](https://github.com/mtdukes).
#' @usage us_nc_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_ciudad_prov_grid1
#' @description
#' * **mx_ciudad_prov_grid1:** Grid layout for Districts of Mexico City, Mexico Image reference [here](https://camo.githubusercontent.com/ef6379d66d92e1ea289fcd8522853ec4348499d7/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f362f36652f4d582d44462d4469766973692543332542336e5f706f6c254333254144746963612e7376672f38303070782d4d582d44462d4469766973692543332542336e5f706f6c254333254144746963612e7376672e706e67). Thanks to [Ivangea](https://github.com/Ivangea).
#' @usage mx_ciudad_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name bg_prov_grid1
#' @description
#' * **bg_prov_grid1:** Grid layout for provinces of Bulgaria Image reference [here](https://camo.githubusercontent.com/46872c5c1703af4739df87eca5075ae91fe83833/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f382f38362f526567696f6e735f6f665f42756c67617269615f4d61702e706e67). Thanks to [savinastoitsova](https://github.com/savinastoitsova).
#' @usage bg_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_hhs_regions_grid1
#' @description
#' * **us_hhs_regions_grid1:** This grid approximates the U.S. Health and Human Services Region map Image reference [here](https://camo.githubusercontent.com/dd6f1a0c7749dd111d71be74f344d573eaad52f5/68747470733a2f2f7777772e6868732e676f762f73697465732f64656661756c742f66696c65732f6965612f696d616765732f726567696f6e736d61702e6a7067). Thanks to [akitepowell](https://github.com/akitepowell).
#' @usage us_hhs_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name tw_counties_grid1
#' @description
#' * **tw_counties_grid1:** Grid layout for Counties of Taiwan Image reference [here](https://camo.githubusercontent.com/b51d87c85c060ff96335274808600f7984f19e56/68747470733a2f2f692e696d6775722e636f6d2f744a5a6a4f4f422e706e67). Thanks to [csh484912274](https://github.com/csh484912274).
#' @usage tw_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name tw_counties_grid2
#' @description
#' * **tw_counties_grid2:** Grid layout for Counties of Taiwan including Lienchiang County Image reference [here](https://camo.githubusercontent.com/b26bf4a5ff70294daaa6db508e06a82f2afd902f/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f652f65372f54616977616e5f524f435f706f6c69746963616c5f6469766973696f6e735f6c6162656c65642e7376672f3132303070782d54616977616e5f524f435f706f6c69746963616c5f6469766973696f6e735f6c6162656c65642e7376672e706e67). Thanks to [csh484912274](https://github.com/csh484912274).
#' @usage tw_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name af_prov_grid1
#' @description
#' * **af_prov_grid1:** Grid layout for Provinces of Afghanistan Image reference [here](https://camo.githubusercontent.com/86d2b1807e37f2d3009da212a870b58f9b091d67/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f342f34342f41666768616e697374616e5f70726f76696e6365735f6e756d62657265642e706e67). Thanks to [jrennyb](https://github.com/jrennyb).
#' @usage af_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_mi_counties_grid1
#' @description
#' * **us_mi_counties_grid1:** Grid layout for Counties of Michigan, United States Image reference [here](https://camo.githubusercontent.com/834a8eaa5d2bc37ec003d06d0cb5eee53954320d/687474703a2f2f7777772d706572736f6e616c2e756d6963682e6564752f7e62626f776d616e2f62697264732f4352414d5f696d6167656e756d732e676966). Thanks to [jrennyb](https://github.com/jrennyb).
#' @usage us_mi_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name pe_prov_grid1
#' @description
#' * **pe_prov_grid1:** Grid layout for Provinces of Peru Image reference [here](https://camo.githubusercontent.com/6c8d13fd43bf90b6bc7dbc3bff6c5a2abcda2e52/68747470733a2f2f696d6167656e6573746f74616c65732e636f6d2f77702d636f6e74656e742f75706c6f6164732f323031382f30342f4d6170612d706f6c697469636f2d64656c2d506572752d322d373638783933362e706e67). Thanks to [jmcastagnetto](https://github.com/jmcastagnetto).
#' @usage pe_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid2
#' @description
#' * **sa_prov_grid2:** Grid layout for Provinces of South Africa Image reference [here](https://camo.githubusercontent.com/14e357c36b6b72c0ef60e700d832b57aac87bddd/68747470733a2f2f7777772e736f7574686166726963612e746f2f70726f76696e6365732f5253415f62795f70726f76696e6365732e6a7067). Thanks to [kamermanpr](https://github.com/kamermanpr).
#' @usage sa_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid3
#' @description
#' * **mx_state_grid3:** Grid layout for States of Mexico Image reference [here](https://camo.githubusercontent.com/3b62258772065fe17c3a7a6a99b889251fa53d4a/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f632f63322f506f6c69746963616c5f6469766973696f6e735f6f665f4d657869636f2d656e2e7376672f3132303070782d506f6c69746963616c5f6469766973696f6e735f6f665f4d657869636f2d656e2e7376672e706e67). Thanks to [ikashnitsky](https://github.com/ikashnitsky).
#' @usage mx_state_grid3
#' @rdname grids
#' @md
NULL

#' @name cn_bj_districts_grid1
#' @description
#' * **cn_bj_districts_grid1:** Grids for Administrative Districts of Beijing, China Image reference [here](https://user-images.githubusercontent.com/1275592/54295842-0ccea100-4571-11e9-8d3f-c60f4f7f2c0a.png). Thanks to [shiedelweiss](https://github.com/shiedelweiss).
#' @usage cn_bj_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_va_counties_grid1
#' @description
#' * **us_va_counties_grid1:** Grids for Counties of Virginia, United States Image reference [here](https://camo.githubusercontent.com/ad5f91421db6241dae5a292d841c13475b39452e/68747470733a2f2f67656f6c6f67792e636f6d2f73746174652d6d61702f6d6170732f76697267696e69612d636f756e74792d6d61702e676966). Thanks to [joshyazman](https://github.com/joshyazman).
#' @usage us_va_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_mo_counties_grid1
#' @description
#' * **us_mo_counties_grid1:** Grids for Counties of Missouri, United States Image reference [here](https://camo.githubusercontent.com/aecf36302e81059f92f399587faae8c88a81d6711ac468438c8c6ce71c2fd88a/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f322f32342f4d6973736f7572695f4c6f6361746f725f4d61702e504e47). Thanks to [Yanqi-Xu](https://github.com/Yanqi-Xu).
#' @usage us_mo_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name cl_santiago_prov_grid1
#' @description
#' * **cl_santiago_prov_grid1:** Communes of Santiago Province, Chile Image reference [here](https://camo.githubusercontent.com/64e592a3c79ce5b03024cccfe43a9fca64ebffe1/68747470733a2f2f692e696d6775722e636f6d2f457361444675762e706e67). Thanks to [robsalasco](https://github.com/robsalasco).
#' @usage cl_santiago_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_tx_capcog_counties_grid1
#' @description
#' * **us_tx_capcog_counties_grid1:** This is a grid of a 10 county planning region around Austin, Texas, United States Image reference [here](https://camo.githubusercontent.com/029adb9992cb52f8b655935a8ea67f3b2ba2778f/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f322f32332f434150434f472e706e67). Thanks to [mth444](https://github.com/mth444).
#' @usage us_tx_capcog_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sg_planning_area_grid1
#' @description
#' * **sg_planning_area_grid1:** Grids for Planning Areas of Singapore Image reference [here](https://user-images.githubusercontent.com/1275592/54297744-a9467280-4574-11e9-99f7-bdb62bbb34b4.png). Thanks to [Elenafuyi](https://github.com/Elenafuyi).
#' @usage sg_planning_area_grid1
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid1
#' @description
#' * **in_state_ut_grid1:** Grid of Indian States and Union Territories Image reference [here](https://user-images.githubusercontent.com/1275592/54297966-1f4ad980-4575-11e9-8e8c-5006c91fccd1.png). Thanks to [seanangio](https://github.com/seanangio).
#' @usage in_state_ut_grid1
#' @rdname grids
#' @md
NULL

#' @name cn_fujian_prov_grid1
#' @description
#' * **cn_fujian_prov_grid1:** Grid of counties of Fujian Province, China Image reference [here](https://user-images.githubusercontent.com/1275592/54298318-c2035800-4575-11e9-8d68-868cc76315df.png). Thanks to [nannanchen333](https://github.com/nannanchen333).
#' @usage cn_fujian_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ca_quebec_electoral_districts_grid1
#' @description
#' * **ca_quebec_electoral_districts_grid1:** Grid of Electoral Districts of Québec, Canada Image reference [here](https://upload.wikimedia.org/wikipedia/commons/thumb/f/f4/2022_Québec_General_Election_Map.svg/1020px-2022_Québec_General_Election_Map.svg.png?20221230235759). Thanks to [jhroy](https://github.com/jhroy).
#' @usage ca_quebec_electoral_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name nl_prov_grid2
#' @description
#' * **nl_prov_grid2:** Grid with the provinces of The Netherlands with codes that are used by the statistical institute of NL Image reference [here](https://camo.githubusercontent.com/2b6204b5f9856fadeb32a6042fe1fd48cbb4b06f/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f332f33302f4e656465726c616e64736550726f76696e636965734c617267652e706e67). Thanks to [edwindj](https://github.com/edwindj).
#' @usage nl_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name cn_bj_districts_grid2
#' @description
#' * **cn_bj_districts_grid2:** Grid with districts of Beijing, China Image reference [here](https://user-images.githubusercontent.com/1275592/54295842-0ccea100-4571-11e9-8d3f-c60f4f7f2c0a.png). Thanks to [zouhx11](https://github.com/zouhx11).
#' @usage cn_bj_districts_grid2
#' @rdname grids
#' @md
NULL

#' @name ar_santiago_del_estero_prov_grid1
#' @description
#' * **ar_santiago_del_estero_prov_grid1:** Grid with districts of Santiago del Estero Province, Argentina Image reference [here](https://camo.githubusercontent.com/5b7e451b3ccc8550c31644cf897c096256cc01ffc9c7f7f0a1284b29389fa34a/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f622f62382f446570617274616d656e746f5f416775697272655f25323853616e746961676f5f64656c5f45737465726f5f2d5f417267656e74696e612532392e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_santiago_del_estero_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_formosa_prov_grid1
#' @description
#' * **ar_formosa_prov_grid1:** Grid with districts of Formosa Province, Argentina Image reference [here](https://camo.githubusercontent.com/481f581ddcd2ae7a09cd47fb4779dc904a0d6b75/687474703a2f2f7777772e74656d7075736167726f2e636f6d2e61722f696d672f666f726d6f73612f6469766973696f6e706f6c69746963612e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_formosa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_chaco_prov_grid1
#' @description
#' * **ar_chaco_prov_grid1:** Grid with districts of Chaco Province, Argentina Image reference [here](https://camo.githubusercontent.com/35120f89439dbdd5c147d3925d948ae6a955b0c8/68747470733a2f2f657370616e6f6c2e6d6170736f66776f726c642e636f6d2f77702d636f6e74656e742f75706c6f6164732f323031342f30362f6d6170612d64656c2d636861636f2e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_chaco_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_catamarca_prov_grid1
#' @description
#' * **ar_catamarca_prov_grid1:** Grid with districts of Catamarca Province, Argentina Image reference [here](https://camo.githubusercontent.com/a5997d24eda54a3ebce19a8bad590348e3926142db79d665c9a8c17b72c08d3c/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32372f416d6261746f5f25323850726f76696e6369615f64655f436174616d617263615f2d5f417267656e74696e612532392e7376672f3139323070782d416d6261746f5f25323850726f76696e6369615f64655f436174616d617263615f2d5f417267656e74696e612532392e7376672e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_catamarca_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_jujuy_prov_grid1
#' @description
#' * **ar_jujuy_prov_grid1:** Grid with districts of Jujuy Province, Argentina Image reference [here](https://camo.githubusercontent.com/9ccfff93636f3067deca6ead3cd7320ef0ff76b0f6628541baf2f17f9a612e14/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f372f37662f436f6368696e6f63615f25323850726f76696e6369615f64655f4a756a75795f2d5f417267656e74696e612532392e7376672f3235363070782d436f6368696e6f63615f25323850726f76696e6369615f64655f4a756a75795f2d5f417267656e74696e612532392e7376672e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_jujuy_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_neuquen_prov_grid1
#' @description
#' * **ar_neuquen_prov_grid1:** Grid with districts of Neuquen Province, Argentina Image reference [here](https://camo.githubusercontent.com/5cda1ad7e1b4a39c6932a9c4cbfe7f2dc7cd9cd6/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f662f66322f4d6170615f64655f64656e73696461645f64655f706f626c6163696f6e5f323031305f70726f76696e6369615f64656c5f6e65757175656e2e7376672f32353070782d4d6170615f64655f64656e73696461645f64655f706f626c6163696f6e5f323031305f70726f76696e6369615f64656c5f6e65757175656e2e7376672e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_neuquen_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_san_luis_prov_grid1
#' @description
#' * **ar_san_luis_prov_grid1:** Grid with districts of San Luis Province, Argentina Image reference [here](https://camo.githubusercontent.com/a1c246c3e3b95e7186355a5ac473bb68ac2818b4/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f612f61342f4469766973692543332542336e5f706f6c254333254144746963615f64655f6c615f50726f76696e6369615f64655f53616e5f4c7569735f2d417267656e74696e612d2e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_san_luis_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_san_juan_prov_grid1
#' @description
#' * **ar_san_juan_prov_grid1:** Grid with districts of San Juan Province, Argentina Image reference [here](https://camo.githubusercontent.com/a29a04aa5dbd26fd425abe01f07a60bb6d563013/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f302f30652f4d6170615f64655f6c615f50726f76696e6369615f64655f53616e5f4a75616e5f253238417267656e74696e612532395f636f6e5f6469766973692543332542336e5f706f6c254333254144746963612e6a70672f35303070782d4d6170615f64655f6c615f50726f76696e6369615f64655f53616e5f4a75616e5f253238417267656e74696e612532395f636f6e5f6469766973692543332542336e5f706f6c254333254144746963612e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_san_juan_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_santa_fe_prov_grid1
#' @description
#' * **ar_santa_fe_prov_grid1:** Grid with districts of Santa Fe Province, Argentina Image reference [here](https://camo.githubusercontent.com/e3812264494cb18796173767991749601b0256d6/68747470733a2f2f7777772e66616d696c797365617263682e6f72672f77696b692f65732f696d675f617574682e7068702f7468756d622f372f37642f53616e74615f46655f50726f76696e6369615f4d6170612e706e672f33373070782d53616e74615f46655f50726f76696e6369615f4d6170612e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_santa_fe_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_la_rioja_prov_grid1
#' @description
#' * **ar_la_rioja_prov_grid1:** Grid with districts of La Rioja Province, Argentina Image reference [here](https://camo.githubusercontent.com/03c888b6d01726c6832975a1535a046d91cd26ab/68747470733a2f2f7777772e66616d696c797365617263682e6f72672f77696b692f65732f696d675f617574682e7068702f7468756d622f642f64612f4c615f52696f6a615f50726f76696e6369615f4d6170612e706e672f36323070782d4c615f52696f6a615f50726f76696e6369615f4d6170612e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_la_rioja_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_mendoza_prov_grid1
#' @description
#' * **ar_mendoza_prov_grid1:** Grid with districts of Mendoza Province, Argentina Image reference [here](https://camo.githubusercontent.com/83ccf5cfdde385d5aa502812b61efafdcc769ecb/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f332f33342f4d6170615f64655f6c615f6469766973692543332542336e5f706f6c254333254144746963615f64655f6c615f706369612e5f64655f4d656e6f7a615f2d417267656e74696e612d2e6a70672f38303070782d4d6170615f64655f6c615f6469766973692543332542336e5f706f6c254333254144746963615f64655f6c615f706369612e5f64655f4d656e6f7a615f2d417267656e74696e612d2e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_mendoza_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_salta_prov_grid1
#' @description
#' * **ar_salta_prov_grid1:** Grid with districts of Salta Province, Argentina Image reference [here](https://camo.githubusercontent.com/9232d808104ddd3ab3983f9a670eb507a4d95e51/687474703a2f2f312e62702e626c6f6773706f742e636f6d2f5f564a6b71374771783743512f52303349467549766e30492f41414141414141414141632f75336655614c744e6a53672f733430302f646570617274616d656e746f732b64652b53616c74612e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_salta_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_rio_negro_prov_grid1
#' @description
#' * **ar_rio_negro_prov_grid1:** Grid with districts of Rio Negro Province, Argentina Image reference [here](https://camo.githubusercontent.com/123414ec4933d38f3b991cc8d669138594d68b17/68747470733a2f2f63646e2e7468696e676c696e6b2e6d652f6170692f696d6167652f3536353530363334383233343537313737362f313234302f31302f7363616c65746f7769647468). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_rio_negro_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name uy_departamentos_grid1
#' @description
#' * **uy_departamentos_grid1:** Grid with Departamentos of Uruguay Image reference [here](https://camo.githubusercontent.com/a56f891616c613ba8c120434f3d0786e005f1df8/68747470733a2f2f6d6170616d756e64692e6f6e6c696e652f77702d636f6e74656e742f75706c6f6164732f323031382f31312f6d6170612d706f6c697469636f2d64652d757275677561792e6a7067). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage uy_departamentos_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_buenos_aires_prov_electoral_dist_grid1
#' @description
#' * **ar_buenos_aires_prov_electoral_dist_grid1:** Grid with Electoral Districts of Buenos Aires Province, Argentina Image reference [here](https://camo.githubusercontent.com/3803a78b6fc2ca41ffd7bdf3a7a503af1cb48ba7/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f622f62302f53656363696f6e65735f656c6563746f72616c65735f64655f6c615f70726f76696e6369615f64655f4275656e6f735f41697265732e7376672f38303070782d53656363696f6e65735f656c6563746f72616c65735f64655f6c615f70726f76696e6369615f64655f4275656e6f735f41697265732e7376672e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_buenos_aires_prov_electoral_dist_grid1
#' @rdname grids
#' @md
NULL

#' @name europe_countries_grid1
#' @description
#' * **europe_countries_grid1:** Grid layout for all European countries except Vatican City, Monaco, San Marino and Liechtenstein Image reference [here](https://user-images.githubusercontent.com/38204689/38485856-23e709b6-3bd3-11e8-8bc7-ae5cd892419c.png). Thanks to [THargreaves](https://github.com/THargreaves).
#' @usage europe_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name argentina_grid2
#' @description
#' * **argentina_grid2:** Grid layout for Argentina without Islas Malvinas and Antártida Argentina Image reference [here](https://camo.githubusercontent.com/f14f25ac3e42051994f5fd4c53e2718c2b2290aa/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f392f39652f4d61705f6f665f417267656e74696e615f776974685f70726f76696e6365735f6e616d65735f656e2e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage argentina_grid2
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid2
#' @description
#' * **us_state_without_DC_grid2:** Grid layout for United States with AK and HI flush with CA Image reference [here](https://camo.githubusercontent.com/b446d99f631d067562f50a57449eddb0b89c1acf/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f612f61352f4d61705f6f665f5553415f776974685f73746174655f6e616d65732e737667). Thanks to [christophercannon](https://github.com/christophercannon).
#' @usage us_state_without_DC_grid2
#' @rdname grids
#' @md
NULL

#' @name jp_prefs_grid2
#' @description
#' * **jp_prefs_grid2:** Grid layout for Prefectures of Japan Image reference [here](https://user-images.githubusercontent.com/19657164/46902315-4c2f8d80-cefe-11e8-90bb-661771ce2836.JPG). Thanks to [Ryo-N7](https://github.com/Ryo-N7).
#' @usage jp_prefs_grid2
#' @rdname grids
#' @md
NULL

#' @name na_regions_grid1
#' @description
#' * **na_regions_grid1:** Regions of Namibia Image reference [here](https://camo.githubusercontent.com/a4519aa536614e5f5fc0839ff1a6208b9a79716a/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f632f63302f4e616d696269615f6e756d62657265645f636f6c6f7265645f726567696f6e735f456e676c697368312e706e672f38303070782d4e616d696269615f6e756d62657265645f636f6c6f7265645f726567696f6e735f456e676c697368312e706e67). Thanks to [stedy](https://github.com/stedy).
#' @usage na_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name mm_state_grid1
#' @description
#' * **mm_state_grid1:** States of Myanmar Image reference [here](https://camo.githubusercontent.com/603ad86c99a004316ac5b53c9dd73d9ce0f73811/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f372f37612f4275726d615f61646d696e6973747261746976655f6469766973696f6e732e7376672f33303070782d4275726d615f61646d696e6973747261746976655f6469766973696f6e732e7376672e706e67). Thanks to [htinkyawaye](https://github.com/htinkyawaye).
#' @usage mm_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid1
#' @description
#' * **us_state_with_DC_PR_grid1:** United States of America including Washington, D.C. and Puerto Rico Image reference [here](https://camo.githubusercontent.com/c1ac0dd02771e221d5003984ab1ce518b864ef0c/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f612f61632f4d61705f6f665f5553415f50522e7376672f3132303070782d4d61705f6f665f5553415f50522e7376672e706e67). Thanks to [krothkin](https://github.com/krothkin).
#' @usage us_state_with_DC_PR_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_departements_grid1
#' @description
#' * **fr_departements_grid1:** Grid for France's departements, the second levels of administrative boundaries after the regions Image reference [here](https://camo.githubusercontent.com/790b9e52bccf40a4934c37ce58ea7726831811284200fc88abebce1ea22304b6/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f622f62312f50726f76696e6365735f6f665f4672616e63655f2532386e756d657265642532392e7376672f3139323070782d50726f76696e6365735f6f665f4672616e63655f2532386e756d657265642532392e7376672e706e67). Thanks to [tvroylandt](https://github.com/tvroylandt).
#' @usage fr_departements_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_salta_prov_grid2
#' @description
#' * **ar_salta_prov_grid2:** Grids for Salta Province Argentina Image reference [here](https://camo.githubusercontent.com/bd75334802b6ef199dca758018335f162671c1d1e95147d9dabd4b0dc0d18f2c/687474703a2f2f312e62702e626c6f6773706f742e636f6d2f5f564a6b71374771783743512f52303349467549766e30492f41414141414141414141632f75336655614c744e6a53672f733430302f646570617274616d656e746f732b64652b53616c74612e6a7067). Thanks to [tartagalensis](https://github.com/tartagalensis).
#' @usage ar_salta_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name ie_counties_grid1
#' @description
#' * **ie_counties_grid1:** Ireland counties. Code is the car number plate abbreviation for Republic counties, similar for the six counties of Northern Ireland. Tipperary is split North / South for historical reasons Image reference [here](https://camo.githubusercontent.com/6497a5d179e5e3e64952f0334422bc0c2f634324/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f392f39632f4972656c616e645f747261645f636f756e746965735f6e616d65642e737667). Thanks to [eugene100hickey](https://github.com/eugene100hickey).
#' @usage ie_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sg_regions_grid1
#' @description
#' * **sg_regions_grid1:** Urban planning regions of Singapore Image reference [here](https://camo.githubusercontent.com/b5d68deaeb825640e7bf70a4965f6378b859bf22/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f392f39382f53696e6761706f72655f506c616e6e696e675f526567696f6e732e706e672f3130323470782d53696e6761706f72655f506c616e6e696e675f526567696f6e732e706e67). Thanks to [erhuttk](https://github.com/erhuttk).
#' @usage sg_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ny_counties_grid1
#' @description
#' * **us_ny_counties_grid1:** Counties of New York State, United States Image reference [here](https://camo.githubusercontent.com/3792aae01199eecb778026ab8942c658896a1846/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f642f64622f4e65775f596f726b5f436f756e746965732e737667). Thanks to [jjdfsny](https://github.com/jjdfsny).
#' @usage us_ny_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ru_federal_subjects_grid1
#' @description
#' * **ru_federal_subjects_grid1:** Federal Subjects of Russia Image reference [here](https://camo.githubusercontent.com/a47b5ea20c00d051979e11a5f6641dfffc4c4c94/68747470733a2f2f7777772e776f726c6461746c61732e636f6d2f722f773732382d683432352d63373238783432352f75706c6f61642f66362f33362f37632f7368757474657273746f636b2d3634313836353833352e6a7067). Thanks to [ParanoidAndroid18](https://github.com/ParanoidAndroid18).
#' @usage ru_federal_subjects_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ca_counties_grid1
#' @description
#' * **us_ca_counties_grid1:** Counties of the State of California, United States Image reference [here](https://camo.githubusercontent.com/796f370c0bd94a402e4ccf2d755e3664b0ec31ee/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f382f38392f43616c69666f726e69615f636f756e74795f6d61705f2532386c6162656c65642532392e7376672f38303070782d43616c69666f726e69615f636f756e74795f6d61705f2532386c6162656c65642532392e7376672e706e67). Thanks to [MartinLe5](https://github.com/MartinLe5).
#' @usage us_ca_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name lk_districts_grid1
#' @description
#' * **lk_districts_grid1:** Second level administrative divisions of Sri Lanka Image reference [here](https://camo.githubusercontent.com/97b57a2d650118c1a5596330824feb7c4eacbcfd/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f632f63632f4469737472696374735f6f665f5372695f4c616e6b612e706e672f3132303070782d4469737472696374735f6f665f5372695f4c616e6b612e706e67). Thanks to [thiyangt](https://github.com/thiyangt).
#' @usage lk_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid3
#' @description
#' * **us_state_without_DC_grid3:** United States grid without Washington, D.C Image reference [here](https://camo.githubusercontent.com/5038126fbe0052e7d42602dc6856aedc7822f639/687474703a2f2f6269742e6c792f75732d67726964). Thanks to [ghost](https://github.com/ghost).
#' @usage us_state_without_DC_grid3
#' @rdname grids
#' @md
NULL

#' @name co_cali_subdivisions_grid1
#' @description
#' * **co_cali_subdivisions_grid1:** Corregimientos of Cali, Columbia Image reference [here](https://user-images.githubusercontent.com/58274681/77264499-74312d80-6c68-11ea-8b87-b7185c53a8e8.png). Thanks to [Carolina101](https://github.com/Carolina101).
#' @usage co_cali_subdivisions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_northern_counties_grid1
#' @description
#' * **us_in_northern_counties_grid1:** Northern Counties of Indiana, United States Image reference [here](https://camo.githubusercontent.com/e083d6d2b65e0e6660b602a3261a3d382d84403e/68747470733a2f2f7777772e696e2e676f762f6476612f696d616765732f696e6469616e61636f756e74796d61702e6a7067). Thanks to [robertoge](https://github.com/robertoge).
#' @usage us_in_northern_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid3
#' @description
#' * **italy_grid3:** Autonomous Provinces of Italy Image reference [here](https://camo.githubusercontent.com/c99fec4eacdf2b580301a1296e977951661b9e2e/687474703a2f2f6135312e69646174612e6f7665722d626c6f672e636f6d2f332f33322f36382f32302f43617274696e615f6974616c69612e676966). Thanks to [danilolofaro](https://github.com/danilolofaro).
#' @usage italy_grid3
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid2
#' @description
#' * **us_state_with_DC_PR_grid2:** Grid of 50 states, DC, and Puerto Rico Image reference [here](https://camo.githubusercontent.com/5038126fbe0052e7d42602dc6856aedc7822f639/687474703a2f2f6269742e6c792f75732d67726964). Thanks to [krmaas](https://github.com/krmaas).
#' @usage us_state_with_DC_PR_grid2
#' @rdname grids
#' @md
NULL

#' @name us_state_grid7
#' @description
#' * **us_state_grid7:** United States grid with Washington, D.C Image reference [here](https://camo.githubusercontent.com/5038126fbe0052e7d42602dc6856aedc7822f639/687474703a2f2f6269742e6c792f75732d67726964). Thanks to [yichenqin](https://github.com/yichenqin).
#' @usage us_state_grid7
#' @rdname grids
#' @md
NULL

#' @name sg_planning_area_grid2
#' @description
#' * **sg_planning_area_grid2:** Singapore Planning Areas Image reference [here](https://user-images.githubusercontent.com/1275592/54297744-a9467280-4574-11e9-99f7-bdb62bbb34b4.png). Thanks to [ZhimaoElliott](https://github.com/ZhimaoElliott).
#' @usage sg_planning_area_grid2
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_fl_grid1
#' @description
#' * **ch_cantons_fl_grid1:** Grid layout for Cantons of Switzerland and the neighbouring Prinicipality of Liechtenstein Image reference [here](https://camo.githubusercontent.com/e9cc4af58e6fd5cce80789b66965a5f6b1261043/68747470733a2f2f65787465726e616c2d636f6e74656e742e6475636b6475636b676f2e636f6d2f69752f3f753d68747470732533412532462532467777772e6d6170736f66776f726c642e636f6d253246737769747a65726c616e642532466d617073253246737769747a65726c616e642d706f6c69746963616c2d6d61702e6a706726663d31266e6f66623d31). Thanks to [rastrau](https://github.com/rastrau).
#' @usage ch_cantons_fl_grid1
#' @rdname grids
#' @md
NULL

#' @name europe_countries_grid2
#' @description
#' * **europe_countries_grid2:** Grid layout for European countries (minus micro nations) Image reference [here](https://camo.githubusercontent.com/26d57bac5a363cea2e60c86241a11f85761929eb/68747470733a2f2f692e70696e696d672e636f6d2f6f726967696e616c732f66612f31662f36372f66613166363739386264346639643439303465303864633063643163323331662e676966). Thanks to [rastrau](https://github.com/rastrau).
#' @usage europe_countries_grid2
#' @rdname grids
#' @md
NULL

#' @name us_states_territories_grid1
#' @description
#' * **us_states_territories_grid1:** Grid layout for U.S. states and territories Image reference [here](https://camo.githubusercontent.com/83eb052673572f1a6785075d9e46759cb28ef4cc/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f392f39312f5465727269746f7269616c5f7761746572735f2d5f556e697465645f5374617465732e7376672f3238383070782d5465727269746f7269616c5f7761746572735f2d5f556e697465645f5374617465732e7376672e706e67). Thanks to [rastrau](https://github.com/rastrau).
#' @usage us_states_territories_grid1
#' @rdname grids
#' @md
NULL

#' @name us_tn_counties_grid1
#' @description
#' * **us_tn_counties_grid1:** Grid layout for counties of Tennesee, United States Image reference [here](https://camo.githubusercontent.com/18a78628dc8bae098f78d7373d471bcad8c737d9/687474703a2f2f6f6e746865776f726c646d61702e636f6d2f7573612f73746174652f74656e6e65737365652f74656e6e65737365652d636f756e74792d6d61702e6a7067). Thanks to [binkleym](https://github.com/binkleym).
#' @usage us_tn_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_il_chicago_community_areas_grid1
#' @description
#' * **us_il_chicago_community_areas_grid1:** Grid layout for the Community Areas of Chicago Image reference [here](https://camo.githubusercontent.com/6a4894e55de6d844cf4641d14efb871f1fd17a60/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32342f4d61705f6f665f7468655f436f6d6d756e6974795f41726561735f616e645f25323753696465732532375f6f665f7468655f436974795f6f665f4368696361676f2e7376672f33353070782d4d61705f6f665f7468655f436f6d6d756e6974795f41726561735f616e645f25323753696465732532375f6f665f7468655f436974795f6f665f4368696361676f2e7376672e706e67). Thanks to [leungkp](https://github.com/leungkp).
#' @usage us_il_chicago_community_areas_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid3
#' @description
#' * **us_state_with_DC_PR_grid3:** United States grid with Washington, D.C. and Puerto Rico Image reference [here](https://user-images.githubusercontent.com/1275592/82837790-f7484d00-9e7e-11ea-9136-7ace6c35af51.png). Thanks to [klittle314](https://github.com/klittle314).
#' @usage us_state_with_DC_PR_grid3
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid2
#' @description
#' * **in_state_ut_grid2:** Grid of Indian States and Union Territories Image reference [here](https://user-images.githubusercontent.com/29943634/80574618-7a9e8c00-8a02-11ea-8387-1056410cb54b.png). Thanks to [dnyansagar](https://github.com/dnyansagar).
#' @usage in_state_ut_grid2
#' @rdname grids
#' @md
NULL

#' @name at_states_grid1
#' @description
#' * **at_states_grid1:** Grid layout for States of Austria Image reference [here](https://user-images.githubusercontent.com/9595585/80590528-4e900480-8a1c-11ea-9bf0-151cce354249.png). Thanks to [werkstattcodes](https://github.com/werkstattcodes).
#' @usage at_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_pa_counties_grid1
#' @description
#' * **us_pa_counties_grid1:** Grid layout of Counties of Pennsylvania, United States Image reference [here](https://camo.githubusercontent.com/9e66d19e37c885372b6782efc53f6f3200ce7497/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f382f38332f50656e6e73796c76616e69615f636f756e746965735f6d61702e706e67). Thanks to [urbanSpatial](https://github.com/urbanSpatial).
#' @usage us_pa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_oh_counties_grid1
#' @description
#' * **us_oh_counties_grid1:** Grid layout of Counties of Ohio, United States Image reference [here](https://camo.githubusercontent.com/f52a753f240e844905bd487a35cbc3055c7fd58f/687474703a2f2f7777772e646f742e73746174652e6f682e75732f6d6170732f5075626c697368696e67496d616765732f506c61696e436f756e74792e676966). Thanks to [taylorokonek](https://github.com/taylorokonek).
#' @usage us_oh_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_departements_grid2
#' @description
#' * **fr_departements_grid2:** Grid layout of Departements of France Image reference [here](https://camo.githubusercontent.com/e0992f21a9ff02c5bf792817cd17fd2bab550dfe/68747470733a2f2f61626f75742d6672616e63652e636f6d2f4d61702d6672616e63652d7265672e676966). Thanks to [jerbou](https://github.com/jerbou).
#' @usage fr_departements_grid2
#' @rdname grids
#' @md
NULL

#' @name us_wi_counties_grid1
#' @description
#' * **us_wi_counties_grid1:** Grid layout for counties of Wisconsin, United States Image reference [here](https://camo.githubusercontent.com/0e8c590b5984c2b061abdb1cf3d81c25a1dfd74828995f4aedc4bf8021c9e942/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f322f32352f576973636f6e73696e2d636f756e746965732d6d61702e676966). Thanks to [aravamu2](https://github.com/aravamu2).
#' @usage us_wi_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name africa_countries_grid1
#' @description
#' * **africa_countries_grid1:** Grid for all countries in Africa. Namibia added as 'NAM' to avoid NA collisions Image reference [here](https://camo.githubusercontent.com/1b60515e108610e2a510e205c5cbbee28a53b85a/687474703a2f2f342e62702e626c6f6773706f742e636f6d2f2d33616d4d4e5952413255342f56654c55755779596874492f41414141414141414546672f46395a595a6f49444346342f73313630302f6166726963612d636f756e7472792d6d61702e706e67). Thanks to [ntncmch](https://github.com/ntncmch).
#' @usage africa_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name no_counties_grid1
#' @description
#' * **no_counties_grid1:** Grid of counties of Norway Image reference [here](https://camo.githubusercontent.com/1e8684781a30cdc9ce1b87068c861ebdfd51548f41de95d073217037cf9defb4/68747470733a2f2f7777772e66616d696c797365617263682e6f72672f656e2f77696b692f696d675f617574682e7068702f362f36632f4e6f727761795f3278322e6a7067). Thanks to [NanAmalie1](https://github.com/NanAmalie1).
#' @usage no_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name tr_provinces_grid1
#' @description
#' * **tr_provinces_grid1:** Grid of Provinces of Turkey Image reference [here](https://camo.githubusercontent.com/1576de0be9c4381984f6082ad6e7dafdaee69f69/68747470733a2f2f62616e6e6572322e636c65616e706e672e636f6d2f32303138313230362f69746a2f6b697373706e672d697374616e62756c2d70726f76696e6365732d6f662d7475726b65792d62757273612d70726f76696e63652d6d61702d616e2d6469737472696274726c65722d726f746f666c7569642d646e65722d62616c616e742d656c652d35633039383137656139653461362e323033373431303731353434313236383436363935392e6a7067). Thanks to [sadettindemirel](https://github.com/sadettindemirel).
#' @usage tr_provinces_grid1
#' @rdname grids
#' @md
NULL
