% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_midagri_data.R
\name{get_midagri_data}
\alias{get_midagri_data}
\title{Download Geographic Information from MIDAGRI}
\usage{
get_midagri_data(layer = NULL, dsn = NULL, show_progress = TRUE, quiet = TRUE)
}
\arguments{
\item{layer}{A string. Specifies the layer to download. Available layers are detailed in the 'Details' section.}

\item{dsn}{Character. The output filename in \bold{.shp or .gpkg} format. If not provided, a temporary file will be created.}

\item{show_progress}{Logical. If TRUE, displays a progress bar during the download.}

\item{quiet}{Logical. If TRUE, suppresses informational messages.}
}
\value{
An `sf` object containing the downloaded geographic data.
}
\description{
This function allows you to download the latest version of MIDAGRI geographic data.
For more information you can visit the following page  \url{https://siea.midagri.gob.pe/}.
}
\details{
Available layers are:
\itemize{
  \item \bold{vegetation_cover:} Polygons representing agricultural areas of Peru, produced from high-resolution satellite images (RapidEye and Sentinel-2).
  \item \bold{agriculture_sector:} Polygons representing the new national register of agricultural statistical sectors for the year 2024.
  \item \bold{oil_palm_areas:} Polygons representing areas cultivated with oil palm in Peru for the period 2016 to 2020.
  \item \bold{experimental_stations:} Points representing agricultural experimental stations in Peru.
}
}
\examples{
\donttest{
library(geoidep)
library(sf)
# Disable the use of S2 geometry for accurate spatial operations
sf_use_s2(use_s2 = FALSE)

# Retrieve the polygon for Coronel Portillo province
coronel_portillo <- get_provinces(show_progress = FALSE) |>
  subset(NOMBPROV == "CORONEL PORTILLO") |>
  st_transform(crs = 32718)

# Download and extract the oil palm layer for Coronel Portillo
oil_palm <- get_midagri_data(
  layer = "oil_palm_areas",
  show_progress = FALSE
) |>
  st_intersection(coronel_portillo)

# Visualize the oil palm layer
plot(st_geometry(oil_palm))
}
}
