% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{FROM_GeoJson}
\alias{FROM_GeoJson}
\title{reads GeoJson data}
\usage{
FROM_GeoJson(url_file_string, ...)
}
\arguments{
\item{url_file_string}{a string specifying the input path to a file OR a geojson object (in form of a character string) OR a valid url (beginning with 'http..') pointing to a geojson object}

\item{...}{See details for the \emph{ellipsis} (...).}
}
\value{
a (nested) list
}
\description{
reads GeoJson data
}
\details{
The \emph{FROM_GeoJson} function can take two more parameters : \emph{flatten_coords} and \emph{average_coordinates}. Both parameters are boolean.
If \emph{flatten_coords} is TRUE then the properties member of the geojson file will be omitted. If \emph{average_coordinates} is TRUE then additionally a geojson-dump and the average
latitude and longitude of the geometry object will be returned.
}
\examples{

library(geojsonR)


# INPUT IS A FILE

# Do not run

# res = FROM_GeoJson(url_file_string = "/myfolder/feature_collection.geojson")


# INPUT IS A GEOJSON (character string)

tmp_str = '{ "type": "MultiPolygon", "coordinates": [
  [[[102.0, 2.0], [103.0, 2.0], [103.0, 3.0], [102.0, 3.0], [102.0, 2.0]]],
  [[[100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0]],
   [[100.2, 0.2], [100.8, 0.2], [100.8, 0.8], [100.2, 0.8], [100.2, 0.2]]]
  ]
}'

res = FROM_GeoJson(url_file_string = tmp_str)


# INPUT IS A URL

# Do not run

# res = FROM_GeoJson(url_file_string = "http://www.EXAMPLE_web_page.geojson")

}

