% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-webdata-obj.R
\docType{methods}
\name{webdata}
\alias{webdata}
\alias{webdata,ANY-method}
\alias{webdata,character-method}
\alias{webdata,missing-method}
\title{create webdata object}
\usage{
webdata(.Object, ...)

\S4method{webdata}{missing}(.Object, ...)

\S4method{webdata}{character}(.Object = c("prism", "iclus", "daymet", "gldas",
  "nldas", "topowx", "solar", "metobs"), ...)

\S4method{webdata}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{webdata} 
(currently \code{character}, \code{webdata}, and \code{list})}

\item{...}{additional arguments passed initialize method (e.g., times, or any other 
in the \linkS4class{webdata} object.}
}
\value{
the webdata object representing a dataset and parameters
}
\description{
A class representing a web dataset.
}
\section{Slots}{

\describe{
\item{\code{times}}{value of type \code{"POSIXct"}, start and stop dates for data}

\item{\code{url}}{value of type \code{"character"}, the web location for the dataset}

\item{\code{variable}}{value of type \code{"character"}, the variable(s) for data}
}}
\examples{
webdata('prism')
webdata('prism', times=as.POSIXct(c('1990-01-01', '1995-01-01')))
webdata(list(times = as.POSIXct(c('1895-01-01 00:00:00','1899-01-01 00:00:00')),
 url = 'https://cida.usgs.gov/thredds/dodsC/prism',
 variables = 'ppt'))
}
\author{
Jordan S Read
}

