% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-webdata.R, R/query-webgeom.R,
%   R/query-webprocess.R
\docType{methods}
\name{query}
\alias{query}
\alias{query,webdata-method}
\alias{query,webdata,character-method}
\alias{query,webdata,missing-method}
\alias{query,character,missing-method}
\alias{query,webgeom,character-method}
\alias{query,webgeom-method}
\alias{query,webprocess,character-method}
\alias{query,webprocess-method}
\title{query webdata for various fields}
\usage{
query(.Object, field, ...)

\S4method{query}{webdata,character}(.Object, field, ...)

\S4method{query}{webdata,missing}(.Object, field, ...)

\S4method{query}{character,missing}(.Object, field, ...)

\S4method{query}{webgeom,character}(.Object, field, ...)

\S4method{query}{webprocess,character}(.Object, field, ...)
}
\arguments{
\item{.Object}{a \code{webdata}, \code{webgeom}, or \code{webprocess} object.}

\item{field}{a plural parameter name for fields in .Object (e.g., 'variables', 'times')}

\item{...}{additional arguments passed to methods}
}
\value{
a character vector of values corresponding to the query field specified
}
\description{
a method for finding possible values for a given field
}
\examples{
\dontrun{
fabric <- webdata('prism')
query(fabric, 'variables')
wg <- webgeom()
query(wg, 'geoms')
geom(wg) <- "sample:CONUS_states"
query(wg, 'attributes')
attribute(wg) <- 'STATE'
query(wg, 'values', rm.duplicates = TRUE)
}
}
\author{
Jordan S. Read
}
\keyword{methods}
