% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryRequestedDate.R
\docType{class}
\name{ISOImageryRequestedDate}
\alias{ISOImageryRequestedDate}
\title{ISOImageryRequestedDate}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryRequestedDate
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery requested date
}
\description{
ISOImageryRequestedDate
}
\section{Fields}{

\describe{
\item{\code{requestedDateOfCollection}}{[\code{\link{POSIXt}}]}

\item{\code{latestAcceptableDate}}{[\code{\link{POSIXt}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryRequestedDate}}
 }
 \item{\code{setRequestedDateOfCollection(date)}}{
   Set the requested date of collection, object of class \code{\link{POSIXt}}
 }
 \item{\code{setLatestAcceptableDate(date)}}{
   Set the latest acceptable date, object of class \code{\link{POSIXt}}
 }
}
}

\examples{
   #create band range dimension
   md <- ISOImageryRequestedDate$new()
   md$setRequestedDateOfCollection(Sys.time())
   md$setLatestAcceptableDate(Sys.time())
   xml <- md$encode()
   
}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{date}
\keyword{imagery}
\keyword{requested}
