% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubset.R
\docType{methods}
\name{getSubset}
\alias{getSubset}
\alias{getSubset,ANY-method}
\alias{getSubset,geom-method}
\alias{getSubset,Spatial-method}
\alias{getSubset,sf-method}
\title{Get the subset of a spatial object.}
\usage{
\S4method{getSubset}{ANY}(x)

\S4method{getSubset}{geom}(x, ..., slot = "feature")

\S4method{getSubset}{Spatial}(x, ...)

\S4method{getSubset}{sf}(x, ...)
}
\arguments{
\item{x}{object to \code{subset}.}

\item{...}{Logical predicates defined in terms of the variables in \code{x}
or a vector of booleans. Multiple conditions are combined with &. Only rows
where the condition evaluates to TRUE are kept.}

\item{slot}{[\code{character(1)}]\cr the slot in which to determine a subset,
either \code{"point"} for vertices, \code{"feature"} for features or
\code{"group"} for group tables.}
}
\value{
A subset of \code{x} in its original class.
}
\description{
Get the subset of a spatial object.
}
\examples{
# get the subset of a geom
obj <- gtGeoms$point

# the first feature
getSubset(x = gtGeoms$line, fid == 1)

# get the subset of a Spatial object
getSubset(x = gtSP$SpatialPolygonsDataFrame,
          a == 2)

# get the subset of an sf object
getSubset(x = gtSF$polygon, a == 1)
}
\seealso{
Other getters: \code{\link{getCRS}},
  \code{\link{getExtent}}, \code{\link{getHistory}},
  \code{\link{getPoints}}, \code{\link{getTable}},
  \code{\link{getType}}, \code{\link{getWindow}}
}
\concept{getters}
