% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_rotate.R
\name{gt_rotate}
\alias{gt_rotate}
\title{Rotate geometric objects}
\usage{
gt_rotate(obj, x = NULL, y = NULL, angle = NULL, fid = NULL, update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to rotate.}

\item{x}{[\code{numeric(1)}]\cr the x position(s) to rotate about.}

\item{y}{[\code{numeric(1)}]\cr the y position(s) to rotate about.}

\item{angle}{[\code{numeric(1)}]\cr the counter-clockwise angle by which
\code{geom} shall be rotated (can be negative to rotate clockwise).}

\item{fid}{[\code{integerish(.)}]\cr if only a subset of features shall be
rotated, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after rotation.}
}
\value{
\code{geom} of the rotated \code{obj}.
}
\description{
Rotate geometric objects by a certain angle about center coordinates
}
\examples{
# rotate all geoms
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_rotate(obj = gtGeoms$polygon, x = 0, y = 0, angle = 135,
                     update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)

# rotate a single geom
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_rotate(obj = gtGeoms$polygon, x = -10, y = 0, angle = -180,
                     update = FALSE, fid = 2)
visualise(geom = newPoly, linecol = "green", new = FALSE)

# rotate different geoms about different centers by different angles
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_rotate(obj = gtGeoms$polygon,
                     x = c(0, -10),
                     y = c(-10, 0),
                     angle = c(75, -135),
                     update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_reflect}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
