% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_stretch.R
\name{gt_stretch}
\alias{gt_stretch}
\title{Stretch geometric objects}
\usage{
gt_stretch(obj, x = NULL, y = NULL, fid = NULL, update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to stretch.}

\item{x}{[\code{numeric(1)}]\cr the scale factor in x dimension.}

\item{y}{[\code{numeric(1)}]\cr the scale factor in y dimension.}

\item{fid}{[\code{integerish(.)}]\cr in case only a subset of features shall
be stretched, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after stretching.}
}
\value{
\code{geom} of the stretched \code{obj}.
}
\description{
Stretch geometric objects by a scale factor in x and y dimension.
}
\examples{
# stretch several features
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_stretch(obj = gtGeoms$polygon, x = 0.5, y = 0.2,
                      update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)

# stretch a single feature
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_stretch(obj = gtGeoms$polygon, x = 0.5, fid = 2, update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)

# stretch feature separately
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_stretch(obj = gtGeoms$polygon,
                      x = c(0.2, 1),
                      y = c(1, 0.2),
                      update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
