% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotTangentSpace}
\alias{plotTangentSpace}
\title{Plot specimens in tangent space}
\usage{
plotTangentSpace(A, axis1 = 1, axis2 = 2, warpgrids = TRUE, mesh = NULL,
  label = NULL, groups = NULL, verbose = FALSE)
}
\arguments{
\item{A}{An array (p x k x n) containing landmark coordinates for a set of aligned specimens}

\item{axis1}{A value indicating which PC axis should be displayed as the X-axis (default = PC1)}

\item{axis2}{A value indicating which PC axis should be displayed as the Y-axis (default = PC2)}

\item{warpgrids}{A logical value indicating whether deformation grids for shapes along X-axis should be displayed}

\item{mesh}{A mesh3d object to be warped to represent shape deformation along X-axis (when {warpgrids=TRUE})
as described in \code{\link{plotRefToTarget}}.}

\item{label}{An optional vector indicating labels for each specimen are to be displayed}

\item{groups}{An optional factor vector specifying group identity for each specimen}

\item{verbose}{A logical value indicating whether the output is basic or verbose (see Value below)}
}
\value{
Function returns a table summarizing the percent variation explained by each
 pc axis (equivalent to summary() of \code{\link{prcomp}}) (default, verbose = FALSE).
 If verbose=TRUE, function returns a list containing the following components:
\item{pc.summary}{A PC summary table as above}
\item{pc.scores}{The set of principal component scores for all specimens.}
\item{pc.shapes}{A list with four components of the shape coordinates of the extreme ends of axis1 and axis2
is returned, which can be used by \code{\link{warpRefMesh}}.}
}
\description{
Function plots a set of Procrustes-aligned specimens in tangent space along their principal axes
}
\details{
The function performs a principal components analysis of shape variation and plots two
 dimensions of tangent space for a set of Procrustes-aligned specimens (default is PC1 vs. PC2).
 The percent variation along each PC-axis is returned. Additionally (and optionally, {warpgrids=T}),
 deformation grids can be requested, which display the shape of specimens at the ends
 of the range of variability along PC1. If groups are provided, specimens from
 each group are plotted using distinct colors based on the order in which the groups are found in the dataset,
 and using R's standard color palette: black, red, green, blue, cyan, magenta, yellow, and gray. NOTE: to change
 the colors of the groups, simply substitute a vector of the desired colors for each specimen (see example below).
}
\examples{
data(plethodon)
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment

gp <- as.factor(paste(plethodon$species, plethodon$site)) # group must be a factor
plotTangentSpace(Y.gpa$coords, groups = gp)

##To change colors of groups
col.gp<-c(rep("black",10),rep("red",10),rep("yellow",10),rep("orange",10)) # must not be a factor

plotTangentSpace(Y.gpa$coords, groups = col.gp)
}
\author{
Dean Adams & Emma Sherratt
}
\keyword{visualization}

