% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two.b.pls.r
\name{two.b.pls}
\alias{two.b.pls}
\title{Two-block partial least squares analysis for shape data}
\usage{
two.b.pls(A1, A2, iter = 999, seed = NULL)
}
\arguments{
\item{A1}{A matrix (n x [p x k]) or 3D array (p x k x n) containing GPA-aligned coordinates for the first block}

\item{A2}{A matrix (n x [p x k]) or 3D array (p x k x n) containing GPA-aligned coordinates for the second block}

\item{iter}{Number of iterations for significance testing}

\item{seed}{An optional argument for setting the seed for random permutations of the resampling procedure.
If left NULL (the default), the exact same P-values will be found for repeated runs of the analysis (with the same number of iterations).
If seed = "random", a random seed will be used, and P-values will vary.  One can also specify an integer for specific seed values,
which might be of interest for advanced users.}
}
\value{
Object of class "pls" that returns a list of the following:
  \item{r.pls}{The correlation coefficient between scores of projected values on the first
  singular vectors of left (x) and right (y) blocks of landmarks (or other variables)}
  \item{P.value}{The empirically calculated P-value from the resampling procedure.}
  \item{left.pls.vectors}{The singular vectors of the left (x) block}
  \item{right.pls.vectors}{The singular vectors of the right (y) block}
  \item{random.r}{The correlation coefficients found in each random permutation of the 
  resampling procedure.}
  \item{XScores}{Values of left (x) block projected onto singular vectors.}
  \item{YScores}{Values of right (y) block projected onto singular vectors.}
  \item{A1}{Input values for the left block.}
  \item{A2}{Input values for the right block.}
  \item{A1.matrix}{Left block (matrix) found from A1.}
  \item{A2.matrix}{Right block (matrix) found from A2.}
  \item{permutations}{The number of random permutations used in the resampling procedure.}
  \item{call}{The match call.}
}
\description{
Function performs two-block partial least squares analysis to assess the degree of association between 
to blocks of Procrustes-aligned coordinates (or other variables)
}
\details{
The function quantifies the degree of association between two blocks of shape data as 
  defined by landmark coordinates using partial least squares (see Rohlf and Corti 2000). If geometric morphometric data are 
  used, it is assumed 
  that the landmarks have previously been aligned using 
  Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}]. If other variables are used, they must be input as a 
  2-Dimensional matrix (rows = specimens, columns = variables).  It is also assumed that the separate inputs
  have specimens (observations) in the same order.
  
 The generic functions, \code{\link{print}}, \code{\link{summary}}, and \code{\link{plot}} all work with \code{\link{modularity.test}}.
 The generic function, \code{\link{plot}}, produces a two-block.pls plot.  This function calls \code{\link{plot.pls}}, which has two additional
 arguments (with defaults): label = NULL, warpgrids = TRUE.  These arguments allow one to include a vector to label points and a logical statement to
 include warpgrids, respectively.  Warpgrids can only be included for 3D arrays of Procrustes residuals. The plot is a plot of PLS scores from 
 Block1 versus Block2 performed for the first set of PLS axes. 
 
 \subsection{Notes for geomorph 3.0}{ 
There is a slight change in two.b.pls plots with geomorph 3.0.  Rather than use the shapes of specimens that matched minimum and maximum PLS
scores, major-axis regression is used and the extreme fitted values are used to generate deformation grids.  This ensures that shape deformations
are exactly along the major axis of shape covariation.  This axis is also shown as a best-fit line in the plot.
}
}
\examples{
data(plethShapeFood) 
Y.gpa<-gpagen(plethShapeFood$land)    #GPA-alignment    

#2B-PLS between head shape and food use data
PLS <-two.b.pls(Y.gpa$coords,plethShapeFood$food,iter=999)
summary(PLS)
plot(PLS)
}
\author{
Dean Adams and Michael Collyer
}
\references{
Rohlf, F.J., and M. Corti. 2000. The use of partial least-squares to study covariation in shape. 
Systematic Biology 49: 740-753.
}
\seealso{
\code{\link{integration.test}}, \code{\link{modularity.test}}, \code{\link{phylo.pls}}, and 
\code{\link{phylo.integration}}
}
\keyword{analysis}

