% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNManager.R
\docType{class}
\name{GNManager}
\alias{GNManager}
\title{GeoNetwork REST API Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the API of a GeoNetwork instance.
}
\description{
The function \code{GNManager$new} will set-up the right Geonetwork
manager depending on the GeoNetwork version specified by the user. For the time-being,
GeoNetwork with version < 4 will be interfaced with the GeoNetwork legacy API (see detailed 
documentation at \link{GNLegacyAPIManager}), while starting with GeoNetwork 3.2, the new 
GeoNetwork OpenAPI will be used.
}
\examples{
\dontrun{
   GMManager$new("http://localhost:8080/geonetwork", "admin", "geonetwork", "3.0.0")
}


}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
\section{Super class}{
\code{\link[geonapi:GNAbstractManager]{geonapi::GNAbstractManager}} -> \code{GNManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GNManager$new()}}
\item \href{#method-clone}{\code{GNManager$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="ERROR">}\href{../../geonapi/html/GNAbstractManager.html#method-ERROR}{\code{geonapi::GNAbstractManager$ERROR()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getClassName">}\href{../../geonapi/html/GNAbstractManager.html#method-getClassName}{\code{geonapi::GNAbstractManager$getClassName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getLang">}\href{../../geonapi/html/GNAbstractManager.html#method-getLang}{\code{geonapi::GNAbstractManager$getLang()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="getUrl">}\href{../../geonapi/html/GNAbstractManager.html#method-getUrl}{\code{geonapi::GNAbstractManager$getUrl()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="INFO">}\href{../../geonapi/html/GNAbstractManager.html#method-INFO}{\code{geonapi::GNAbstractManager$INFO()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="logger">}\href{../../geonapi/html/GNAbstractManager.html#method-logger}{\code{geonapi::GNAbstractManager$logger()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="login">}\href{../../geonapi/html/GNAbstractManager.html#method-login}{\code{geonapi::GNAbstractManager$login()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geonapi" data-topic="GNAbstractManager" data-id="WARN">}\href{../../geonapi/html/GNAbstractManager.html#method-WARN}{\code{geonapi::GNAbstractManager$WARN()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GNManager}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNManager$new(url, user = NULL, pwd = NULL, version, logger = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{version}}{version}

\item{\code{logger}}{logger}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
