% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSFeatureType.R
\docType{class}
\name{GSFeatureType}
\alias{GSFeatureType}
\title{A GeoServer feature type}
\format{\code{\link{R6Class}} object.}
\usage{
GSFeatureType
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer feature type
}
\description{
This class models a GeoServer feature type. This class is to be
used for manipulating representations of vector data with GeoServer.
}
\details{
Geoserver REST API Resource
}
\section{Methods}{

\describe{
 \item{\code{new(rootName, xml)}}{
   This method is used to instantiate a GSResource
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSResource from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSFeatureType to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setVirtualTable(vt)}}{
   Sets a virtual table for the feature type.
 }
 \item{\code{delVirtualTable()}}{
   Deletes the virtual table for the feature type
 }
}
}
\examples{
ft <- GSFeatureType$new()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{featureType}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}

