% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GSNamespaceManager.R
\docType{class}
\name{GSNamespaceManager}
\alias{GSNamespaceManager}
\title{Geoserver REST API Namespace Manager}
\format{\code{\link{R6Class}} object.}
\usage{
GSNamespaceManager
}
\value{
Object of \code{\link{R6Class}} with methods for managing the namespaces
 of a GeoServer instance.
}
\description{
Geoserver REST API Namespace Manager
}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate a GSManager with the \code{url} of the
   GeoServer and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger). This argument
   accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs
 }
 \item{\code{getNamespaces()}}{
   Get the list of available namespace. Returns an object of class \code{list}
   containing items of class \code{\link{GSNamespace}}
 }
 \item{\code{getNamespaceNames()}}{
   Get the list of available namespace names. Returns an vector of class
   \code{character}
 }
 \item{\code{getNamespace(ns)}}{
   Get a \code{\link{GSNamespace}} object given a namespace name.
 }
 \item{\code{createNamespace(prefix, uri)}}{
   Creates a GeoServer namespace given a prefix, and an optional URI. Returns
   \code{TRUE} if the namespace has been successfully created, \code{FALSE}
   otherwise
 }
 \item{\code{updateNamespace(ns, uri)}}{
   Updates a GeoServer namespace given a name, and an optional URI. Returns
   \code{TRUE} if the namespace has been successfully updated, \code{FALSE}
   otherwise
 }
 \item{\code{deleteNamespace(ns)}}{
   Deletes a GeoServer namespace given a name. Returns \code{TRUE} if the
   namespace has been successfully deleted, \code{FALSE} otherwise
 }
}
}
\examples{
\dontrun{
   GSNamespaceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{namespace}
\keyword{rest}

