// Generated by rstantools.  Do not edit by hand.

/*
    geostan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    geostan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with geostan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_foundation_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_foundation");
    reader.add_event(1, 1, "include", "parts/priors.stan");
    reader.add_event(1, 0, "start", "parts/priors.stan");
    reader.add_event(263, 262, "end", "parts/priors.stan");
    reader.add_event(263, 2, "restart", "model_foundation");
    reader.add_event(266, 5, "include", "parts/data.stan");
    reader.add_event(266, 0, "start", "parts/data.stan");
    reader.add_event(373, 107, "end", "parts/data.stan");
    reader.add_event(373, 6, "restart", "model_foundation");
    reader.add_event(376, 9, "include", "parts/trans_data.stan");
    reader.add_event(376, 0, "start", "parts/trans_data.stan");
    reader.add_event(399, 23, "end", "parts/trans_data.stan");
    reader.add_event(399, 10, "restart", "model_foundation");
    reader.add_event(402, 13, "include", "parts/params.stan");
    reader.add_event(402, 0, "start", "parts/params.stan");
    reader.add_event(438, 36, "end", "parts/params.stan");
    reader.add_event(438, 14, "restart", "model_foundation");
    reader.add_event(441, 17, "include", "parts/trans_params_declaration.stan");
    reader.add_event(441, 0, "start", "parts/trans_params_declaration.stan");
    reader.add_event(460, 19, "end", "parts/trans_params_declaration.stan");
    reader.add_event(460, 18, "restart", "model_foundation");
    reader.add_event(460, 18, "include", "parts/trans_params_expression_icar.stan");
    reader.add_event(460, 0, "start", "parts/trans_params_expression_icar.stan");
    reader.add_event(477, 17, "end", "parts/trans_params_expression_icar.stan");
    reader.add_event(477, 19, "restart", "model_foundation");
    reader.add_event(477, 19, "include", "parts/trans_params_expression_esf.stan");
    reader.add_event(477, 0, "start", "parts/trans_params_expression_esf.stan");
    reader.add_event(487, 10, "end", "parts/trans_params_expression_esf.stan");
    reader.add_event(487, 20, "restart", "model_foundation");
    reader.add_event(487, 20, "include", "parts/trans_params_expression_car.stan");
    reader.add_event(487, 0, "start", "parts/trans_params_expression_car.stan");
    reader.add_event(504, 17, "end", "parts/trans_params_expression_car.stan");
    reader.add_event(504, 21, "restart", "model_foundation");
    reader.add_event(520, 37, "include", "parts/model.stan");
    reader.add_event(520, 0, "start", "parts/model.stan");
    reader.add_event(610, 90, "end", "parts/model.stan");
    reader.add_event(610, 38, "restart", "model_foundation");
    reader.add_event(613, 41, "include", "parts/gen_quants_declaration.stan");
    reader.add_event(613, 0, "start", "parts/gen_quants_declaration.stan");
    reader.add_event(619, 6, "end", "parts/gen_quants_declaration.stan");
    reader.add_event(619, 42, "restart", "model_foundation");
    reader.add_event(619, 42, "include", "parts/gen_quants_expression.stan");
    reader.add_event(619, 0, "start", "parts/gen_quants_expression.stan");
    reader.add_event(641, 22, "end", "parts/gen_quants_expression.stan");
    reader.add_event(641, 43, "restart", "model_foundation");
    reader.add_event(644, 44, "end", "model_foundation");
    return reader;
}
template <typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type, Eigen::Dynamic, 1>
rhs_prior(const int& dev,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& z,
              const T2__& aux1_global,
              const T3__& aux2_global,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& aux1_local,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& aux2_local,
              const T6__& caux,
              const T7__& scale_global,
              const T8__& slab_scale,
              const T9__& error_scale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 17;
        local_scalar_t__ tau(DUMMY_VAR__);
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau, DUMMY_VAR__);
        stan::math::assign(tau,(((aux1_global * stan::math::sqrt(aux2_global)) * scale_global) * error_scale));
        current_statement_begin__ = 18;
        local_scalar_t__ c(DUMMY_VAR__);
        (void) c;  // dummy to suppress unused var warning
        stan::math::initialize(c, DUMMY_VAR__);
        stan::math::fill(c, DUMMY_VAR__);
        stan::math::assign(c,(slab_scale * stan::math::sqrt(caux)));
        current_statement_begin__ = 19;
        validate_non_negative_index("lambda", "dev", dev);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda(dev);
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda, DUMMY_VAR__);
        stan::math::assign(lambda,elt_multiply(aux1_local, stan::math::sqrt(aux2_local)));
        current_statement_begin__ = 20;
        validate_non_negative_index("lambda_tilde", "dev", dev);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde(dev);
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(elt_divide(multiply(pow(c, 2), square(lambda)), add(pow(c, 2), multiply(square(tau), square(lambda))))));
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z, lambda_tilde), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct rhs_prior_functor__ {
    template <typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const int& dev,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& z,
              const T2__& aux1_global,
              const T3__& aux2_global,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& aux1_local,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& aux2_local,
              const T6__& caux,
              const T7__& scale_global,
              const T8__& slab_scale,
              const T9__& error_scale, std::ostream* pstream__) const {
        return rhs_prior(dev, z, aux1_global, aux2_global, aux1_local, aux2_local, caux, scale_global, slab_scale, error_scale, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
car_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                    const T2__& tau,
                    const T3__& rho,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& ImC,
                    const std::vector<int>& ImC_v,
                    const std::vector<int>& ImC_u,
                    const std::vector<int>& Cidx,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                    const T9__& log_det_D_inv,
                    const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                    const int& n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 48;
        validate_non_negative_index("z", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z(n);
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        stan::math::assign(z,subtract(y, mu));
        current_statement_begin__ = 49;
        validate_non_negative_index("ImrhoC", "num_elements(ImC)", num_elements(ImC));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ImrhoC(num_elements(ImC));
        stan::math::initialize(ImrhoC, DUMMY_VAR__);
        stan::math::fill(ImrhoC, DUMMY_VAR__);
        stan::math::assign(ImrhoC,ImC);
        current_statement_begin__ = 50;
        validate_non_negative_index("zMinv", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> zMinv(n);
        stan::math::initialize(zMinv, DUMMY_VAR__);
        stan::math::fill(zMinv, DUMMY_VAR__);
        stan::math::assign(zMinv,elt_multiply(multiply((1 / pow(tau, 2)), z), D_inv));
        current_statement_begin__ = 51;
        validate_non_negative_index("ImrhoCz", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ImrhoCz(n);
        stan::math::initialize(ImrhoCz, DUMMY_VAR__);
        stan::math::fill(ImrhoCz, DUMMY_VAR__);
        current_statement_begin__ = 52;
        validate_non_negative_index("ldet_ImrhoC", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ldet_ImrhoC(n);
        stan::math::initialize(ldet_ImrhoC, DUMMY_VAR__);
        stan::math::fill(ldet_ImrhoC, DUMMY_VAR__);
        current_statement_begin__ = 53;
        stan::model::assign(ImrhoC, 
                    stan::model::cons_list(stan::model::index_multi(Cidx), stan::model::nil_index_list()), 
                    multiply(rho, stan::model::rvalue(ImC, stan::model::cons_list(stan::model::index_multi(Cidx), stan::model::nil_index_list()), "ImC")), 
                    "assigning variable ImrhoC");
        current_statement_begin__ = 54;
        stan::math::assign(ImrhoCz, csr_matrix_times_vector(n, n, ImrhoC, ImC_v, ImC_u, z));
        current_statement_begin__ = 55;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 55;
            stan::model::assign(ldet_ImrhoC, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        log1m((rho * get_base1(lambda, i, "lambda", 1))), 
                        "assigning variable ldet_ImrhoC");
        }
        current_statement_begin__ = 56;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((((-(n) * stan::math::log((2 * stan::math::pi()))) - ((2 * n) * stan::math::log(tau))) + log_det_D_inv) + sum(ldet_ImrhoC)) - dot_product(zMinv, ImrhoCz))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
car_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                    const T2__& tau,
                    const T3__& rho,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& ImC,
                    const std::vector<int>& ImC_v,
                    const std::vector<int>& ImC_u,
                    const std::vector<int>& Cidx,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                    const T9__& log_det_D_inv,
                    const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                    const int& n, std::ostream* pstream__) {
    return car_normal_lpdf<false>(y,mu,tau,rho,ImC,ImC_v,ImC_u,Cidx,D_inv,log_det_D_inv,lambda,n, pstream__);
}
struct car_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                    const T2__& tau,
                    const T3__& rho,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& ImC,
                    const std::vector<int>& ImC_v,
                    const std::vector<int>& ImC_u,
                    const std::vector<int>& Cidx,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                    const T9__& log_det_D_inv,
                    const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                    const int& n, std::ostream* pstream__) const {
        return car_normal_lpdf(y, mu, tau, rho, ImC, ImC_v, ImC_u, Cidx, D_inv, log_det_D_inv, lambda, n, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T7__, typename T8__, typename T9__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T7__, T8__, T9__>::type>::type
wcar_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& A_w,
                     const std::vector<int>& A_v,
                     const std::vector<int>& A_u,
                     const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& D_inv,
                     const T8__& log_det_D_inv,
                     const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& lambda,
                     const int& n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T7__, T8__, T9__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 88;
        validate_non_negative_index("z", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z(n);
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        stan::math::assign(z,subtract(y, mu));
        current_statement_begin__ = 89;
        local_scalar_t__ ztDz(DUMMY_VAR__);
        (void) ztDz;  // dummy to suppress unused var warning
        stan::math::initialize(ztDz, DUMMY_VAR__);
        stan::math::fill(ztDz, DUMMY_VAR__);
        current_statement_begin__ = 90;
        local_scalar_t__ ztAz(DUMMY_VAR__);
        (void) ztAz;  // dummy to suppress unused var warning
        stan::math::initialize(ztAz, DUMMY_VAR__);
        stan::math::fill(ztAz, DUMMY_VAR__);
        current_statement_begin__ = 91;
        validate_non_negative_index("ldet_ImrhoC", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ldet_ImrhoC(n);
        stan::math::initialize(ldet_ImrhoC, DUMMY_VAR__);
        stan::math::fill(ldet_ImrhoC, DUMMY_VAR__);
        current_statement_begin__ = 92;
        stan::math::assign(ztDz, multiply(transpose(elt_multiply(z, D_inv)), z));
        current_statement_begin__ = 93;
        stan::math::assign(ztAz, multiply(transpose(z), csr_matrix_times_vector(n, n, A_w, A_v, A_u, z)));
        current_statement_begin__ = 94;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 94;
            stan::model::assign(ldet_ImrhoC, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        log1m((rho * get_base1(lambda, i, "lambda", 1))), 
                        "assigning variable ldet_ImrhoC");
        }
        current_statement_begin__ = 95;
        return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((((-(n) * stan::math::log((2 * stan::math::pi()))) - ((2 * n) * stan::math::log(tau))) + log_det_D_inv) + sum(ldet_ImrhoC)) - ((1 / pow(tau, 2)) * (ztDz - (rho * ztAz))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T7__, typename T8__, typename T9__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T7__, T8__, T9__>::type>::type
wcar_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& A_w,
                     const std::vector<int>& A_v,
                     const std::vector<int>& A_u,
                     const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& D_inv,
                     const T8__& log_det_D_inv,
                     const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& lambda,
                     const int& n, std::ostream* pstream__) {
    return wcar_normal_lpdf<false>(y,mu,tau,rho,A_w,A_v,A_u,D_inv,log_det_D_inv,lambda,n, pstream__);
}
struct wcar_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T7__, typename T8__, typename T9__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T7__, T8__, T9__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& A_w,
                     const std::vector<int>& A_v,
                     const std::vector<int>& A_u,
                     const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& D_inv,
                     const T8__& log_det_D_inv,
                     const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& lambda,
                     const int& n, std::ostream* pstream__) const {
        return wcar_normal_lpdf(y, mu, tau, rho, A_w, A_v, A_u, D_inv, log_det_D_inv, lambda, n, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
auto_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ax_w,
                     const std::vector<int>& Ax_v,
                     const std::vector<int>& Ax_u,
                     const std::vector<int>& Cidx,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                     const T9__& log_det_D_inv,
                     const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                     const int& n,
                     const int& WCAR, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 113;
        if (as_bool(WCAR)) {
            current_statement_begin__ = 114;
            return stan::math::promote_scalar<fun_return_scalar_t__>(wcar_normal_lpdf(y, mu, tau, rho, Ax_w, Ax_v, Ax_u, D_inv, log_det_D_inv, lambda, n, pstream__));
        } else {
            current_statement_begin__ = 116;
            return stan::math::promote_scalar<fun_return_scalar_t__>(car_normal_lpdf(y, mu, tau, rho, Ax_w, Ax_v, Ax_u, Cidx, D_inv, log_det_D_inv, lambda, n, pstream__));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
auto_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ax_w,
                     const std::vector<int>& Ax_v,
                     const std::vector<int>& Ax_u,
                     const std::vector<int>& Cidx,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                     const T9__& log_det_D_inv,
                     const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                     const int& n,
                     const int& WCAR, std::ostream* pstream__) {
    return auto_normal_lpdf<false>(y,mu,tau,rho,Ax_w,Ax_v,Ax_u,Cidx,D_inv,log_det_D_inv,lambda,n,WCAR, pstream__);
}
struct auto_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T8__, typename T9__, typename T10__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T8__, T9__, T10__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                     const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& mu,
                     const T2__& tau,
                     const T3__& rho,
                     const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ax_w,
                     const std::vector<int>& Ax_v,
                     const std::vector<int>& Ax_u,
                     const std::vector<int>& Cidx,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& D_inv,
                     const T9__& log_det_D_inv,
                     const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& lambda,
                     const int& n,
                     const int& WCAR, std::ostream* pstream__) const {
        return auto_normal_lpdf(y, mu, tau, rho, Ax_w, Ax_v, Ax_u, Cidx, D_inv, log_det_D_inv, lambda, n, WCAR, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
icar_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                     const T1__& spatial_scale,
                     const std::vector<int>& node1,
                     const std::vector<int>& node2,
                     const int& k,
                     const std::vector<int>& group_size,
                     const std::vector<int>& group_idx,
                     const int& has_theta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 139;
        local_scalar_t__ lp(DUMMY_VAR__);
        (void) lp;  // dummy to suppress unused var warning
        stan::math::initialize(lp, DUMMY_VAR__);
        stan::math::fill(lp, DUMMY_VAR__);
        current_statement_begin__ = 140;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 141;
        stan::math::assign(lp, (-(0.5) * dot_self(subtract(stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(node1), stan::model::nil_index_list()), "phi"), stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(node2), stan::model::nil_index_list()), "phi")))));
        current_statement_begin__ = 142;
        if (as_bool(has_theta)) {
            current_statement_begin__ = 143;
            for (int j = 1; j <= k; ++j) {
                current_statement_begin__ = 145;
                stan::math::assign(lp, (lp + normal_log(sum(stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi")), 0, (0.001 * get_base1(group_size, j, "group_size", 1)))));
                current_statement_begin__ = 146;
                stan::math::assign(pos, (pos + get_base1(group_size, j, "group_size", 1)));
            }
        } else {
            current_statement_begin__ = 150;
            for (int j = 1; j <= k; ++j) {
                current_statement_begin__ = 151;
                if (as_bool(logical_gt(get_base1(group_size, j, "group_size", 1), 1))) {
                    current_statement_begin__ = 153;
                    stan::math::assign(lp, (lp + normal_log(sum(stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi")), 0, (0.001 * get_base1(group_size, j, "group_size", 1)))));
                } else {
                    current_statement_begin__ = 156;
                    stan::math::assign(lp, (lp + normal_log(stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi"), 0, spatial_scale)));
                }
                current_statement_begin__ = 158;
                stan::math::assign(pos, (pos + get_base1(group_size, j, "group_size", 1)));
            }
        }
        current_statement_begin__ = 161;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lp);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
icar_normal_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                     const T1__& spatial_scale,
                     const std::vector<int>& node1,
                     const std::vector<int>& node2,
                     const int& k,
                     const std::vector<int>& group_size,
                     const std::vector<int>& group_idx,
                     const int& has_theta, std::ostream* pstream__) {
    return icar_normal_lpdf<false>(phi,spatial_scale,node1,node2,k,group_size,group_idx,has_theta, pstream__);
}
struct icar_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                     const T1__& spatial_scale,
                     const std::vector<int>& node1,
                     const std::vector<int>& node2,
                     const int& k,
                     const std::vector<int>& group_size,
                     const std::vector<int>& group_idx,
                     const int& has_theta, std::ostream* pstream__) const {
        return icar_normal_lpdf(phi, spatial_scale, node1, node2, k, group_size, group_idx, has_theta, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type, Eigen::Dynamic, 1>
make_phi(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_tilde,
             const T1__& phi_scale,
             const T2__& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& inv_sqrt_scale_factor,
             const int& n,
             const int& k,
             const std::vector<int>& group_size,
             const std::vector<int>& group_idx, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 185;
        validate_non_negative_index("phi", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi(n);
        stan::math::initialize(phi, DUMMY_VAR__);
        stan::math::fill(phi, DUMMY_VAR__);
        current_statement_begin__ = 186;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 187;
        for (int j = 1; j <= k; ++j) {
            current_statement_begin__ = 188;
            stan::model::assign(phi, 
                        stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), 
                        multiply(((phi_scale * stan::math::sqrt(rho)) * get_base1(inv_sqrt_scale_factor, j, "inv_sqrt_scale_factor", 1)), stan::model::rvalue(phi_tilde, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi_tilde")), 
                        "assigning variable phi");
            current_statement_begin__ = 189;
            stan::math::assign(pos, (pos + get_base1(group_size, j, "group_size", 1)));
        }
        current_statement_begin__ = 191;
        return stan::math::promote_scalar<fun_return_scalar_t__>(phi);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct make_phi_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_tilde,
             const T1__& phi_scale,
             const T2__& rho,
             const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& inv_sqrt_scale_factor,
             const int& n,
             const int& k,
             const std::vector<int>& group_size,
             const std::vector<int>& group_idx, std::ostream* pstream__) const {
        return make_phi(phi_tilde, phi_scale, rho, inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_bym(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                 const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta,
                 const int& n,
                 const int& k,
                 const std::vector<int>& group_size,
                 const std::vector<int>& group_idx, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 211;
        validate_non_negative_index("convolution", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolution(n);
        stan::math::initialize(convolution, DUMMY_VAR__);
        stan::math::fill(convolution, DUMMY_VAR__);
        current_statement_begin__ = 212;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 213;
        for (int j = 1; j <= k; ++j) {
            current_statement_begin__ = 214;
            if (as_bool(logical_eq(get_base1(group_size, j, "group_size", 1), 1))) {
                current_statement_begin__ = 215;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), 
                            stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "theta"), 
                            "assigning variable convolution");
            } else {
                current_statement_begin__ = 217;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), 
                            add(stan::model::rvalue(phi, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi"), stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "theta")), 
                            "assigning variable convolution");
            }
            current_statement_begin__ = 220;
            stan::math::assign(pos, (pos + get_base1(group_size, j, "group_size", 1)));
        }
        current_statement_begin__ = 222;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolution);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_bym_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi,
                 const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta,
                 const int& n,
                 const int& k,
                 const std::vector<int>& group_size,
                 const std::vector<int>& group_idx, std::ostream* pstream__) const {
        return convolve_bym(phi, theta, n, k, group_size, group_idx, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T7__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type, Eigen::Dynamic, 1>
convolve_bym2(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_tilde,
                  const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta_tilde,
                  const T2__& spatial_scale,
                  const int& n,
                  const int& k,
                  const std::vector<int>& group_size,
                  const std::vector<int>& group_idx,
                  const T7__& rho,
                  const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& inv_sqrt_scale_factor, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 247;
        validate_non_negative_index("convolution", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolution(n);
        stan::math::initialize(convolution, DUMMY_VAR__);
        stan::math::fill(convolution, DUMMY_VAR__);
        current_statement_begin__ = 248;
        int pos(0);
        (void) pos;  // dummy to suppress unused var warning
        stan::math::fill(pos, std::numeric_limits<int>::min());
        stan::math::assign(pos,1);
        current_statement_begin__ = 249;
        for (int j = 1; j <= k; ++j) {
            current_statement_begin__ = 250;
            if (as_bool(logical_eq(get_base1(group_size, j, "group_size", 1), 1))) {
                current_statement_begin__ = 251;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), 
                            multiply(spatial_scale, stan::model::rvalue(theta_tilde, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "theta_tilde")), 
                            "assigning variable convolution");
            } else {
                current_statement_begin__ = 253;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), 
                            multiply(spatial_scale, add(multiply((stan::math::sqrt(rho) * get_base1(inv_sqrt_scale_factor, j, "inv_sqrt_scale_factor", 1)), stan::model::rvalue(phi_tilde, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "phi_tilde")), multiply(stan::math::sqrt((1 - rho)), stan::model::rvalue(theta_tilde, stan::model::cons_list(stan::model::index_multi(segment(group_idx, pos, get_base1(group_size, j, "group_size", 1))), stan::model::nil_index_list()), "theta_tilde")))), 
                            "assigning variable convolution");
            }
            current_statement_begin__ = 258;
            stan::math::assign(pos, (pos + get_base1(group_size, j, "group_size", 1)));
        }
        current_statement_begin__ = 260;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolution);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_bym2_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T7__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& phi_tilde,
                  const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta_tilde,
                  const T2__& spatial_scale,
                  const int& n,
                  const int& k,
                  const std::vector<int>& group_size,
                  const std::vector<int>& group_idx,
                  const T7__& rho,
                  const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& inv_sqrt_scale_factor, std::ostream* pstream__) const {
        return convolve_bym2(phi_tilde, theta_tilde, spatial_scale, n, k, group_size, group_idx, rho, inv_sqrt_scale_factor, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_foundation
  : public stan::model::model_base_crtp<model_foundation> {
private:
        int family;
        int n;
        int center_x;
        int n_mis;
        int n_obs;
        std::vector<int> y_mis_idx;
        std::vector<int> y_obs_idx;
        int censor_point;
        vector_d y;
        std::vector<int> y_int;
        std::vector<int> trials;
        int prior_only;
        vector_d offset;
        int dwx;
        std::vector<int> wx_idx;
        int dw_nonzero;
        vector_d W_w;
        std::vector<int> W_v;
        std::vector<int> W_u;
        std::vector<double> bounds;
        int dx_obs;
        int dx_me;
        std::vector<int> use_logit;
        std::vector<int> x_obs_idx;
        std::vector<int> x_me_idx;
        matrix_d x_obs;
        std::vector<vector_d> x_me;
        std::vector<vector_d> sigma_me;
        vector_d prior_nux_true_alpha;
        vector_d prior_nux_true_beta;
        vector_d prior_mux_true_location;
        vector_d prior_mux_true_scale;
        vector_d prior_sigmax_true_df;
        vector_d prior_sigmax_true_location;
        vector_d prior_sigmax_true_scale;
        vector_d prior_rhox_true;
        int spatial_me;
        int WCAR;
        int nAx_w;
        int nC;
        vector_d Ax_w;
        std::vector<int> Ax_v;
        std::vector<int> Ax_u;
        std::vector<int> Cidx;
        vector_d Delta_inv;
        double log_det_Delta_inv;
        vector_d lambda;
        int has_re;
        int n_ids;
        std::vector<int> id;
        vector_d prior_alpha;
        int dbeta_prior;
        vector_d prior_beta_location;
        vector_d prior_beta_scale;
        vector_d prior_alpha_tau;
        vector_d prior_t_nu;
        vector_d prior_sigma;
        int type;
        int k;
        std::vector<int> group_size;
        std::vector<int> group_idx;
        int m;
        matrix_d A;
        int n_edges;
        std::vector<int> node1;
        std::vector<int> node2;
        vector_d weight;
        std::vector<int> comp_id;
        vector_d inv_sqrt_scale_factor;
        int dev;
        matrix_d EV;
        double global_scale;
        double slab_scale;
        double slab_df;
        std::vector<double> car_rho_lims;
        int car;
        int has_theta;
        int is_gaussian;
        int is_student;
        int is_poisson;
        int is_binomial;
        int is_auto_gaussian;
        int has_sigma;
        int has_offset;
        int dx_all;
        int has_me;
public:
    model_foundation(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_foundation(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_foundation_namespace::model_foundation";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 268;
            context__.validate_dims("data initialization", "family", "int", context__.to_vec());
            family = int(0);
            vals_i__ = context__.vals_i("family");
            pos__ = 0;
            family = vals_i__[pos__++];
            check_greater_or_equal(function__, "family", family, 0);
            check_less_or_equal(function__, "family", family, 5);
            current_statement_begin__ = 271;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 273;
            context__.validate_dims("data initialization", "center_x", "int", context__.to_vec());
            center_x = int(0);
            vals_i__ = context__.vals_i("center_x");
            pos__ = 0;
            center_x = vals_i__[pos__++];
            check_greater_or_equal(function__, "center_x", center_x, 0);
            current_statement_begin__ = 276;
            context__.validate_dims("data initialization", "n_mis", "int", context__.to_vec());
            n_mis = int(0);
            vals_i__ = context__.vals_i("n_mis");
            pos__ = 0;
            n_mis = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_mis", n_mis, 0);
            current_statement_begin__ = 277;
            context__.validate_dims("data initialization", "n_obs", "int", context__.to_vec());
            n_obs = int(0);
            vals_i__ = context__.vals_i("n_obs");
            pos__ = 0;
            n_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_obs", n_obs, 0);
            current_statement_begin__ = 278;
            validate_non_negative_index("y_mis_idx", "n_mis", n_mis);
            context__.validate_dims("data initialization", "y_mis_idx", "int", context__.to_vec(n_mis));
            y_mis_idx = std::vector<int>(n_mis, int(0));
            vals_i__ = context__.vals_i("y_mis_idx");
            pos__ = 0;
            size_t y_mis_idx_k_0_max__ = n_mis;
            for (size_t k_0__ = 0; k_0__ < y_mis_idx_k_0_max__; ++k_0__) {
                y_mis_idx[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 279;
            validate_non_negative_index("y_obs_idx", "n_obs", n_obs);
            context__.validate_dims("data initialization", "y_obs_idx", "int", context__.to_vec(n_obs));
            y_obs_idx = std::vector<int>(n_obs, int(0));
            vals_i__ = context__.vals_i("y_obs_idx");
            pos__ = 0;
            size_t y_obs_idx_k_0_max__ = n_obs;
            for (size_t k_0__ = 0; k_0__ < y_obs_idx_k_0_max__; ++k_0__) {
                y_obs_idx[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 280;
            context__.validate_dims("data initialization", "censor_point", "int", context__.to_vec());
            censor_point = int(0);
            vals_i__ = context__.vals_i("censor_point");
            pos__ = 0;
            censor_point = vals_i__[pos__++];
            current_statement_begin__ = 283;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 284;
            validate_non_negative_index("y_int", "n", n);
            context__.validate_dims("data initialization", "y_int", "int", context__.to_vec(n));
            y_int = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y_int");
            pos__ = 0;
            size_t y_int_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_int_k_0_max__; ++k_0__) {
                y_int[k_0__] = vals_i__[pos__++];
            }
            size_t y_int_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_int_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y_int[i_0__]", y_int[i_0__], 0);
            }
            current_statement_begin__ = 285;
            validate_non_negative_index("trials", "n", n);
            context__.validate_dims("data initialization", "trials", "int", context__.to_vec(n));
            trials = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("trials");
            pos__ = 0;
            size_t trials_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < trials_k_0_max__; ++k_0__) {
                trials[k_0__] = vals_i__[pos__++];
            }
            size_t trials_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < trials_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "trials[i_0__]", trials[i_0__], 0);
            }
            current_statement_begin__ = 286;
            context__.validate_dims("data initialization", "prior_only", "int", context__.to_vec());
            prior_only = int(0);
            vals_i__ = context__.vals_i("prior_only");
            pos__ = 0;
            prior_only = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_only", prior_only, 0);
            check_less_or_equal(function__, "prior_only", prior_only, 1);
            current_statement_begin__ = 289;
            validate_non_negative_index("offset", "n", n);
            context__.validate_dims("data initialization", "offset", "vector_d", context__.to_vec(n));
            offset = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("offset");
            pos__ = 0;
            size_t offset_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < offset_j_1_max__; ++j_1__) {
                offset(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 292;
            context__.validate_dims("data initialization", "dwx", "int", context__.to_vec());
            dwx = int(0);
            vals_i__ = context__.vals_i("dwx");
            pos__ = 0;
            dwx = vals_i__[pos__++];
            check_greater_or_equal(function__, "dwx", dwx, 0);
            current_statement_begin__ = 293;
            validate_non_negative_index("wx_idx", "(dwx ? dwx : 1 )", (dwx ? dwx : 1 ));
            context__.validate_dims("data initialization", "wx_idx", "int", context__.to_vec((dwx ? dwx : 1 )));
            wx_idx = std::vector<int>((dwx ? dwx : 1 ), int(0));
            vals_i__ = context__.vals_i("wx_idx");
            pos__ = 0;
            size_t wx_idx_k_0_max__ = (dwx ? dwx : 1 );
            for (size_t k_0__ = 0; k_0__ < wx_idx_k_0_max__; ++k_0__) {
                wx_idx[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 294;
            context__.validate_dims("data initialization", "dw_nonzero", "int", context__.to_vec());
            dw_nonzero = int(0);
            vals_i__ = context__.vals_i("dw_nonzero");
            pos__ = 0;
            dw_nonzero = vals_i__[pos__++];
            check_greater_or_equal(function__, "dw_nonzero", dw_nonzero, 0);
            current_statement_begin__ = 295;
            validate_non_negative_index("W_w", "dw_nonzero", dw_nonzero);
            context__.validate_dims("data initialization", "W_w", "vector_d", context__.to_vec(dw_nonzero));
            W_w = Eigen::Matrix<double, Eigen::Dynamic, 1>(dw_nonzero);
            vals_r__ = context__.vals_r("W_w");
            pos__ = 0;
            size_t W_w_j_1_max__ = dw_nonzero;
            for (size_t j_1__ = 0; j_1__ < W_w_j_1_max__; ++j_1__) {
                W_w(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 296;
            validate_non_negative_index("W_v", "dw_nonzero", dw_nonzero);
            context__.validate_dims("data initialization", "W_v", "int", context__.to_vec(dw_nonzero));
            W_v = std::vector<int>(dw_nonzero, int(0));
            vals_i__ = context__.vals_i("W_v");
            pos__ = 0;
            size_t W_v_k_0_max__ = dw_nonzero;
            for (size_t k_0__ = 0; k_0__ < W_v_k_0_max__; ++k_0__) {
                W_v[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 297;
            validate_non_negative_index("W_u", "(dwx ? (n + 1) : 1 )", (dwx ? (n + 1) : 1 ));
            context__.validate_dims("data initialization", "W_u", "int", context__.to_vec((dwx ? (n + 1) : 1 )));
            W_u = std::vector<int>((dwx ? (n + 1) : 1 ), int(0));
            vals_i__ = context__.vals_i("W_u");
            pos__ = 0;
            size_t W_u_k_0_max__ = (dwx ? (n + 1) : 1 );
            for (size_t k_0__ = 0; k_0__ < W_u_k_0_max__; ++k_0__) {
                W_u[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 301;
            validate_non_negative_index("bounds", "2", 2);
            context__.validate_dims("data initialization", "bounds", "double", context__.to_vec(2));
            bounds = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("bounds");
            pos__ = 0;
            size_t bounds_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < bounds_k_0_max__; ++k_0__) {
                bounds[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 303;
            context__.validate_dims("data initialization", "dx_obs", "int", context__.to_vec());
            dx_obs = int(0);
            vals_i__ = context__.vals_i("dx_obs");
            pos__ = 0;
            dx_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "dx_obs", dx_obs, 0);
            current_statement_begin__ = 304;
            context__.validate_dims("data initialization", "dx_me", "int", context__.to_vec());
            dx_me = int(0);
            vals_i__ = context__.vals_i("dx_me");
            pos__ = 0;
            dx_me = vals_i__[pos__++];
            check_greater_or_equal(function__, "dx_me", dx_me, 0);
            current_statement_begin__ = 305;
            validate_non_negative_index("use_logit", "dx_me", dx_me);
            context__.validate_dims("data initialization", "use_logit", "int", context__.to_vec(dx_me));
            use_logit = std::vector<int>(dx_me, int(0));
            vals_i__ = context__.vals_i("use_logit");
            pos__ = 0;
            size_t use_logit_k_0_max__ = dx_me;
            for (size_t k_0__ = 0; k_0__ < use_logit_k_0_max__; ++k_0__) {
                use_logit[k_0__] = vals_i__[pos__++];
            }
            size_t use_logit_i_0_max__ = dx_me;
            for (size_t i_0__ = 0; i_0__ < use_logit_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "use_logit[i_0__]", use_logit[i_0__], 0);
                check_less_or_equal(function__, "use_logit[i_0__]", use_logit[i_0__], 1);
            }
            current_statement_begin__ = 307;
            validate_non_negative_index("x_obs_idx", "(dx_obs ? dx_obs : 1 )", (dx_obs ? dx_obs : 1 ));
            context__.validate_dims("data initialization", "x_obs_idx", "int", context__.to_vec((dx_obs ? dx_obs : 1 )));
            x_obs_idx = std::vector<int>((dx_obs ? dx_obs : 1 ), int(0));
            vals_i__ = context__.vals_i("x_obs_idx");
            pos__ = 0;
            size_t x_obs_idx_k_0_max__ = (dx_obs ? dx_obs : 1 );
            for (size_t k_0__ = 0; k_0__ < x_obs_idx_k_0_max__; ++k_0__) {
                x_obs_idx[k_0__] = vals_i__[pos__++];
            }
            size_t x_obs_idx_i_0_max__ = (dx_obs ? dx_obs : 1 );
            for (size_t i_0__ = 0; i_0__ < x_obs_idx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_obs_idx[i_0__]", x_obs_idx[i_0__], 0);
            }
            current_statement_begin__ = 308;
            validate_non_negative_index("x_me_idx", "(dx_me ? dx_me : 1 )", (dx_me ? dx_me : 1 ));
            context__.validate_dims("data initialization", "x_me_idx", "int", context__.to_vec((dx_me ? dx_me : 1 )));
            x_me_idx = std::vector<int>((dx_me ? dx_me : 1 ), int(0));
            vals_i__ = context__.vals_i("x_me_idx");
            pos__ = 0;
            size_t x_me_idx_k_0_max__ = (dx_me ? dx_me : 1 );
            for (size_t k_0__ = 0; k_0__ < x_me_idx_k_0_max__; ++k_0__) {
                x_me_idx[k_0__] = vals_i__[pos__++];
            }
            size_t x_me_idx_i_0_max__ = (dx_me ? dx_me : 1 );
            for (size_t i_0__ = 0; i_0__ < x_me_idx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_me_idx[i_0__]", x_me_idx[i_0__], 0);
            }
            current_statement_begin__ = 310;
            validate_non_negative_index("x_obs", "n", n);
            validate_non_negative_index("x_obs", "(dx_obs ? dx_obs : 0 )", (dx_obs ? dx_obs : 0 ));
            context__.validate_dims("data initialization", "x_obs", "matrix_d", context__.to_vec(n,(dx_obs ? dx_obs : 0 )));
            x_obs = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, (dx_obs ? dx_obs : 0 ));
            vals_r__ = context__.vals_r("x_obs");
            pos__ = 0;
            size_t x_obs_j_2_max__ = (dx_obs ? dx_obs : 0 );
            size_t x_obs_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < x_obs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_obs_j_1_max__; ++j_1__) {
                    x_obs(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 312;
            validate_non_negative_index("x_me", "n", n);
            validate_non_negative_index("x_me", "dx_me", dx_me);
            context__.validate_dims("data initialization", "x_me", "vector_d", context__.to_vec(dx_me,n));
            x_me = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(dx_me, Eigen::Matrix<double, Eigen::Dynamic, 1>(n));
            vals_r__ = context__.vals_r("x_me");
            pos__ = 0;
            size_t x_me_j_1_max__ = n;
            size_t x_me_k_0_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < x_me_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < x_me_k_0_max__; ++k_0__) {
                    x_me[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 313;
            validate_non_negative_index("sigma_me", "n", n);
            validate_non_negative_index("sigma_me", "dx_me", dx_me);
            context__.validate_dims("data initialization", "sigma_me", "vector_d", context__.to_vec(dx_me,n));
            sigma_me = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(dx_me, Eigen::Matrix<double, Eigen::Dynamic, 1>(n));
            vals_r__ = context__.vals_r("sigma_me");
            pos__ = 0;
            size_t sigma_me_j_1_max__ = n;
            size_t sigma_me_k_0_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < sigma_me_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sigma_me_k_0_max__; ++k_0__) {
                    sigma_me[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            size_t sigma_me_i_0_max__ = dx_me;
            for (size_t i_0__ = 0; i_0__ < sigma_me_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "sigma_me[i_0__]", sigma_me[i_0__], 0);
            }
            current_statement_begin__ = 315;
            validate_non_negative_index("prior_nux_true_alpha", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_nux_true_alpha", "vector_d", context__.to_vec(dx_me));
            prior_nux_true_alpha = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_nux_true_alpha");
            pos__ = 0;
            size_t prior_nux_true_alpha_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_nux_true_alpha_j_1_max__; ++j_1__) {
                prior_nux_true_alpha(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 316;
            validate_non_negative_index("prior_nux_true_beta", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_nux_true_beta", "vector_d", context__.to_vec(dx_me));
            prior_nux_true_beta = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_nux_true_beta");
            pos__ = 0;
            size_t prior_nux_true_beta_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_nux_true_beta_j_1_max__; ++j_1__) {
                prior_nux_true_beta(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 317;
            validate_non_negative_index("prior_mux_true_location", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_mux_true_location", "vector_d", context__.to_vec(dx_me));
            prior_mux_true_location = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_mux_true_location");
            pos__ = 0;
            size_t prior_mux_true_location_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_mux_true_location_j_1_max__; ++j_1__) {
                prior_mux_true_location(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 318;
            validate_non_negative_index("prior_mux_true_scale", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_mux_true_scale", "vector_d", context__.to_vec(dx_me));
            prior_mux_true_scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_mux_true_scale");
            pos__ = 0;
            size_t prior_mux_true_scale_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_mux_true_scale_j_1_max__; ++j_1__) {
                prior_mux_true_scale(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 319;
            validate_non_negative_index("prior_sigmax_true_df", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_sigmax_true_df", "vector_d", context__.to_vec(dx_me));
            prior_sigmax_true_df = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_sigmax_true_df");
            pos__ = 0;
            size_t prior_sigmax_true_df_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_sigmax_true_df_j_1_max__; ++j_1__) {
                prior_sigmax_true_df(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 320;
            validate_non_negative_index("prior_sigmax_true_location", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_sigmax_true_location", "vector_d", context__.to_vec(dx_me));
            prior_sigmax_true_location = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_sigmax_true_location");
            pos__ = 0;
            size_t prior_sigmax_true_location_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_sigmax_true_location_j_1_max__; ++j_1__) {
                prior_sigmax_true_location(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 321;
            validate_non_negative_index("prior_sigmax_true_scale", "dx_me", dx_me);
            context__.validate_dims("data initialization", "prior_sigmax_true_scale", "vector_d", context__.to_vec(dx_me));
            prior_sigmax_true_scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(dx_me);
            vals_r__ = context__.vals_r("prior_sigmax_true_scale");
            pos__ = 0;
            size_t prior_sigmax_true_scale_j_1_max__ = dx_me;
            for (size_t j_1__ = 0; j_1__ < prior_sigmax_true_scale_j_1_max__; ++j_1__) {
                prior_sigmax_true_scale(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 322;
            validate_non_negative_index("prior_rhox_true", "2", 2);
            context__.validate_dims("data initialization", "prior_rhox_true", "vector_d", context__.to_vec(2));
            prior_rhox_true = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("prior_rhox_true");
            pos__ = 0;
            size_t prior_rhox_true_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < prior_rhox_true_j_1_max__; ++j_1__) {
                prior_rhox_true(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 324;
            context__.validate_dims("data initialization", "spatial_me", "int", context__.to_vec());
            spatial_me = int(0);
            vals_i__ = context__.vals_i("spatial_me");
            pos__ = 0;
            spatial_me = vals_i__[pos__++];
            check_greater_or_equal(function__, "spatial_me", spatial_me, 0);
            check_less_or_equal(function__, "spatial_me", spatial_me, 1);
            current_statement_begin__ = 325;
            context__.validate_dims("data initialization", "WCAR", "int", context__.to_vec());
            WCAR = int(0);
            vals_i__ = context__.vals_i("WCAR");
            pos__ = 0;
            WCAR = vals_i__[pos__++];
            check_greater_or_equal(function__, "WCAR", WCAR, 0);
            check_less_or_equal(function__, "WCAR", WCAR, 1);
            current_statement_begin__ = 326;
            context__.validate_dims("data initialization", "nAx_w", "int", context__.to_vec());
            nAx_w = int(0);
            vals_i__ = context__.vals_i("nAx_w");
            pos__ = 0;
            nAx_w = vals_i__[pos__++];
            current_statement_begin__ = 327;
            context__.validate_dims("data initialization", "nC", "int", context__.to_vec());
            nC = int(0);
            vals_i__ = context__.vals_i("nC");
            pos__ = 0;
            nC = vals_i__[pos__++];
            current_statement_begin__ = 328;
            validate_non_negative_index("Ax_w", "nAx_w", nAx_w);
            context__.validate_dims("data initialization", "Ax_w", "vector_d", context__.to_vec(nAx_w));
            Ax_w = Eigen::Matrix<double, Eigen::Dynamic, 1>(nAx_w);
            vals_r__ = context__.vals_r("Ax_w");
            pos__ = 0;
            size_t Ax_w_j_1_max__ = nAx_w;
            for (size_t j_1__ = 0; j_1__ < Ax_w_j_1_max__; ++j_1__) {
                Ax_w(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 329;
            validate_non_negative_index("Ax_v", "nAx_w", nAx_w);
            context__.validate_dims("data initialization", "Ax_v", "int", context__.to_vec(nAx_w));
            Ax_v = std::vector<int>(nAx_w, int(0));
            vals_i__ = context__.vals_i("Ax_v");
            pos__ = 0;
            size_t Ax_v_k_0_max__ = nAx_w;
            for (size_t k_0__ = 0; k_0__ < Ax_v_k_0_max__; ++k_0__) {
                Ax_v[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 330;
            validate_non_negative_index("Ax_u", "(n + 1)", (n + 1));
            context__.validate_dims("data initialization", "Ax_u", "int", context__.to_vec((n + 1)));
            Ax_u = std::vector<int>((n + 1), int(0));
            vals_i__ = context__.vals_i("Ax_u");
            pos__ = 0;
            size_t Ax_u_k_0_max__ = (n + 1);
            for (size_t k_0__ = 0; k_0__ < Ax_u_k_0_max__; ++k_0__) {
                Ax_u[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 331;
            validate_non_negative_index("Cidx", "nC", nC);
            context__.validate_dims("data initialization", "Cidx", "int", context__.to_vec(nC));
            Cidx = std::vector<int>(nC, int(0));
            vals_i__ = context__.vals_i("Cidx");
            pos__ = 0;
            size_t Cidx_k_0_max__ = nC;
            for (size_t k_0__ = 0; k_0__ < Cidx_k_0_max__; ++k_0__) {
                Cidx[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 332;
            validate_non_negative_index("Delta_inv", "n", n);
            context__.validate_dims("data initialization", "Delta_inv", "vector_d", context__.to_vec(n));
            Delta_inv = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("Delta_inv");
            pos__ = 0;
            size_t Delta_inv_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < Delta_inv_j_1_max__; ++j_1__) {
                Delta_inv(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 333;
            context__.validate_dims("data initialization", "log_det_Delta_inv", "double", context__.to_vec());
            log_det_Delta_inv = double(0);
            vals_r__ = context__.vals_r("log_det_Delta_inv");
            pos__ = 0;
            log_det_Delta_inv = vals_r__[pos__++];
            current_statement_begin__ = 334;
            validate_non_negative_index("lambda", "n", n);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
            lambda = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                lambda(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 337;
            context__.validate_dims("data initialization", "has_re", "int", context__.to_vec());
            has_re = int(0);
            vals_i__ = context__.vals_i("has_re");
            pos__ = 0;
            has_re = vals_i__[pos__++];
            check_greater_or_equal(function__, "has_re", has_re, 0);
            check_less_or_equal(function__, "has_re", has_re, 1);
            current_statement_begin__ = 338;
            context__.validate_dims("data initialization", "n_ids", "int", context__.to_vec());
            n_ids = int(0);
            vals_i__ = context__.vals_i("n_ids");
            pos__ = 0;
            n_ids = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_ids", n_ids, 0);
            current_statement_begin__ = 339;
            validate_non_negative_index("id", "n", n);
            context__.validate_dims("data initialization", "id", "int", context__.to_vec(n));
            id = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("id");
            pos__ = 0;
            size_t id_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < id_k_0_max__; ++k_0__) {
                id[k_0__] = vals_i__[pos__++];
            }
            size_t id_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "id[i_0__]", id[i_0__], 0);
                check_less_or_equal(function__, "id[i_0__]", id[i_0__], n_ids);
            }
            current_statement_begin__ = 341;
            validate_non_negative_index("prior_alpha", "2", 2);
            context__.validate_dims("data initialization", "prior_alpha", "vector_d", context__.to_vec(2));
            prior_alpha = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("prior_alpha");
            pos__ = 0;
            size_t prior_alpha_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < prior_alpha_j_1_max__; ++j_1__) {
                prior_alpha(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 342;
            context__.validate_dims("data initialization", "dbeta_prior", "int", context__.to_vec());
            dbeta_prior = int(0);
            vals_i__ = context__.vals_i("dbeta_prior");
            pos__ = 0;
            dbeta_prior = vals_i__[pos__++];
            check_greater_or_equal(function__, "dbeta_prior", dbeta_prior, 0);
            current_statement_begin__ = 343;
            validate_non_negative_index("prior_beta_location", "dbeta_prior", dbeta_prior);
            context__.validate_dims("data initialization", "prior_beta_location", "vector_d", context__.to_vec(dbeta_prior));
            prior_beta_location = Eigen::Matrix<double, Eigen::Dynamic, 1>(dbeta_prior);
            vals_r__ = context__.vals_r("prior_beta_location");
            pos__ = 0;
            size_t prior_beta_location_j_1_max__ = dbeta_prior;
            for (size_t j_1__ = 0; j_1__ < prior_beta_location_j_1_max__; ++j_1__) {
                prior_beta_location(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 344;
            validate_non_negative_index("prior_beta_scale", "dbeta_prior", dbeta_prior);
            context__.validate_dims("data initialization", "prior_beta_scale", "vector_d", context__.to_vec(dbeta_prior));
            prior_beta_scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(dbeta_prior);
            vals_r__ = context__.vals_r("prior_beta_scale");
            pos__ = 0;
            size_t prior_beta_scale_j_1_max__ = dbeta_prior;
            for (size_t j_1__ = 0; j_1__ < prior_beta_scale_j_1_max__; ++j_1__) {
                prior_beta_scale(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_beta_scale", prior_beta_scale, 0);
            current_statement_begin__ = 346;
            validate_non_negative_index("prior_alpha_tau", "3", 3);
            context__.validate_dims("data initialization", "prior_alpha_tau", "vector_d", context__.to_vec(3));
            prior_alpha_tau = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_alpha_tau");
            pos__ = 0;
            size_t prior_alpha_tau_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_alpha_tau_j_1_max__; ++j_1__) {
                prior_alpha_tau(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 347;
            validate_non_negative_index("prior_t_nu", "2", 2);
            context__.validate_dims("data initialization", "prior_t_nu", "vector_d", context__.to_vec(2));
            prior_t_nu = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("prior_t_nu");
            pos__ = 0;
            size_t prior_t_nu_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < prior_t_nu_j_1_max__; ++j_1__) {
                prior_t_nu(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 348;
            validate_non_negative_index("prior_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_sigma", "vector_d", context__.to_vec(3));
            prior_sigma = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_sigma");
            pos__ = 0;
            size_t prior_sigma_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_sigma_j_1_max__; ++j_1__) {
                prior_sigma(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 351;
            context__.validate_dims("data initialization", "type", "int", context__.to_vec());
            type = int(0);
            vals_i__ = context__.vals_i("type");
            pos__ = 0;
            type = vals_i__[pos__++];
            check_greater_or_equal(function__, "type", type, 0);
            check_less_or_equal(function__, "type", type, 3);
            current_statement_begin__ = 352;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 1);
            current_statement_begin__ = 353;
            validate_non_negative_index("group_size", "k", k);
            context__.validate_dims("data initialization", "group_size", "int", context__.to_vec(k));
            group_size = std::vector<int>(k, int(0));
            vals_i__ = context__.vals_i("group_size");
            pos__ = 0;
            size_t group_size_k_0_max__ = k;
            for (size_t k_0__ = 0; k_0__ < group_size_k_0_max__; ++k_0__) {
                group_size[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 354;
            validate_non_negative_index("group_idx", "n", n);
            context__.validate_dims("data initialization", "group_idx", "int", context__.to_vec(n));
            group_idx = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("group_idx");
            pos__ = 0;
            size_t group_idx_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < group_idx_k_0_max__; ++k_0__) {
                group_idx[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 355;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 0);
            current_statement_begin__ = 356;
            validate_non_negative_index("A", "n", n);
            validate_non_negative_index("A", "m", m);
            context__.validate_dims("data initialization", "A", "matrix_d", context__.to_vec(n,m));
            A = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, m);
            vals_r__ = context__.vals_r("A");
            pos__ = 0;
            size_t A_j_2_max__ = m;
            size_t A_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                    A(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 357;
            context__.validate_dims("data initialization", "n_edges", "int", context__.to_vec());
            n_edges = int(0);
            vals_i__ = context__.vals_i("n_edges");
            pos__ = 0;
            n_edges = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_edges", n_edges, 1);
            current_statement_begin__ = 358;
            validate_non_negative_index("node1", "n_edges", n_edges);
            context__.validate_dims("data initialization", "node1", "int", context__.to_vec(n_edges));
            node1 = std::vector<int>(n_edges, int(0));
            vals_i__ = context__.vals_i("node1");
            pos__ = 0;
            size_t node1_k_0_max__ = n_edges;
            for (size_t k_0__ = 0; k_0__ < node1_k_0_max__; ++k_0__) {
                node1[k_0__] = vals_i__[pos__++];
            }
            size_t node1_i_0_max__ = n_edges;
            for (size_t i_0__ = 0; i_0__ < node1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node1[i_0__]", node1[i_0__], 1);
                check_less_or_equal(function__, "node1[i_0__]", node1[i_0__], n);
            }
            current_statement_begin__ = 359;
            validate_non_negative_index("node2", "n_edges", n_edges);
            context__.validate_dims("data initialization", "node2", "int", context__.to_vec(n_edges));
            node2 = std::vector<int>(n_edges, int(0));
            vals_i__ = context__.vals_i("node2");
            pos__ = 0;
            size_t node2_k_0_max__ = n_edges;
            for (size_t k_0__ = 0; k_0__ < node2_k_0_max__; ++k_0__) {
                node2[k_0__] = vals_i__[pos__++];
            }
            size_t node2_i_0_max__ = n_edges;
            for (size_t i_0__ = 0; i_0__ < node2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node2[i_0__]", node2[i_0__], 1);
                check_less_or_equal(function__, "node2[i_0__]", node2[i_0__], n);
            }
            current_statement_begin__ = 360;
            validate_non_negative_index("weight", "n_edges", n_edges);
            context__.validate_dims("data initialization", "weight", "vector_d", context__.to_vec(n_edges));
            weight = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_edges);
            vals_r__ = context__.vals_r("weight");
            pos__ = 0;
            size_t weight_j_1_max__ = n_edges;
            for (size_t j_1__ = 0; j_1__ < weight_j_1_max__; ++j_1__) {
                weight(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 361;
            validate_non_negative_index("comp_id", "n", n);
            context__.validate_dims("data initialization", "comp_id", "int", context__.to_vec(n));
            comp_id = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("comp_id");
            pos__ = 0;
            size_t comp_id_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < comp_id_k_0_max__; ++k_0__) {
                comp_id[k_0__] = vals_i__[pos__++];
            }
            size_t comp_id_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < comp_id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "comp_id[i_0__]", comp_id[i_0__], 1);
                check_less_or_equal(function__, "comp_id[i_0__]", comp_id[i_0__], k);
            }
            current_statement_begin__ = 362;
            validate_non_negative_index("inv_sqrt_scale_factor", "k", k);
            context__.validate_dims("data initialization", "inv_sqrt_scale_factor", "vector_d", context__.to_vec(k));
            inv_sqrt_scale_factor = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("inv_sqrt_scale_factor");
            pos__ = 0;
            size_t inv_sqrt_scale_factor_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < inv_sqrt_scale_factor_j_1_max__; ++j_1__) {
                inv_sqrt_scale_factor(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 365;
            context__.validate_dims("data initialization", "dev", "int", context__.to_vec());
            dev = int(0);
            vals_i__ = context__.vals_i("dev");
            pos__ = 0;
            dev = vals_i__[pos__++];
            check_greater_or_equal(function__, "dev", dev, 0);
            current_statement_begin__ = 366;
            validate_non_negative_index("EV", "n", n);
            validate_non_negative_index("EV", "dev", dev);
            context__.validate_dims("data initialization", "EV", "matrix_d", context__.to_vec(n,dev));
            EV = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, dev);
            vals_r__ = context__.vals_r("EV");
            pos__ = 0;
            size_t EV_j_2_max__ = dev;
            size_t EV_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < EV_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < EV_j_1_max__; ++j_1__) {
                    EV(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 367;
            context__.validate_dims("data initialization", "global_scale", "double", context__.to_vec());
            global_scale = double(0);
            vals_r__ = context__.vals_r("global_scale");
            pos__ = 0;
            global_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "global_scale", global_scale, 0);
            current_statement_begin__ = 368;
            context__.validate_dims("data initialization", "slab_scale", "double", context__.to_vec());
            slab_scale = double(0);
            vals_r__ = context__.vals_r("slab_scale");
            pos__ = 0;
            slab_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_scale", slab_scale, 0);
            current_statement_begin__ = 369;
            context__.validate_dims("data initialization", "slab_df", "double", context__.to_vec());
            slab_df = double(0);
            vals_r__ = context__.vals_r("slab_df");
            pos__ = 0;
            slab_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_df", slab_df, 0);
            current_statement_begin__ = 372;
            validate_non_negative_index("car_rho_lims", "2", 2);
            context__.validate_dims("data initialization", "car_rho_lims", "double", context__.to_vec(2));
            car_rho_lims = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("car_rho_lims");
            pos__ = 0;
            size_t car_rho_lims_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < car_rho_lims_k_0_max__; ++k_0__) {
                car_rho_lims[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 373;
            context__.validate_dims("data initialization", "car", "int", context__.to_vec());
            car = int(0);
            vals_i__ = context__.vals_i("car");
            pos__ = 0;
            car = vals_i__[pos__++];
            check_greater_or_equal(function__, "car", car, 0);
            check_less_or_equal(function__, "car", car, 1);
            // initialize transformed data variables
            current_statement_begin__ = 378;
            has_theta = int(0);
            stan::math::fill(has_theta, std::numeric_limits<int>::min());
            stan::math::assign(has_theta,logical_gt(type, 1));
            current_statement_begin__ = 381;
            is_gaussian = int(0);
            stan::math::fill(is_gaussian, std::numeric_limits<int>::min());
            current_statement_begin__ = 382;
            is_student = int(0);
            stan::math::fill(is_student, std::numeric_limits<int>::min());
            current_statement_begin__ = 383;
            is_poisson = int(0);
            stan::math::fill(is_poisson, std::numeric_limits<int>::min());
            current_statement_begin__ = 384;
            is_binomial = int(0);
            stan::math::fill(is_binomial, std::numeric_limits<int>::min());
            current_statement_begin__ = 385;
            is_auto_gaussian = int(0);
            stan::math::fill(is_auto_gaussian, std::numeric_limits<int>::min());
            current_statement_begin__ = 386;
            has_sigma = int(0);
            stan::math::fill(has_sigma, std::numeric_limits<int>::min());
            current_statement_begin__ = 387;
            has_offset = int(0);
            stan::math::fill(has_offset, std::numeric_limits<int>::min());
            current_statement_begin__ = 388;
            dx_all = int(0);
            stan::math::fill(dx_all, std::numeric_limits<int>::min());
            current_statement_begin__ = 389;
            has_me = int(0);
            stan::math::fill(has_me, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 390;
            stan::math::assign(is_gaussian, logical_eq(family, 1));
            current_statement_begin__ = 391;
            stan::math::assign(is_student, logical_eq(family, 2));
            current_statement_begin__ = 392;
            stan::math::assign(is_poisson, logical_eq(family, 3));
            current_statement_begin__ = 393;
            stan::math::assign(is_binomial, logical_eq(family, 4));
            current_statement_begin__ = 394;
            stan::math::assign(is_auto_gaussian, logical_eq(family, 5));
            current_statement_begin__ = 395;
            stan::math::assign(has_sigma, logical_lt(family, 3));
            current_statement_begin__ = 396;
            stan::math::assign(has_offset, logical_neq(sum(offset), 0));
            current_statement_begin__ = 397;
            stan::math::assign(dx_all, (dx_obs + dx_me));
            current_statement_begin__ = 398;
            stan::math::assign(has_me, logical_gt(dx_me, 0));
            // validate transformed data
            current_statement_begin__ = 381;
            check_greater_or_equal(function__, "is_gaussian", is_gaussian, 0);
            check_less_or_equal(function__, "is_gaussian", is_gaussian, 1);
            current_statement_begin__ = 382;
            check_greater_or_equal(function__, "is_student", is_student, 0);
            check_less_or_equal(function__, "is_student", is_student, 1);
            current_statement_begin__ = 383;
            check_greater_or_equal(function__, "is_poisson", is_poisson, 0);
            check_less_or_equal(function__, "is_poisson", is_poisson, 1);
            current_statement_begin__ = 384;
            check_greater_or_equal(function__, "is_binomial", is_binomial, 0);
            check_less_or_equal(function__, "is_binomial", is_binomial, 1);
            current_statement_begin__ = 385;
            check_greater_or_equal(function__, "is_auto_gaussian", is_auto_gaussian, 0);
            check_less_or_equal(function__, "is_auto_gaussian", is_auto_gaussian, 1);
            current_statement_begin__ = 386;
            check_greater_or_equal(function__, "has_sigma", has_sigma, 0);
            check_less_or_equal(function__, "has_sigma", has_sigma, 1);
            current_statement_begin__ = 387;
            check_greater_or_equal(function__, "has_offset", has_offset, 0);
            check_less_or_equal(function__, "has_offset", has_offset, 1);
            current_statement_begin__ = 388;
            check_greater_or_equal(function__, "dx_all", dx_all, 0);
            current_statement_begin__ = 389;
            check_greater_or_equal(function__, "has_me", has_me, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 404;
            validate_non_negative_index("alpha_phi", "m", m);
            num_params_r__ += m;
            current_statement_begin__ = 405;
            validate_non_negative_index("phi_tilde", "(type ? n : 0 )", (type ? n : 0 ));
            num_params_r__ += (type ? n : 0 );
            current_statement_begin__ = 406;
            validate_non_negative_index("spatial_scale", "(type ? 1 : 0 )", (type ? 1 : 0 ));
            num_params_r__ += (1 * (type ? 1 : 0 ));
            current_statement_begin__ = 407;
            validate_non_negative_index("theta_tilde", "(logical_gt(type, 1) ? n : 0 )", (logical_gt(type, 1) ? n : 0 ));
            num_params_r__ += (logical_gt(type, 1) ? n : 0 );
            current_statement_begin__ = 408;
            validate_non_negative_index("theta_scale", "logical_eq(type, 2)", logical_eq(type, 2));
            num_params_r__ += (1 * logical_eq(type, 2));
            current_statement_begin__ = 409;
            validate_non_negative_index("rho", "logical_eq(type, 3)", logical_eq(type, 3));
            num_params_r__ += (1 * logical_eq(type, 3));
            current_statement_begin__ = 411;
            validate_non_negative_index("aux1_global", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
            num_params_r__ += (1 * (dev ? 1 : 0 ));
            current_statement_begin__ = 412;
            validate_non_negative_index("aux2_global", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
            num_params_r__ += (1 * (dev ? 1 : 0 ));
            current_statement_begin__ = 413;
            validate_non_negative_index("aux1_local", "dev", dev);
            num_params_r__ += dev;
            current_statement_begin__ = 414;
            validate_non_negative_index("aux2_local", "dev", dev);
            num_params_r__ += dev;
            current_statement_begin__ = 415;
            validate_non_negative_index("caux", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
            num_params_r__ += (1 * (dev ? 1 : 0 ));
            current_statement_begin__ = 416;
            validate_non_negative_index("z", "dev", dev);
            num_params_r__ += dev;
            current_statement_begin__ = 418;
            validate_non_negative_index("log_lambda", "((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 )", ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
            num_params_r__ += ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 );
            current_statement_begin__ = 419;
            validate_non_negative_index("car_scale", "(car ? 1 : 0 )", (car ? 1 : 0 ));
            num_params_r__ += (1 * (car ? 1 : 0 ));
            current_statement_begin__ = 420;
            validate_non_negative_index("car_rho", "(car ? 1 : 0 )", (car ? 1 : 0 ));
            num_params_r__ += (1 * (car ? 1 : 0 ));
            current_statement_begin__ = 423;
            num_params_r__ += 1;
            current_statement_begin__ = 424;
            validate_non_negative_index("gamma", "dwx", dwx);
            num_params_r__ += dwx;
            current_statement_begin__ = 425;
            validate_non_negative_index("beta", "dx_all", dx_all);
            num_params_r__ += dx_all;
            current_statement_begin__ = 426;
            validate_non_negative_index("nu", "is_student", is_student);
            num_params_r__ += (1 * is_student);
            current_statement_begin__ = 427;
            validate_non_negative_index("sigma", "has_sigma", has_sigma);
            num_params_r__ += (1 * has_sigma);
            current_statement_begin__ = 429;
            validate_non_negative_index("alpha_re", "n_ids", n_ids);
            num_params_r__ += n_ids;
            current_statement_begin__ = 430;
            validate_non_negative_index("alpha_tau", "has_re", has_re);
            num_params_r__ += (1 * has_re);
            current_statement_begin__ = 432;
            validate_non_negative_index("x_true", "n", n);
            validate_non_negative_index("x_true", "dx_me", dx_me);
            num_params_r__ += (n * dx_me);
            current_statement_begin__ = 434;
            validate_non_negative_index("mu_x_true", "dx_me", dx_me);
            num_params_r__ += dx_me;
            current_statement_begin__ = 435;
            validate_non_negative_index("sigma_x_true", "dx_me", dx_me);
            num_params_r__ += dx_me;
            current_statement_begin__ = 436;
            validate_non_negative_index("car_rho_x_true", "(spatial_me ? dx_me : 0 )", (spatial_me ? dx_me : 0 ));
            num_params_r__ += (spatial_me ? dx_me : 0 );
            current_statement_begin__ = 437;
            validate_non_negative_index("nu_x_true", "(spatial_me ? 0 : dx_me )", (spatial_me ? 0 : dx_me ));
            num_params_r__ += (spatial_me ? 0 : dx_me );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_foundation() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 404;
        if (!(context__.contains_r("alpha_phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_phi");
        pos__ = 0U;
        validate_non_negative_index("alpha_phi", "m", m);
        context__.validate_dims("parameter initialization", "alpha_phi", "vector_d", context__.to_vec(m));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_phi(m);
        size_t alpha_phi_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < alpha_phi_j_1_max__; ++j_1__) {
            alpha_phi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(alpha_phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 405;
        if (!(context__.contains_r("phi_tilde")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi_tilde missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi_tilde");
        pos__ = 0U;
        validate_non_negative_index("phi_tilde", "(type ? n : 0 )", (type ? n : 0 ));
        context__.validate_dims("parameter initialization", "phi_tilde", "vector_d", context__.to_vec((type ? n : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi_tilde((type ? n : 0 ));
        size_t phi_tilde_j_1_max__ = (type ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < phi_tilde_j_1_max__; ++j_1__) {
            phi_tilde(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi_tilde);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi_tilde: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 406;
        if (!(context__.contains_r("spatial_scale")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable spatial_scale missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("spatial_scale");
        pos__ = 0U;
        validate_non_negative_index("spatial_scale", "(type ? 1 : 0 )", (type ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "spatial_scale", "double", context__.to_vec((type ? 1 : 0 )));
        std::vector<double> spatial_scale((type ? 1 : 0 ), double(0));
        size_t spatial_scale_k_0_max__ = (type ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < spatial_scale_k_0_max__; ++k_0__) {
            spatial_scale[k_0__] = vals_r__[pos__++];
        }
        size_t spatial_scale_i_0_max__ = (type ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < spatial_scale_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, spatial_scale[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable spatial_scale: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 407;
        if (!(context__.contains_r("theta_tilde")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_tilde missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_tilde");
        pos__ = 0U;
        validate_non_negative_index("theta_tilde", "(logical_gt(type, 1) ? n : 0 )", (logical_gt(type, 1) ? n : 0 ));
        context__.validate_dims("parameter initialization", "theta_tilde", "vector_d", context__.to_vec((logical_gt(type, 1) ? n : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_tilde((logical_gt(type, 1) ? n : 0 ));
        size_t theta_tilde_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_tilde_j_1_max__; ++j_1__) {
            theta_tilde(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(theta_tilde);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_tilde: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 408;
        if (!(context__.contains_r("theta_scale")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_scale missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_scale");
        pos__ = 0U;
        validate_non_negative_index("theta_scale", "logical_eq(type, 2)", logical_eq(type, 2));
        context__.validate_dims("parameter initialization", "theta_scale", "double", context__.to_vec(logical_eq(type, 2)));
        std::vector<double> theta_scale(logical_eq(type, 2), double(0));
        size_t theta_scale_k_0_max__ = logical_eq(type, 2);
        for (size_t k_0__ = 0; k_0__ < theta_scale_k_0_max__; ++k_0__) {
            theta_scale[k_0__] = vals_r__[pos__++];
        }
        size_t theta_scale_i_0_max__ = logical_eq(type, 2);
        for (size_t i_0__ = 0; i_0__ < theta_scale_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, theta_scale[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_scale: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 409;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "logical_eq(type, 3)", logical_eq(type, 3));
        context__.validate_dims("parameter initialization", "rho", "double", context__.to_vec(logical_eq(type, 3)));
        std::vector<double> rho(logical_eq(type, 3), double(0));
        size_t rho_k_0_max__ = logical_eq(type, 3);
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            rho[k_0__] = vals_r__[pos__++];
        }
        size_t rho_i_0_max__ = logical_eq(type, 3);
        for (size_t i_0__ = 0; i_0__ < rho_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0, 1, rho[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 411;
        if (!(context__.contains_r("aux1_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable aux1_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("aux1_global");
        pos__ = 0U;
        validate_non_negative_index("aux1_global", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "aux1_global", "double", context__.to_vec((dev ? 1 : 0 )));
        std::vector<double> aux1_global((dev ? 1 : 0 ), double(0));
        size_t aux1_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux1_global_k_0_max__; ++k_0__) {
            aux1_global[k_0__] = vals_r__[pos__++];
        }
        size_t aux1_global_i_0_max__ = (dev ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < aux1_global_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, aux1_global[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable aux1_global: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 412;
        if (!(context__.contains_r("aux2_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable aux2_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("aux2_global");
        pos__ = 0U;
        validate_non_negative_index("aux2_global", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "aux2_global", "double", context__.to_vec((dev ? 1 : 0 )));
        std::vector<double> aux2_global((dev ? 1 : 0 ), double(0));
        size_t aux2_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux2_global_k_0_max__; ++k_0__) {
            aux2_global[k_0__] = vals_r__[pos__++];
        }
        size_t aux2_global_i_0_max__ = (dev ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < aux2_global_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, aux2_global[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable aux2_global: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 413;
        if (!(context__.contains_r("aux1_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable aux1_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("aux1_local");
        pos__ = 0U;
        validate_non_negative_index("aux1_local", "dev", dev);
        context__.validate_dims("parameter initialization", "aux1_local", "vector_d", context__.to_vec(dev));
        Eigen::Matrix<double, Eigen::Dynamic, 1> aux1_local(dev);
        size_t aux1_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux1_local_j_1_max__; ++j_1__) {
            aux1_local(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, aux1_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable aux1_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 414;
        if (!(context__.contains_r("aux2_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable aux2_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("aux2_local");
        pos__ = 0U;
        validate_non_negative_index("aux2_local", "dev", dev);
        context__.validate_dims("parameter initialization", "aux2_local", "vector_d", context__.to_vec(dev));
        Eigen::Matrix<double, Eigen::Dynamic, 1> aux2_local(dev);
        size_t aux2_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux2_local_j_1_max__; ++j_1__) {
            aux2_local(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, aux2_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable aux2_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 415;
        if (!(context__.contains_r("caux")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable caux missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("caux");
        pos__ = 0U;
        validate_non_negative_index("caux", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "caux", "double", context__.to_vec((dev ? 1 : 0 )));
        std::vector<double> caux((dev ? 1 : 0 ), double(0));
        size_t caux_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            caux[k_0__] = vals_r__[pos__++];
        }
        size_t caux_i_0_max__ = (dev ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < caux_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, caux[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable caux: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 416;
        if (!(context__.contains_r("z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "dev", dev);
        context__.validate_dims("parameter initialization", "z", "vector_d", context__.to_vec(dev));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z(dev);
        size_t z_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            z(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 418;
        if (!(context__.contains_r("log_lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log_lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log_lambda");
        pos__ = 0U;
        validate_non_negative_index("log_lambda", "((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 )", ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
        context__.validate_dims("parameter initialization", "log_lambda", "vector_d", context__.to_vec(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> log_lambda(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
        size_t log_lambda_j_1_max__ = ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lambda_j_1_max__; ++j_1__) {
            log_lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(log_lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log_lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 419;
        if (!(context__.contains_r("car_scale")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable car_scale missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("car_scale");
        pos__ = 0U;
        validate_non_negative_index("car_scale", "(car ? 1 : 0 )", (car ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "car_scale", "double", context__.to_vec((car ? 1 : 0 )));
        std::vector<double> car_scale((car ? 1 : 0 ), double(0));
        size_t car_scale_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_scale_k_0_max__; ++k_0__) {
            car_scale[k_0__] = vals_r__[pos__++];
        }
        size_t car_scale_i_0_max__ = (car ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < car_scale_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, car_scale[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable car_scale: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 420;
        if (!(context__.contains_r("car_rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable car_rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("car_rho");
        pos__ = 0U;
        validate_non_negative_index("car_rho", "(car ? 1 : 0 )", (car ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "car_rho", "double", context__.to_vec((car ? 1 : 0 )));
        std::vector<double> car_rho((car ? 1 : 0 ), double(0));
        size_t car_rho_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_rho_k_0_max__; ++k_0__) {
            car_rho[k_0__] = vals_r__[pos__++];
        }
        size_t car_rho_i_0_max__ = (car ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < car_rho_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(get_base1(car_rho_lims, 1, "car_rho_lims", 1), get_base1(car_rho_lims, 2, "car_rho_lims", 1), car_rho[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable car_rho: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 423;
        if (!(context__.contains_r("intercept")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable intercept missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("intercept");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "intercept", "double", context__.to_vec());
        double intercept(0);
        intercept = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(intercept);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable intercept: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 424;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "dwx", dwx);
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec(dwx));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(dwx);
        size_t gamma_j_1_max__ = dwx;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 425;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "dx_all", dx_all);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(dx_all));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(dx_all);
        size_t beta_j_1_max__ = dx_all;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 426;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "is_student", is_student);
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec(is_student));
        std::vector<double> nu(is_student, double(0));
        size_t nu_k_0_max__ = is_student;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            nu[k_0__] = vals_r__[pos__++];
        }
        size_t nu_i_0_max__ = is_student;
        for (size_t i_0__ = 0; i_0__ < nu_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, nu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 427;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "has_sigma", has_sigma);
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec(has_sigma));
        std::vector<double> sigma(has_sigma, double(0));
        size_t sigma_k_0_max__ = has_sigma;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = has_sigma;
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 429;
        if (!(context__.contains_r("alpha_re")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_re missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_re");
        pos__ = 0U;
        validate_non_negative_index("alpha_re", "n_ids", n_ids);
        context__.validate_dims("parameter initialization", "alpha_re", "vector_d", context__.to_vec(n_ids));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_re(n_ids);
        size_t alpha_re_j_1_max__ = n_ids;
        for (size_t j_1__ = 0; j_1__ < alpha_re_j_1_max__; ++j_1__) {
            alpha_re(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(alpha_re);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_re: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 430;
        if (!(context__.contains_r("alpha_tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_tau");
        pos__ = 0U;
        validate_non_negative_index("alpha_tau", "has_re", has_re);
        context__.validate_dims("parameter initialization", "alpha_tau", "double", context__.to_vec(has_re));
        std::vector<double> alpha_tau(has_re, double(0));
        size_t alpha_tau_k_0_max__ = has_re;
        for (size_t k_0__ = 0; k_0__ < alpha_tau_k_0_max__; ++k_0__) {
            alpha_tau[k_0__] = vals_r__[pos__++];
        }
        size_t alpha_tau_i_0_max__ = has_re;
        for (size_t i_0__ = 0; i_0__ < alpha_tau_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, alpha_tau[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_tau: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 432;
        if (!(context__.contains_r("x_true")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable x_true missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("x_true");
        pos__ = 0U;
        validate_non_negative_index("x_true", "n", n);
        validate_non_negative_index("x_true", "dx_me", dx_me);
        context__.validate_dims("parameter initialization", "x_true", "vector_d", context__.to_vec(dx_me,n));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > x_true(dx_me, Eigen::Matrix<double, Eigen::Dynamic, 1>(n));
        size_t x_true_j_1_max__ = n;
        size_t x_true_k_0_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < x_true_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < x_true_k_0_max__; ++k_0__) {
                x_true[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t x_true_i_0_max__ = dx_me;
        for (size_t i_0__ = 0; i_0__ < x_true_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(get_base1(bounds, 1, "bounds", 1), get_base1(bounds, 2, "bounds", 1), x_true[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable x_true: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 434;
        if (!(context__.contains_r("mu_x_true")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_x_true missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_x_true");
        pos__ = 0U;
        validate_non_negative_index("mu_x_true", "dx_me", dx_me);
        context__.validate_dims("parameter initialization", "mu_x_true", "vector_d", context__.to_vec(dx_me));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_x_true(dx_me);
        size_t mu_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < mu_x_true_j_1_max__; ++j_1__) {
            mu_x_true(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mu_x_true);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_x_true: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 435;
        if (!(context__.contains_r("sigma_x_true")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_x_true missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_x_true");
        pos__ = 0U;
        validate_non_negative_index("sigma_x_true", "dx_me", dx_me);
        context__.validate_dims("parameter initialization", "sigma_x_true", "vector_d", context__.to_vec(dx_me));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_x_true(dx_me);
        size_t sigma_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < sigma_x_true_j_1_max__; ++j_1__) {
            sigma_x_true(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma_x_true);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_x_true: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 436;
        if (!(context__.contains_r("car_rho_x_true")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable car_rho_x_true missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("car_rho_x_true");
        pos__ = 0U;
        validate_non_negative_index("car_rho_x_true", "(spatial_me ? dx_me : 0 )", (spatial_me ? dx_me : 0 ));
        context__.validate_dims("parameter initialization", "car_rho_x_true", "vector_d", context__.to_vec((spatial_me ? dx_me : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> car_rho_x_true((spatial_me ? dx_me : 0 ));
        size_t car_rho_x_true_j_1_max__ = (spatial_me ? dx_me : 0 );
        for (size_t j_1__ = 0; j_1__ < car_rho_x_true_j_1_max__; ++j_1__) {
            car_rho_x_true(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(get_base1(prior_rhox_true, 1, "prior_rhox_true", 1), get_base1(prior_rhox_true, 2, "prior_rhox_true", 1), car_rho_x_true);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable car_rho_x_true: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 437;
        if (!(context__.contains_r("nu_x_true")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu_x_true missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu_x_true");
        pos__ = 0U;
        validate_non_negative_index("nu_x_true", "(spatial_me ? 0 : dx_me )", (spatial_me ? 0 : dx_me ));
        context__.validate_dims("parameter initialization", "nu_x_true", "vector_d", context__.to_vec((spatial_me ? 0 : dx_me )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> nu_x_true((spatial_me ? 0 : dx_me ));
        size_t nu_x_true_j_1_max__ = (spatial_me ? 0 : dx_me );
        for (size_t j_1__ = 0; j_1__ < nu_x_true_j_1_max__; ++j_1__) {
            nu_x_true(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, nu_x_true);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu_x_true: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 404;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_phi;
            (void) alpha_phi;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_phi = in__.vector_constrain(m, lp__);
            else
                alpha_phi = in__.vector_constrain(m);
            current_statement_begin__ = 405;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi_tilde;
            (void) phi_tilde;  // dummy to suppress unused var warning
            if (jacobian__)
                phi_tilde = in__.vector_constrain((type ? n : 0 ), lp__);
            else
                phi_tilde = in__.vector_constrain((type ? n : 0 ));
            current_statement_begin__ = 406;
            std::vector<local_scalar_t__> spatial_scale;
            size_t spatial_scale_d_0_max__ = (type ? 1 : 0 );
            spatial_scale.reserve(spatial_scale_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < spatial_scale_d_0_max__; ++d_0__) {
                if (jacobian__)
                    spatial_scale.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    spatial_scale.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 407;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_tilde;
            (void) theta_tilde;  // dummy to suppress unused var warning
            if (jacobian__)
                theta_tilde = in__.vector_constrain((logical_gt(type, 1) ? n : 0 ), lp__);
            else
                theta_tilde = in__.vector_constrain((logical_gt(type, 1) ? n : 0 ));
            current_statement_begin__ = 408;
            std::vector<local_scalar_t__> theta_scale;
            size_t theta_scale_d_0_max__ = logical_eq(type, 2);
            theta_scale.reserve(theta_scale_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_scale_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta_scale.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    theta_scale.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 409;
            std::vector<local_scalar_t__> rho;
            size_t rho_d_0_max__ = logical_eq(type, 3);
            rho.reserve(rho_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_lub_constrain(0, 1, lp__));
                else
                    rho.push_back(in__.scalar_lub_constrain(0, 1));
            }
            current_statement_begin__ = 411;
            std::vector<local_scalar_t__> aux1_global;
            size_t aux1_global_d_0_max__ = (dev ? 1 : 0 );
            aux1_global.reserve(aux1_global_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < aux1_global_d_0_max__; ++d_0__) {
                if (jacobian__)
                    aux1_global.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    aux1_global.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 412;
            std::vector<local_scalar_t__> aux2_global;
            size_t aux2_global_d_0_max__ = (dev ? 1 : 0 );
            aux2_global.reserve(aux2_global_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < aux2_global_d_0_max__; ++d_0__) {
                if (jacobian__)
                    aux2_global.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    aux2_global.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 413;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux1_local;
            (void) aux1_local;  // dummy to suppress unused var warning
            if (jacobian__)
                aux1_local = in__.vector_lb_constrain(0, dev, lp__);
            else
                aux1_local = in__.vector_lb_constrain(0, dev);
            current_statement_begin__ = 414;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux2_local;
            (void) aux2_local;  // dummy to suppress unused var warning
            if (jacobian__)
                aux2_local = in__.vector_lb_constrain(0, dev, lp__);
            else
                aux2_local = in__.vector_lb_constrain(0, dev);
            current_statement_begin__ = 415;
            std::vector<local_scalar_t__> caux;
            size_t caux_d_0_max__ = (dev ? 1 : 0 );
            caux.reserve(caux_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < caux_d_0_max__; ++d_0__) {
                if (jacobian__)
                    caux.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    caux.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 416;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.vector_constrain(dev, lp__);
            else
                z = in__.vector_constrain(dev);
            current_statement_begin__ = 418;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lambda;
            (void) log_lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                log_lambda = in__.vector_constrain(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ), lp__);
            else
                log_lambda = in__.vector_constrain(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
            current_statement_begin__ = 419;
            std::vector<local_scalar_t__> car_scale;
            size_t car_scale_d_0_max__ = (car ? 1 : 0 );
            car_scale.reserve(car_scale_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < car_scale_d_0_max__; ++d_0__) {
                if (jacobian__)
                    car_scale.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    car_scale.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 420;
            std::vector<local_scalar_t__> car_rho;
            size_t car_rho_d_0_max__ = (car ? 1 : 0 );
            car_rho.reserve(car_rho_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < car_rho_d_0_max__; ++d_0__) {
                if (jacobian__)
                    car_rho.push_back(in__.scalar_lub_constrain(get_base1(car_rho_lims, 1, "car_rho_lims", 1), get_base1(car_rho_lims, 2, "car_rho_lims", 1), lp__));
                else
                    car_rho.push_back(in__.scalar_lub_constrain(get_base1(car_rho_lims, 1, "car_rho_lims", 1), get_base1(car_rho_lims, 2, "car_rho_lims", 1)));
            }
            current_statement_begin__ = 423;
            local_scalar_t__ intercept;
            (void) intercept;  // dummy to suppress unused var warning
            if (jacobian__)
                intercept = in__.scalar_constrain(lp__);
            else
                intercept = in__.scalar_constrain();
            current_statement_begin__ = 424;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_constrain(dwx, lp__);
            else
                gamma = in__.vector_constrain(dwx);
            current_statement_begin__ = 425;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(dx_all, lp__);
            else
                beta = in__.vector_constrain(dx_all);
            current_statement_begin__ = 426;
            std::vector<local_scalar_t__> nu;
            size_t nu_d_0_max__ = is_student;
            nu.reserve(nu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < nu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    nu.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    nu.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 427;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = has_sigma;
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 429;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_re;
            (void) alpha_re;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_re = in__.vector_constrain(n_ids, lp__);
            else
                alpha_re = in__.vector_constrain(n_ids);
            current_statement_begin__ = 430;
            std::vector<local_scalar_t__> alpha_tau;
            size_t alpha_tau_d_0_max__ = has_re;
            alpha_tau.reserve(alpha_tau_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_tau_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha_tau.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    alpha_tau.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 432;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > x_true;
            size_t x_true_d_0_max__ = dx_me;
            x_true.reserve(x_true_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < x_true_d_0_max__; ++d_0__) {
                if (jacobian__)
                    x_true.push_back(in__.vector_lub_constrain(get_base1(bounds, 1, "bounds", 1), get_base1(bounds, 2, "bounds", 1), n, lp__));
                else
                    x_true.push_back(in__.vector_lub_constrain(get_base1(bounds, 1, "bounds", 1), get_base1(bounds, 2, "bounds", 1), n));
            }
            current_statement_begin__ = 434;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_x_true;
            (void) mu_x_true;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_x_true = in__.vector_constrain(dx_me, lp__);
            else
                mu_x_true = in__.vector_constrain(dx_me);
            current_statement_begin__ = 435;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_x_true;
            (void) sigma_x_true;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_x_true = in__.vector_lb_constrain(0, dx_me, lp__);
            else
                sigma_x_true = in__.vector_lb_constrain(0, dx_me);
            current_statement_begin__ = 436;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> car_rho_x_true;
            (void) car_rho_x_true;  // dummy to suppress unused var warning
            if (jacobian__)
                car_rho_x_true = in__.vector_lub_constrain(get_base1(prior_rhox_true, 1, "prior_rhox_true", 1), get_base1(prior_rhox_true, 2, "prior_rhox_true", 1), (spatial_me ? dx_me : 0 ), lp__);
            else
                car_rho_x_true = in__.vector_lub_constrain(get_base1(prior_rhox_true, 1, "prior_rhox_true", 1), get_base1(prior_rhox_true, 2, "prior_rhox_true", 1), (spatial_me ? dx_me : 0 ));
            current_statement_begin__ = 437;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nu_x_true;
            (void) nu_x_true;  // dummy to suppress unused var warning
            if (jacobian__)
                nu_x_true = in__.vector_lb_constrain(0, (spatial_me ? 0 : dx_me ), lp__);
            else
                nu_x_true = in__.vector_lb_constrain(0, (spatial_me ? 0 : dx_me ));
            // transformed parameters
            current_statement_begin__ = 443;
            validate_non_negative_index("beta_ev", "dev", dev);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_ev(dev);
            stan::math::initialize(beta_ev, DUMMY_VAR__);
            stan::math::fill(beta_ev, DUMMY_VAR__);
            current_statement_begin__ = 444;
            validate_non_negative_index("esf", "(dev ? n : 0 )", (dev ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> esf((dev ? n : 0 ));
            stan::math::initialize(esf, DUMMY_VAR__);
            stan::math::fill(esf, DUMMY_VAR__);
            current_statement_begin__ = 445;
            validate_non_negative_index("error_scale", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
            std::vector<local_scalar_t__> error_scale((dev ? 1 : 0 ), local_scalar_t__(0));
            stan::math::initialize(error_scale, DUMMY_VAR__);
            stan::math::fill(error_scale, DUMMY_VAR__);
            current_statement_begin__ = 447;
            validate_non_negative_index("phi", "(type ? n : 0 )", (type ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi((type ? n : 0 ));
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 448;
            validate_non_negative_index("theta", "(logical_gt(type, 1) ? n : 0 )", (logical_gt(type, 1) ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta((logical_gt(type, 1) ? n : 0 ));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 450;
            validate_non_negative_index("log_lambda_mu", "(car ? n : 0 )", (car ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lambda_mu((car ? n : 0 ));
            stan::math::initialize(log_lambda_mu, DUMMY_VAR__);
            stan::math::fill(log_lambda_mu, DUMMY_VAR__);
            current_statement_begin__ = 452;
            validate_non_negative_index("x_all", "n", n);
            validate_non_negative_index("x_all", "dx_all", dx_all);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> x_all(n, dx_all);
            stan::math::initialize(x_all, DUMMY_VAR__);
            stan::math::fill(x_all, DUMMY_VAR__);
            current_statement_begin__ = 453;
            validate_non_negative_index("fitted", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> fitted(n);
            stan::math::initialize(fitted, DUMMY_VAR__);
            stan::math::fill(fitted, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 454;
            if (as_bool(dx_obs)) {
                current_statement_begin__ = 454;
                stan::model::assign(x_all, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(x_obs_idx), stan::model::nil_index_list())), 
                            x_obs, 
                            "assigning variable x_all");
            }
            current_statement_begin__ = 455;
            if (as_bool(dx_me)) {
                current_statement_begin__ = 455;
                for (int j = 1; j <= dx_me; ++j) {
                    current_statement_begin__ = 455;
                    stan::model::assign(x_all, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(x_me_idx, j, "x_me_idx", 1)), stan::model::nil_index_list())), 
                                get_base1(x_true, j, "x_true", 1), 
                                "assigning variable x_all");
                }
            }
            current_statement_begin__ = 456;
            if (as_bool(center_x)) {
                current_statement_begin__ = 456;
                for (int j = 1; j <= dx_all; ++j) {
                    current_statement_begin__ = 456;
                    stan::model::assign(x_all, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                stan::model::deep_copy(subtract(stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "x_all"), mean(stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "x_all")))), 
                                "assigning variable x_all");
                }
            }
            current_statement_begin__ = 457;
            if (as_bool(logical_negation(car))) {
                current_statement_begin__ = 457;
                stan::math::assign(fitted, add(offset, intercept));
            }
            current_statement_begin__ = 461;
            if (as_bool(logical_eq(type, 1))) {
                current_statement_begin__ = 462;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), 1, inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 463;
                if (as_bool(m)) {
                    current_statement_begin__ = 463;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 464;
                stan::math::assign(fitted, add(fitted, phi));
            }
            current_statement_begin__ = 466;
            if (as_bool(logical_eq(type, 2))) {
                current_statement_begin__ = 467;
                stan::math::assign(theta, multiply(theta_tilde, get_base1(theta_scale, 1, "theta_scale", 1)));
                current_statement_begin__ = 468;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), 1, inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 469;
                if (as_bool(m)) {
                    current_statement_begin__ = 469;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 470;
                stan::math::assign(fitted, add(fitted, convolve_bym(phi, theta, n, k, group_size, group_idx, pstream__)));
            }
            current_statement_begin__ = 472;
            if (as_bool(logical_eq(type, 3))) {
                current_statement_begin__ = 473;
                stan::math::assign(theta, multiply((get_base1(spatial_scale, 1, "spatial_scale", 1) * stan::math::sqrt((1 - get_base1(rho, 1, "rho", 1)))), theta_tilde));
                current_statement_begin__ = 474;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), get_base1(rho, 1, "rho", 1), inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 475;
                if (as_bool(m)) {
                    current_statement_begin__ = 475;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 476;
                stan::math::assign(fitted, add(fitted, convolve_bym2(phi_tilde, theta_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), n, k, group_size, group_idx, get_base1(rho, 1, "rho", 1), inv_sqrt_scale_factor, pstream__)));
            }
            current_statement_begin__ = 478;
            if (as_bool(dev)) {
                current_statement_begin__ = 479;
                if (as_bool(has_sigma)) {
                    current_statement_begin__ = 480;
                    stan::model::assign(error_scale, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(sigma, 1, "sigma", 1), 
                                "assigning variable error_scale");
                } else {
                    current_statement_begin__ = 482;
                    stan::model::assign(error_scale, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable error_scale");
                }
                current_statement_begin__ = 484;
                stan::math::assign(beta_ev, rhs_prior(dev, z, get_base1(aux1_global, 1, "aux1_global", 1), get_base1(aux2_global, 1, "aux2_global", 1), aux1_local, aux2_local, get_base1(caux, 1, "caux", 1), global_scale, slab_scale, get_base1(error_scale, 1, "error_scale", 1), pstream__));
                current_statement_begin__ = 485;
                stan::math::assign(esf, multiply(EV, beta_ev));
                current_statement_begin__ = 486;
                stan::math::assign(fitted, add(fitted, esf));
            }
            current_statement_begin__ = 488;
            if (as_bool(car)) {
                current_statement_begin__ = 489;
                stan::math::assign(log_lambda_mu, rep_vector(intercept, n));
                current_statement_begin__ = 490;
                if (as_bool(has_re)) {
                    current_statement_begin__ = 491;
                    for (int i = 1; i <= n; ++i) {
                        current_statement_begin__ = 492;
                        stan::model::assign(log_lambda_mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(log_lambda_mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lambda_mu") + get_base1(alpha_re, get_base1(id, i, "id", 1), "alpha_re", 1)), 
                                    "assigning variable log_lambda_mu");
                    }
                }
                current_statement_begin__ = 495;
                if (as_bool(dwx)) {
                    current_statement_begin__ = 496;
                    for (int i = 1; i <= dwx; ++i) {
                        current_statement_begin__ = 496;
                        stan::math::assign(log_lambda_mu, add(log_lambda_mu, multiply(csr_matrix_times_vector(n, n, W_w, W_v, W_u, stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(wx_idx, i, "wx_idx", 1)), stan::model::nil_index_list())), "x_all")), get_base1(gamma, i, "gamma", 1))));
                    }
                }
                current_statement_begin__ = 498;
                if (as_bool(dx_all)) {
                    current_statement_begin__ = 498;
                    stan::math::assign(log_lambda_mu, add(log_lambda_mu, multiply(x_all, beta)));
                }
                current_statement_begin__ = 499;
                if (as_bool(is_auto_gaussian)) {
                    current_statement_begin__ = 500;
                    stan::math::assign(fitted, add(offset, log_lambda_mu));
                } else {
                    current_statement_begin__ = 502;
                    stan::math::assign(fitted, add(offset, log_lambda));
                }
            }
            current_statement_begin__ = 505;
            if (as_bool(logical_negation(car))) {
                current_statement_begin__ = 506;
                if (as_bool(has_re)) {
                    current_statement_begin__ = 507;
                    for (int i = 1; i <= n; ++i) {
                        current_statement_begin__ = 508;
                        stan::model::assign(fitted, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(fitted, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "fitted") + get_base1(alpha_re, get_base1(id, i, "id", 1), "alpha_re", 1)), 
                                    "assigning variable fitted");
                    }
                }
                current_statement_begin__ = 511;
                if (as_bool(dwx)) {
                    current_statement_begin__ = 512;
                    for (int i = 1; i <= dwx; ++i) {
                        current_statement_begin__ = 512;
                        stan::math::assign(fitted, add(fitted, multiply(csr_matrix_times_vector(n, n, W_w, W_v, W_u, stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(wx_idx, i, "wx_idx", 1)), stan::model::nil_index_list())), "x_all")), get_base1(gamma, i, "gamma", 1))));
                    }
                }
                current_statement_begin__ = 514;
                if (as_bool(dx_all)) {
                    current_statement_begin__ = 514;
                    stan::math::assign(fitted, add(fitted, multiply(x_all, beta)));
                }
            }
            current_statement_begin__ = 516;
            if (as_bool(is_binomial)) {
                current_statement_begin__ = 516;
                stan::math::assign(fitted, inv_logit(fitted));
            }
            current_statement_begin__ = 517;
            if (as_bool(is_poisson)) {
                current_statement_begin__ = 517;
                stan::math::assign(fitted, stan::math::exp(fitted));
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 443;
            size_t beta_ev_j_1_max__ = dev;
            for (size_t j_1__ = 0; j_1__ < beta_ev_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_ev(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_ev" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_ev: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 444;
            size_t esf_j_1_max__ = (dev ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < esf_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(esf(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: esf" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable esf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 445;
            size_t error_scale_k_0_max__ = (dev ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < error_scale_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(error_scale[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: error_scale" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable error_scale: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 447;
            size_t phi_j_1_max__ = (type ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 448;
            size_t theta_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 450;
            size_t log_lambda_mu_j_1_max__ = (car ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < log_lambda_mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_lambda_mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_lambda_mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lambda_mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 452;
            size_t x_all_j_1_max__ = n;
            size_t x_all_j_2_max__ = dx_all;
            for (size_t j_1__ = 0; j_1__ < x_all_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < x_all_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(x_all(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: x_all" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable x_all: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 453;
            size_t fitted_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fitted_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(fitted(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: fitted" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable fitted: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            {
            current_statement_begin__ = 522;
            validate_non_negative_index("x_true_transform", "n", n);
            validate_non_negative_index("x_true_transform", "dx_me", dx_me);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > x_true_transform(dx_me, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(n));
            stan::math::initialize(x_true_transform, DUMMY_VAR__);
            stan::math::fill(x_true_transform, DUMMY_VAR__);
            current_statement_begin__ = 523;
            stan::math::assign(x_true_transform, x_true);
            current_statement_begin__ = 524;
            lp_accum__.add(normal_log(intercept, get_base1(prior_alpha, 1, "prior_alpha", 1), get_base1(prior_alpha, 2, "prior_alpha", 1)));
            current_statement_begin__ = 525;
            if (as_bool(dx_all)) {
                current_statement_begin__ = 525;
                lp_accum__.add(normal_log(append_row(gamma, beta), prior_beta_location, prior_beta_scale));
            }
            current_statement_begin__ = 526;
            if (as_bool(has_sigma)) {
                current_statement_begin__ = 526;
                lp_accum__.add(student_t_log(sigma, get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
            }
            current_statement_begin__ = 527;
            if (as_bool(is_student)) {
                current_statement_begin__ = 527;
                lp_accum__.add(gamma_log(get_base1(nu, 1, "nu", 1), get_base1(prior_t_nu, 1, "prior_t_nu", 1), get_base1(prior_t_nu, 2, "prior_t_nu", 1)));
            }
            current_statement_begin__ = 529;
            if (as_bool(dx_me)) {
                current_statement_begin__ = 530;
                if (as_bool(spatial_me)) {
                    current_statement_begin__ = 531;
                    for (int j = 1; j <= dx_me; ++j) {
                        current_statement_begin__ = 532;
                        lp_accum__.add(normal_log(get_base1(x_me, j, "x_me", 1), get_base1(x_true, j, "x_true", 1), get_base1(sigma_me, j, "sigma_me", 1)));
                        current_statement_begin__ = 533;
                        if (as_bool(logical_gt(get_base1(use_logit, j, "use_logit", 1), 0))) {
                            current_statement_begin__ = 533;
                            stan::model::assign(x_true_transform, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                        logit(get_base1(x_true, j, "x_true", 1)), 
                                        "assigning variable x_true_transform");
                        }
                        current_statement_begin__ = 534;
                        lp_accum__.add(auto_normal_lpdf(get_base1(x_true_transform, j, "x_true_transform", 1), rep_vector(get_base1(mu_x_true, j, "mu_x_true", 1), n), get_base1(sigma_x_true, j, "sigma_x_true", 1), get_base1(car_rho_x_true, j, "car_rho_x_true", 1), Ax_w, Ax_v, Ax_u, Cidx, Delta_inv, log_det_Delta_inv, lambda, n, WCAR, pstream__));
                    }
                } else {
                    current_statement_begin__ = 544;
                    for (int j = 1; j <= dx_me; ++j) {
                        current_statement_begin__ = 545;
                        lp_accum__.add(normal_log(get_base1(x_me, j, "x_me", 1), get_base1(x_true, j, "x_true", 1), get_base1(sigma_me, j, "sigma_me", 1)));
                        current_statement_begin__ = 546;
                        if (as_bool(logical_gt(get_base1(use_logit, j, "use_logit", 1), 0))) {
                            current_statement_begin__ = 546;
                            stan::model::assign(x_true_transform, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                        logit(get_base1(x_true, j, "x_true", 1)), 
                                        "assigning variable x_true_transform");
                        }
                        current_statement_begin__ = 547;
                        lp_accum__.add(student_t_log(get_base1(x_true_transform, j, "x_true_transform", 1), get_base1(nu_x_true, j, "nu_x_true", 1), get_base1(mu_x_true, j, "mu_x_true", 1), get_base1(sigma_x_true, j, "sigma_x_true", 1)));
                        current_statement_begin__ = 548;
                        lp_accum__.add(gamma_log(get_base1(nu_x_true, j, "nu_x_true", 1), get_base1(prior_nux_true_alpha, j, "prior_nux_true_alpha", 1), get_base1(prior_nux_true_beta, j, "prior_nux_true_beta", 1)));
                    }
                }
                current_statement_begin__ = 551;
                lp_accum__.add(normal_log(mu_x_true, prior_mux_true_location, prior_mux_true_scale));
                current_statement_begin__ = 552;
                lp_accum__.add(student_t_log(sigma_x_true, prior_sigmax_true_df, prior_sigmax_true_location, prior_sigmax_true_scale));
            }
            current_statement_begin__ = 555;
            if (as_bool(has_re)) {
                current_statement_begin__ = 556;
                lp_accum__.add(normal_log(alpha_re, 0, get_base1(alpha_tau, has_re, "alpha_tau", 1)));
                current_statement_begin__ = 557;
                lp_accum__.add(student_t_log(get_base1(alpha_tau, has_re, "alpha_tau", 1), get_base1(prior_alpha_tau, 1, "prior_alpha_tau", 1), get_base1(prior_alpha_tau, 2, "prior_alpha_tau", 1), get_base1(prior_alpha_tau, 3, "prior_alpha_tau", 1)));
            }
            current_statement_begin__ = 560;
            if (as_bool(logical_negation(prior_only))) {
                current_statement_begin__ = 561;
                if (as_bool(is_student)) {
                    current_statement_begin__ = 561;
                    lp_accum__.add(student_t_log(y, get_base1(nu, 1, "nu", 1), fitted, get_base1(sigma, has_sigma, "sigma", 1)));
                }
                current_statement_begin__ = 562;
                if (as_bool(is_gaussian)) {
                    current_statement_begin__ = 562;
                    lp_accum__.add(normal_log(y, fitted, get_base1(sigma, has_sigma, "sigma", 1)));
                }
                current_statement_begin__ = 563;
                if (as_bool(is_poisson)) {
                    current_statement_begin__ = 564;
                    lp_accum__.add(poisson_log(stan::model::rvalue(y_int, stan::model::cons_list(stan::model::index_multi(y_obs_idx), stan::model::nil_index_list()), "y_int"), stan::model::rvalue(fitted, stan::model::cons_list(stan::model::index_multi(y_obs_idx), stan::model::nil_index_list()), "fitted")));
                    current_statement_begin__ = 565;
                    if (as_bool(logical_gt(censor_point, 0))) {
                        current_statement_begin__ = 565;
                        lp_accum__.add(poisson_cdf_log(censor_point, stan::model::rvalue(fitted, stan::model::cons_list(stan::model::index_multi(y_mis_idx), stan::model::nil_index_list()), "fitted")));
                    }
                }
                current_statement_begin__ = 567;
                if (as_bool(is_binomial)) {
                    current_statement_begin__ = 567;
                    lp_accum__.add(binomial_log(y_int, trials, fitted));
                }
            }
            current_statement_begin__ = 571;
            if (as_bool(type)) {
                current_statement_begin__ = 572;
                if (as_bool(has_theta)) {
                    current_statement_begin__ = 573;
                    lp_accum__.add(std_normal_log(theta_tilde));
                    current_statement_begin__ = 574;
                    if (as_bool(logical_eq(type, 2))) {
                        current_statement_begin__ = 574;
                        lp_accum__.add(std_normal_log(get_base1(theta_scale, 1, "theta_scale", 1)));
                    }
                }
                current_statement_begin__ = 577;
                lp_accum__.add(std_normal_log(get_base1(spatial_scale, 1, "spatial_scale", 1)));
                current_statement_begin__ = 578;
                lp_accum__.add(icar_normal_lpdf<propto__>(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), node1, node2, k, group_size, group_idx, has_theta, pstream__));
                current_statement_begin__ = 579;
                if (as_bool(m)) {
                    current_statement_begin__ = 579;
                    lp_accum__.add(normal_log(alpha_phi, 0, get_base1(prior_alpha, 2, "prior_alpha", 1)));
                }
            }
            current_statement_begin__ = 582;
            if (as_bool(dev)) {
                current_statement_begin__ = 583;
                lp_accum__.add(std_normal_log(z));
                current_statement_begin__ = 584;
                lp_accum__.add(std_normal_log(aux1_local));
                current_statement_begin__ = 585;
                lp_accum__.add(inv_gamma_log(aux2_local, 0.5, 0.5));
                current_statement_begin__ = 586;
                lp_accum__.add(std_normal_log(get_base1(aux1_global, 1, "aux1_global", 1)));
                current_statement_begin__ = 587;
                lp_accum__.add(inv_gamma_log(get_base1(aux2_global, 1, "aux2_global", 1), 0.5, 0.5));
                current_statement_begin__ = 588;
                lp_accum__.add(inv_gamma_log(get_base1(caux, 1, "caux", 1), (0.5 * slab_df), (0.5 * slab_df)));
            }
            current_statement_begin__ = 591;
            if (as_bool(car)) {
                current_statement_begin__ = 592;
                lp_accum__.add(student_t_log(get_base1(car_scale, 1, "car_scale", 1), get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
                current_statement_begin__ = 593;
                if (as_bool((is_auto_gaussian * logical_negation(prior_only)))) {
                    current_statement_begin__ = 594;
                    lp_accum__.add(auto_normal_lpdf(y, fitted, get_base1(car_scale, 1, "car_scale", 1), get_base1(car_rho, 1, "car_rho", 1), Ax_w, Ax_v, Ax_u, Cidx, Delta_inv, log_det_Delta_inv, lambda, n, WCAR, pstream__));
                }
                current_statement_begin__ = 601;
                if (as_bool(logical_negation(is_auto_gaussian))) {
                    current_statement_begin__ = 602;
                    lp_accum__.add(auto_normal_lpdf(log_lambda, log_lambda_mu, get_base1(car_scale, 1, "car_scale", 1), get_base1(car_rho, 1, "car_rho", 1), Ax_w, Ax_v, Ax_u, Cidx, Delta_inv, log_det_Delta_inv, lambda, n, WCAR, pstream__));
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha_phi");
        names__.push_back("phi_tilde");
        names__.push_back("spatial_scale");
        names__.push_back("theta_tilde");
        names__.push_back("theta_scale");
        names__.push_back("rho");
        names__.push_back("aux1_global");
        names__.push_back("aux2_global");
        names__.push_back("aux1_local");
        names__.push_back("aux2_local");
        names__.push_back("caux");
        names__.push_back("z");
        names__.push_back("log_lambda");
        names__.push_back("car_scale");
        names__.push_back("car_rho");
        names__.push_back("intercept");
        names__.push_back("gamma");
        names__.push_back("beta");
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("alpha_re");
        names__.push_back("alpha_tau");
        names__.push_back("x_true");
        names__.push_back("mu_x_true");
        names__.push_back("sigma_x_true");
        names__.push_back("car_rho_x_true");
        names__.push_back("nu_x_true");
        names__.push_back("beta_ev");
        names__.push_back("esf");
        names__.push_back("error_scale");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("log_lambda_mu");
        names__.push_back("x_all");
        names__.push_back("fitted");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((type ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((type ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(type, 1) ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(type, 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(type, 3));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((dev ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((dev ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dev);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dev);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((dev ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dev);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((car ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((car ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dwx);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dx_all);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_student);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_sigma);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_ids);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(has_re);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dx_me);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dx_me);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dx_me);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((spatial_me ? dx_me : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((spatial_me ? 0 : dx_me ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(dev);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((dev ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((dev ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((type ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(type, 1) ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((car ? n : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back(dx_all);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((is_auto_gaussian ? 1 : n ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_foundation_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_phi = in__.vector_constrain(m);
        size_t alpha_phi_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < alpha_phi_j_1_max__; ++j_1__) {
            vars__.push_back(alpha_phi(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi_tilde = in__.vector_constrain((type ? n : 0 ));
        size_t phi_tilde_j_1_max__ = (type ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < phi_tilde_j_1_max__; ++j_1__) {
            vars__.push_back(phi_tilde(j_1__));
        }
        std::vector<double> spatial_scale;
        size_t spatial_scale_d_0_max__ = (type ? 1 : 0 );
        spatial_scale.reserve(spatial_scale_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < spatial_scale_d_0_max__; ++d_0__) {
            spatial_scale.push_back(in__.scalar_lb_constrain(0));
        }
        size_t spatial_scale_k_0_max__ = (type ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < spatial_scale_k_0_max__; ++k_0__) {
            vars__.push_back(spatial_scale[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_tilde = in__.vector_constrain((logical_gt(type, 1) ? n : 0 ));
        size_t theta_tilde_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_tilde_j_1_max__; ++j_1__) {
            vars__.push_back(theta_tilde(j_1__));
        }
        std::vector<double> theta_scale;
        size_t theta_scale_d_0_max__ = logical_eq(type, 2);
        theta_scale.reserve(theta_scale_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_scale_d_0_max__; ++d_0__) {
            theta_scale.push_back(in__.scalar_lb_constrain(0));
        }
        size_t theta_scale_k_0_max__ = logical_eq(type, 2);
        for (size_t k_0__ = 0; k_0__ < theta_scale_k_0_max__; ++k_0__) {
            vars__.push_back(theta_scale[k_0__]);
        }
        std::vector<double> rho;
        size_t rho_d_0_max__ = logical_eq(type, 3);
        rho.reserve(rho_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
            rho.push_back(in__.scalar_lub_constrain(0, 1));
        }
        size_t rho_k_0_max__ = logical_eq(type, 3);
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        std::vector<double> aux1_global;
        size_t aux1_global_d_0_max__ = (dev ? 1 : 0 );
        aux1_global.reserve(aux1_global_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < aux1_global_d_0_max__; ++d_0__) {
            aux1_global.push_back(in__.scalar_lb_constrain(0));
        }
        size_t aux1_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux1_global_k_0_max__; ++k_0__) {
            vars__.push_back(aux1_global[k_0__]);
        }
        std::vector<double> aux2_global;
        size_t aux2_global_d_0_max__ = (dev ? 1 : 0 );
        aux2_global.reserve(aux2_global_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < aux2_global_d_0_max__; ++d_0__) {
            aux2_global.push_back(in__.scalar_lb_constrain(0));
        }
        size_t aux2_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux2_global_k_0_max__; ++k_0__) {
            vars__.push_back(aux2_global[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> aux1_local = in__.vector_lb_constrain(0, dev);
        size_t aux1_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux1_local_j_1_max__; ++j_1__) {
            vars__.push_back(aux1_local(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> aux2_local = in__.vector_lb_constrain(0, dev);
        size_t aux2_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux2_local_j_1_max__; ++j_1__) {
            vars__.push_back(aux2_local(j_1__));
        }
        std::vector<double> caux;
        size_t caux_d_0_max__ = (dev ? 1 : 0 );
        caux.reserve(caux_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < caux_d_0_max__; ++d_0__) {
            caux.push_back(in__.scalar_lb_constrain(0));
        }
        size_t caux_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            vars__.push_back(caux[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z = in__.vector_constrain(dev);
        size_t z_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            vars__.push_back(z(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> log_lambda = in__.vector_constrain(((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 ));
        size_t log_lambda_j_1_max__ = ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lambda_j_1_max__; ++j_1__) {
            vars__.push_back(log_lambda(j_1__));
        }
        std::vector<double> car_scale;
        size_t car_scale_d_0_max__ = (car ? 1 : 0 );
        car_scale.reserve(car_scale_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < car_scale_d_0_max__; ++d_0__) {
            car_scale.push_back(in__.scalar_lb_constrain(0));
        }
        size_t car_scale_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_scale_k_0_max__; ++k_0__) {
            vars__.push_back(car_scale[k_0__]);
        }
        std::vector<double> car_rho;
        size_t car_rho_d_0_max__ = (car ? 1 : 0 );
        car_rho.reserve(car_rho_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < car_rho_d_0_max__; ++d_0__) {
            car_rho.push_back(in__.scalar_lub_constrain(get_base1(car_rho_lims, 1, "car_rho_lims", 1), get_base1(car_rho_lims, 2, "car_rho_lims", 1)));
        }
        size_t car_rho_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_rho_k_0_max__; ++k_0__) {
            vars__.push_back(car_rho[k_0__]);
        }
        double intercept = in__.scalar_constrain();
        vars__.push_back(intercept);
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_constrain(dwx);
        size_t gamma_j_1_max__ = dwx;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(dx_all);
        size_t beta_j_1_max__ = dx_all;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        std::vector<double> nu;
        size_t nu_d_0_max__ = is_student;
        nu.reserve(nu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < nu_d_0_max__; ++d_0__) {
            nu.push_back(in__.scalar_lb_constrain(0));
        }
        size_t nu_k_0_max__ = is_student;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            vars__.push_back(nu[k_0__]);
        }
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = has_sigma;
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_0_max__ = has_sigma;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_re = in__.vector_constrain(n_ids);
        size_t alpha_re_j_1_max__ = n_ids;
        for (size_t j_1__ = 0; j_1__ < alpha_re_j_1_max__; ++j_1__) {
            vars__.push_back(alpha_re(j_1__));
        }
        std::vector<double> alpha_tau;
        size_t alpha_tau_d_0_max__ = has_re;
        alpha_tau.reserve(alpha_tau_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_tau_d_0_max__; ++d_0__) {
            alpha_tau.push_back(in__.scalar_lb_constrain(0));
        }
        size_t alpha_tau_k_0_max__ = has_re;
        for (size_t k_0__ = 0; k_0__ < alpha_tau_k_0_max__; ++k_0__) {
            vars__.push_back(alpha_tau[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > x_true;
        size_t x_true_d_0_max__ = dx_me;
        x_true.reserve(x_true_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < x_true_d_0_max__; ++d_0__) {
            x_true.push_back(in__.vector_lub_constrain(get_base1(bounds, 1, "bounds", 1), get_base1(bounds, 2, "bounds", 1), n));
        }
        size_t x_true_j_1_max__ = n;
        size_t x_true_k_0_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < x_true_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < x_true_k_0_max__; ++k_0__) {
                vars__.push_back(x_true[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_x_true = in__.vector_constrain(dx_me);
        size_t mu_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < mu_x_true_j_1_max__; ++j_1__) {
            vars__.push_back(mu_x_true(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_x_true = in__.vector_lb_constrain(0, dx_me);
        size_t sigma_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < sigma_x_true_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_x_true(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> car_rho_x_true = in__.vector_lub_constrain(get_base1(prior_rhox_true, 1, "prior_rhox_true", 1), get_base1(prior_rhox_true, 2, "prior_rhox_true", 1), (spatial_me ? dx_me : 0 ));
        size_t car_rho_x_true_j_1_max__ = (spatial_me ? dx_me : 0 );
        for (size_t j_1__ = 0; j_1__ < car_rho_x_true_j_1_max__; ++j_1__) {
            vars__.push_back(car_rho_x_true(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> nu_x_true = in__.vector_lb_constrain(0, (spatial_me ? 0 : dx_me ));
        size_t nu_x_true_j_1_max__ = (spatial_me ? 0 : dx_me );
        for (size_t j_1__ = 0; j_1__ < nu_x_true_j_1_max__; ++j_1__) {
            vars__.push_back(nu_x_true(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 443;
            validate_non_negative_index("beta_ev", "dev", dev);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_ev(dev);
            stan::math::initialize(beta_ev, DUMMY_VAR__);
            stan::math::fill(beta_ev, DUMMY_VAR__);
            current_statement_begin__ = 444;
            validate_non_negative_index("esf", "(dev ? n : 0 )", (dev ? n : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> esf((dev ? n : 0 ));
            stan::math::initialize(esf, DUMMY_VAR__);
            stan::math::fill(esf, DUMMY_VAR__);
            current_statement_begin__ = 445;
            validate_non_negative_index("error_scale", "(dev ? 1 : 0 )", (dev ? 1 : 0 ));
            std::vector<double> error_scale((dev ? 1 : 0 ), double(0));
            stan::math::initialize(error_scale, DUMMY_VAR__);
            stan::math::fill(error_scale, DUMMY_VAR__);
            current_statement_begin__ = 447;
            validate_non_negative_index("phi", "(type ? n : 0 )", (type ? n : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi((type ? n : 0 ));
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 448;
            validate_non_negative_index("theta", "(logical_gt(type, 1) ? n : 0 )", (logical_gt(type, 1) ? n : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta((logical_gt(type, 1) ? n : 0 ));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 450;
            validate_non_negative_index("log_lambda_mu", "(car ? n : 0 )", (car ? n : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lambda_mu((car ? n : 0 ));
            stan::math::initialize(log_lambda_mu, DUMMY_VAR__);
            stan::math::fill(log_lambda_mu, DUMMY_VAR__);
            current_statement_begin__ = 452;
            validate_non_negative_index("x_all", "n", n);
            validate_non_negative_index("x_all", "dx_all", dx_all);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> x_all(n, dx_all);
            stan::math::initialize(x_all, DUMMY_VAR__);
            stan::math::fill(x_all, DUMMY_VAR__);
            current_statement_begin__ = 453;
            validate_non_negative_index("fitted", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fitted(n);
            stan::math::initialize(fitted, DUMMY_VAR__);
            stan::math::fill(fitted, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 454;
            if (as_bool(dx_obs)) {
                current_statement_begin__ = 454;
                stan::model::assign(x_all, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(x_obs_idx), stan::model::nil_index_list())), 
                            x_obs, 
                            "assigning variable x_all");
            }
            current_statement_begin__ = 455;
            if (as_bool(dx_me)) {
                current_statement_begin__ = 455;
                for (int j = 1; j <= dx_me; ++j) {
                    current_statement_begin__ = 455;
                    stan::model::assign(x_all, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(x_me_idx, j, "x_me_idx", 1)), stan::model::nil_index_list())), 
                                get_base1(x_true, j, "x_true", 1), 
                                "assigning variable x_all");
                }
            }
            current_statement_begin__ = 456;
            if (as_bool(center_x)) {
                current_statement_begin__ = 456;
                for (int j = 1; j <= dx_all; ++j) {
                    current_statement_begin__ = 456;
                    stan::model::assign(x_all, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                stan::model::deep_copy(subtract(stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "x_all"), mean(stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "x_all")))), 
                                "assigning variable x_all");
                }
            }
            current_statement_begin__ = 457;
            if (as_bool(logical_negation(car))) {
                current_statement_begin__ = 457;
                stan::math::assign(fitted, add(offset, intercept));
            }
            current_statement_begin__ = 461;
            if (as_bool(logical_eq(type, 1))) {
                current_statement_begin__ = 462;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), 1, inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 463;
                if (as_bool(m)) {
                    current_statement_begin__ = 463;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 464;
                stan::math::assign(fitted, add(fitted, phi));
            }
            current_statement_begin__ = 466;
            if (as_bool(logical_eq(type, 2))) {
                current_statement_begin__ = 467;
                stan::math::assign(theta, multiply(theta_tilde, get_base1(theta_scale, 1, "theta_scale", 1)));
                current_statement_begin__ = 468;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), 1, inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 469;
                if (as_bool(m)) {
                    current_statement_begin__ = 469;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 470;
                stan::math::assign(fitted, add(fitted, convolve_bym(phi, theta, n, k, group_size, group_idx, pstream__)));
            }
            current_statement_begin__ = 472;
            if (as_bool(logical_eq(type, 3))) {
                current_statement_begin__ = 473;
                stan::math::assign(theta, multiply((get_base1(spatial_scale, 1, "spatial_scale", 1) * stan::math::sqrt((1 - get_base1(rho, 1, "rho", 1)))), theta_tilde));
                current_statement_begin__ = 474;
                stan::math::assign(phi, make_phi(phi_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), get_base1(rho, 1, "rho", 1), inv_sqrt_scale_factor, n, k, group_size, group_idx, pstream__));
                current_statement_begin__ = 475;
                if (as_bool(m)) {
                    current_statement_begin__ = 475;
                    stan::math::assign(phi, add(phi, multiply(A, alpha_phi)));
                }
                current_statement_begin__ = 476;
                stan::math::assign(fitted, add(fitted, convolve_bym2(phi_tilde, theta_tilde, get_base1(spatial_scale, 1, "spatial_scale", 1), n, k, group_size, group_idx, get_base1(rho, 1, "rho", 1), inv_sqrt_scale_factor, pstream__)));
            }
            current_statement_begin__ = 478;
            if (as_bool(dev)) {
                current_statement_begin__ = 479;
                if (as_bool(has_sigma)) {
                    current_statement_begin__ = 480;
                    stan::model::assign(error_scale, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(sigma, 1, "sigma", 1), 
                                "assigning variable error_scale");
                } else {
                    current_statement_begin__ = 482;
                    stan::model::assign(error_scale, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable error_scale");
                }
                current_statement_begin__ = 484;
                stan::math::assign(beta_ev, rhs_prior(dev, z, get_base1(aux1_global, 1, "aux1_global", 1), get_base1(aux2_global, 1, "aux2_global", 1), aux1_local, aux2_local, get_base1(caux, 1, "caux", 1), global_scale, slab_scale, get_base1(error_scale, 1, "error_scale", 1), pstream__));
                current_statement_begin__ = 485;
                stan::math::assign(esf, multiply(EV, beta_ev));
                current_statement_begin__ = 486;
                stan::math::assign(fitted, add(fitted, esf));
            }
            current_statement_begin__ = 488;
            if (as_bool(car)) {
                current_statement_begin__ = 489;
                stan::math::assign(log_lambda_mu, rep_vector(intercept, n));
                current_statement_begin__ = 490;
                if (as_bool(has_re)) {
                    current_statement_begin__ = 491;
                    for (int i = 1; i <= n; ++i) {
                        current_statement_begin__ = 492;
                        stan::model::assign(log_lambda_mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(log_lambda_mu, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lambda_mu") + get_base1(alpha_re, get_base1(id, i, "id", 1), "alpha_re", 1)), 
                                    "assigning variable log_lambda_mu");
                    }
                }
                current_statement_begin__ = 495;
                if (as_bool(dwx)) {
                    current_statement_begin__ = 496;
                    for (int i = 1; i <= dwx; ++i) {
                        current_statement_begin__ = 496;
                        stan::math::assign(log_lambda_mu, add(log_lambda_mu, multiply(csr_matrix_times_vector(n, n, W_w, W_v, W_u, stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(wx_idx, i, "wx_idx", 1)), stan::model::nil_index_list())), "x_all")), get_base1(gamma, i, "gamma", 1))));
                    }
                }
                current_statement_begin__ = 498;
                if (as_bool(dx_all)) {
                    current_statement_begin__ = 498;
                    stan::math::assign(log_lambda_mu, add(log_lambda_mu, multiply(x_all, beta)));
                }
                current_statement_begin__ = 499;
                if (as_bool(is_auto_gaussian)) {
                    current_statement_begin__ = 500;
                    stan::math::assign(fitted, add(offset, log_lambda_mu));
                } else {
                    current_statement_begin__ = 502;
                    stan::math::assign(fitted, add(offset, log_lambda));
                }
            }
            current_statement_begin__ = 505;
            if (as_bool(logical_negation(car))) {
                current_statement_begin__ = 506;
                if (as_bool(has_re)) {
                    current_statement_begin__ = 507;
                    for (int i = 1; i <= n; ++i) {
                        current_statement_begin__ = 508;
                        stan::model::assign(fitted, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(fitted, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "fitted") + get_base1(alpha_re, get_base1(id, i, "id", 1), "alpha_re", 1)), 
                                    "assigning variable fitted");
                    }
                }
                current_statement_begin__ = 511;
                if (as_bool(dwx)) {
                    current_statement_begin__ = 512;
                    for (int i = 1; i <= dwx; ++i) {
                        current_statement_begin__ = 512;
                        stan::math::assign(fitted, add(fitted, multiply(csr_matrix_times_vector(n, n, W_w, W_v, W_u, stan::model::rvalue(x_all, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(get_base1(wx_idx, i, "wx_idx", 1)), stan::model::nil_index_list())), "x_all")), get_base1(gamma, i, "gamma", 1))));
                    }
                }
                current_statement_begin__ = 514;
                if (as_bool(dx_all)) {
                    current_statement_begin__ = 514;
                    stan::math::assign(fitted, add(fitted, multiply(x_all, beta)));
                }
            }
            current_statement_begin__ = 516;
            if (as_bool(is_binomial)) {
                current_statement_begin__ = 516;
                stan::math::assign(fitted, inv_logit(fitted));
            }
            current_statement_begin__ = 517;
            if (as_bool(is_poisson)) {
                current_statement_begin__ = 517;
                stan::math::assign(fitted, stan::math::exp(fitted));
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t beta_ev_j_1_max__ = dev;
                for (size_t j_1__ = 0; j_1__ < beta_ev_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_ev(j_1__));
                }
                size_t esf_j_1_max__ = (dev ? n : 0 );
                for (size_t j_1__ = 0; j_1__ < esf_j_1_max__; ++j_1__) {
                    vars__.push_back(esf(j_1__));
                }
                size_t error_scale_k_0_max__ = (dev ? 1 : 0 );
                for (size_t k_0__ = 0; k_0__ < error_scale_k_0_max__; ++k_0__) {
                    vars__.push_back(error_scale[k_0__]);
                }
                size_t phi_j_1_max__ = (type ? n : 0 );
                for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                    vars__.push_back(phi(j_1__));
                }
                size_t theta_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    vars__.push_back(theta(j_1__));
                }
                size_t log_lambda_mu_j_1_max__ = (car ? n : 0 );
                for (size_t j_1__ = 0; j_1__ < log_lambda_mu_j_1_max__; ++j_1__) {
                    vars__.push_back(log_lambda_mu(j_1__));
                }
                size_t x_all_j_2_max__ = dx_all;
                size_t x_all_j_1_max__ = n;
                for (size_t j_2__ = 0; j_2__ < x_all_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < x_all_j_1_max__; ++j_1__) {
                        vars__.push_back(x_all(j_1__, j_2__));
                    }
                }
                size_t fitted_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < fitted_j_1_max__; ++j_1__) {
                    vars__.push_back(fitted(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 615;
            validate_non_negative_index("log_lik", "(is_auto_gaussian ? 1 : n )", (is_auto_gaussian ? 1 : n ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik((is_auto_gaussian ? 1 : n ));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 620;
            if (as_bool(is_auto_gaussian)) {
                current_statement_begin__ = 621;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            auto_normal_lpdf(y, fitted, get_base1(car_scale, 1, "car_scale", 1), get_base1(car_rho, 1, "car_rho", 1), Ax_w, Ax_v, Ax_u, Cidx, Delta_inv, log_det_Delta_inv, lambda, n, WCAR, pstream__), 
                            "assigning variable log_lik");
            }
            current_statement_begin__ = 628;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 629;
                if (as_bool(is_student)) {
                    current_statement_begin__ = 630;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                student_t_log(get_base1(y, i, "y", 1), get_base1(nu, 1, "nu", 1), get_base1(fitted, i, "fitted", 1), get_base1(sigma, has_sigma, "sigma", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 632;
                if (as_bool(is_gaussian)) {
                    current_statement_begin__ = 633;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_log(get_base1(y, i, "y", 1), get_base1(fitted, i, "fitted", 1), get_base1(sigma, has_sigma, "sigma", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 635;
                if (as_bool(is_poisson)) {
                    current_statement_begin__ = 636;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                poisson_log(get_base1(y_int, i, "y_int", 1), get_base1(fitted, i, "fitted", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 638;
                if (as_bool(is_binomial)) {
                    current_statement_begin__ = 639;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                binomial_log(get_base1(y_int, i, "y_int", 1), get_base1(trials, i, "trials", 1), get_base1(fitted, i, "fitted", 1)), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 615;
            size_t log_lik_j_1_max__ = (is_auto_gaussian ? 1 : n );
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_foundation";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_phi_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < alpha_phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_tilde_j_1_max__ = (type ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < phi_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t spatial_scale_k_0_max__ = (type ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < spatial_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "spatial_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_tilde_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_scale_k_0_max__ = logical_eq(type, 2);
        for (size_t k_0__ = 0; k_0__ < theta_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = logical_eq(type, 3);
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux1_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux1_global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux1_global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux2_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux2_global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux2_global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux1_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux1_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux1_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux2_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux2_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux2_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t caux_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "caux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lambda_j_1_max__ = ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_scale_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_rho_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "intercept";
        param_names__.push_back(param_name_stream__.str());
        size_t gamma_j_1_max__ = dwx;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = dx_all;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_k_0_max__ = is_student;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = has_sigma;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_re_j_1_max__ = n_ids;
        for (size_t j_1__ = 0; j_1__ < alpha_re_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_re" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_tau_k_0_max__ = has_re;
        for (size_t k_0__ = 0; k_0__ < alpha_tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t x_true_j_1_max__ = n;
        size_t x_true_k_0_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < x_true_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < x_true_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x_true" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < mu_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < sigma_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_rho_x_true_j_1_max__ = (spatial_me ? dx_me : 0 );
        for (size_t j_1__ = 0; j_1__ < car_rho_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_rho_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_x_true_j_1_max__ = (spatial_me ? 0 : dx_me );
        for (size_t j_1__ = 0; j_1__ < nu_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_ev_j_1_max__ = dev;
            for (size_t j_1__ = 0; j_1__ < beta_ev_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_ev" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t esf_j_1_max__ = (dev ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < esf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "esf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t error_scale_k_0_max__ = (dev ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < error_scale_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "error_scale" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = (type ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lambda_mu_j_1_max__ = (car ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < log_lambda_mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lambda_mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t x_all_j_2_max__ = dx_all;
            size_t x_all_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < x_all_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_all_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "x_all" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t fitted_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fitted_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "fitted" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = (is_auto_gaussian ? 1 : n );
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_phi_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < alpha_phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_tilde_j_1_max__ = (type ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < phi_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t spatial_scale_k_0_max__ = (type ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < spatial_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "spatial_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_tilde_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_scale_k_0_max__ = logical_eq(type, 2);
        for (size_t k_0__ = 0; k_0__ < theta_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = logical_eq(type, 3);
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux1_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux1_global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux1_global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux2_global_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < aux2_global_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux2_global" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux1_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux1_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux1_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t aux2_local_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < aux2_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux2_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t caux_k_0_max__ = (dev ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < caux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "caux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = dev;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lambda_j_1_max__ = ((primitive_value(car) && primitive_value(logical_negation(is_auto_gaussian))) ? n : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_scale_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_scale_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_scale" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_rho_k_0_max__ = (car ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < car_rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "intercept";
        param_names__.push_back(param_name_stream__.str());
        size_t gamma_j_1_max__ = dwx;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = dx_all;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_k_0_max__ = is_student;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = has_sigma;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_re_j_1_max__ = n_ids;
        for (size_t j_1__ = 0; j_1__ < alpha_re_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_re" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_tau_k_0_max__ = has_re;
        for (size_t k_0__ = 0; k_0__ < alpha_tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t x_true_j_1_max__ = n;
        size_t x_true_k_0_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < x_true_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < x_true_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x_true" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < mu_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_x_true_j_1_max__ = dx_me;
        for (size_t j_1__ = 0; j_1__ < sigma_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t car_rho_x_true_j_1_max__ = (spatial_me ? dx_me : 0 );
        for (size_t j_1__ = 0; j_1__ < car_rho_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "car_rho_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_x_true_j_1_max__ = (spatial_me ? 0 : dx_me );
        for (size_t j_1__ = 0; j_1__ < nu_x_true_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu_x_true" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_ev_j_1_max__ = dev;
            for (size_t j_1__ = 0; j_1__ < beta_ev_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_ev" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t esf_j_1_max__ = (dev ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < esf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "esf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t error_scale_k_0_max__ = (dev ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < error_scale_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "error_scale" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = (type ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = (logical_gt(type, 1) ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lambda_mu_j_1_max__ = (car ? n : 0 );
            for (size_t j_1__ = 0; j_1__ < log_lambda_mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lambda_mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t x_all_j_2_max__ = dx_all;
            size_t x_all_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < x_all_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_all_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "x_all" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t fitted_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < fitted_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "fitted" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = (is_auto_gaussian ? 1 : n );
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_foundation_namespace::model_foundation stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
