% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_geom.R
\name{add_geom}
\alias{add_geom}
\title{This function allows you to add a geom variable with a code variable of "zona", "barrio", "localidad", "segmentos", "secciones" or "departamentos".}
\usage{
add_geom(data, unit, variable, crs = 32721)
}
\arguments{
\item{data}{data.frame}

\item{unit}{spatial unit of data, may be: "Departamentos", "Secciones", "Secc MVD 2004", "Segmentos", "Segm MVD 2004", "Segm URB INT 2004", "Zonas", "Zonas MVD 2004", "Zonas URB INT 2004", "Localidades pg", "Municipios" o "Barrios".}

\item{variable}{Variable name of unit code (without duplicates)}

\item{crs}{Coordinates Refence Sistem, usually in region 32721 or 4326 (default 32721)}
}
\value{
data.frame
}
\description{
This function allows you to add a geom variable with a code variable of "zona", "barrio", "localidad", "segmentos", "secciones" or "departamentos".
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
pobre_x_dpto <- as.data.frame(cbind(nomdpto = c("ARTIGAS", "DURAZNO", "FLORIDA", "LAVALLEJA"),
               Pobreza = c(0.26, 0.27, 0.07, 0.10)))
pobre_x_dpto_geo <- add_geom(data = pobre_x_dpto, unit = "Departamentos", variable = "nomdpto")
}
}
\seealso{
Other service: 
\code{\link{geocode_ide_uy}()},
\code{\link{load_geouy}()},
\code{\link{tiles_geouy}()},
\code{\link{where_uy}()},
\code{\link{which_uy}()}
}
\concept{service}
