% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcCleaning.R
\name{zoneFusion3}
\alias{zoneFusion3}
\title{zoneFusion3}
\usage{
zoneFusion3(K, iC, Ns, map, minSize = 0.01, simplitol = 0.001, disp = 0)
}
\arguments{
\item{K}{zoning object, as returned by the calNei function}

\item{iC}{index of current zone in zoning}

\item{Ns}{zone neighborhood Boolean matrix}

\item{map}{object returned by function genMap}

\item{minSize}{minimum admissible zone size}

\item{simplitol}{tolerance for spatial polygons geometry simplification}

\item{disp}{information level (0-no info, 1-print info, 2-plot)}
}
\value{
a zone obtained by merging current zone with neighbor zone
}
\description{
zoneFusion3
}
\details{
merge current zone #iC with neighbor zone in zoning. If there are several neighbor zones, the selected one is the zone whose area is greater than the admissible size threshold that has the closest average value to the current one.
}
\examples{
data(mapTest)
data(resZTest)
K=resZTest
Ns=geozoning:::getNs(K$zoneNModif,5) # find neighbors of zone 5
zoneFusion3(K,5,Ns,mapTest,disp=2) # merge and plot result of merging
}
