% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeJournals.R
\name{normalizeJournals}
\alias{normalizeJournals}
\title{normalizeJournals}
\usage{
normalizeJournals(
  dataframe,
  journalName = "titulo.do.periodico.ou.revista",
  issn = "issn"
)
}
\arguments{
\item{dataframe}{data imported with readLattes() then getArtigosPublicados()}

\item{journalName}{variable with journal name}

\item{issn}{variable with issn}
}
\value{
data frame
}
\description{
Normalize journals data: journal name, and ISSN. Two or more journals with the same ISSN will receive the most common Journal Name, then two or more journals with the same name will receive the most common ISSN.
}
\details{
DETAILS
}
\examples{
if(interactive()){
data(latesXML)
al <- lapply(xmlsLattes, getArtigosPublicados) 
adf <- dplyr::bind_rows(al)

head(
    normalizeByDoi(dataframe=adf, 
              issn='issn', 
              journalName= 'titulo.do.periodico.ou.revista') 
) 
}
}
\seealso{
\code{\link[stringi]{stri_trans_general}}
 \code{\link[dplyr]{group_by}},\code{\link[dplyr]{arrange}},\code{\link[dplyr]{mutate}}
}
