#' gethr: Access to Ethereum-based Blockchains through Geth Nodes Using the R
#' Language
#'
#' The gethr package provides full access to the Geth command line interface for
#' running full Ethereum nodes. With gethr it is possible to carry out different
#' tasks such as mine ether, transfer funds, create contacts, explore block
#' history, etc. The package also provides access to all the available APIs. The
#' officially exposed by Ethereum blockchains (\code{eth}, \code{shh},
#' \code{web3}, \code{net}) and some provided directly by Geth (\code{admin},
#' \code{debug}, \code{miner}, \code{personal}, \code{txpool}).
#'
#' @family admin functions
#' @family debug functions
#' @family eth functions
#' @family ether functions
#' @family miner functions
#' @family net functions
#' @family personal functions
#' @family shh functions
#' @family txpool functions
#' @family web3 functions
#'
#' @docType package
#' @name gethr
NULL
