% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shh.R
\name{shh_setMaxMessageSize}
\alias{shh_setMaxMessageSize}
\title{Maximal message size allowed by this node.}
\usage{
shh_setMaxMessageSize(size)
}
\arguments{
\item{size}{Integer - Message size in bytes}
}
\value{
Boolean -  \code{true} on success.
}
\description{
\code{shh_setMaxMessageSize} sets the maximal message size allowed by this
node. Incoming and outgoing messages with a larger size will be rejected.
Whisper message size can never exceed the limit imposed by the underlying P2P
protocol (10 Mb).
}
\examples{
\donttest{
shh_setMaxMessageSize(1048576)
}

}
\seealso{
Other shh functions: \code{\link{gethr}},
  \code{\link{shh_addPrivatekey}},
  \code{\link{shh_addSymKey}},
  \code{\link{shh_deleteKeyPair}},
  \code{\link{shh_deleteSymKey}},
  \code{\link{shh_generateSymKeyFromPassword}},
  \code{\link{shh_getPrivateKey}},
  \code{\link{shh_getPublicKey}},
  \code{\link{shh_getSymKey}},
  \code{\link{shh_hasKeyPair}},
  \code{\link{shh_hasSymKey}}, \code{\link{shh_info}},
  \code{\link{shh_markTrustedPeer}},
  \code{\link{shh_newKeyPair}},
  \code{\link{shh_newMessageFilter}},
  \code{\link{shh_newSymKey}}, \code{\link{shh_post}},
  \code{\link{shh_setMinPoW}}, \code{\link{shh_version}}
}
\concept{shh functions}
