% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rank.R
\name{Rank}
\alias{Rank}
\title{Hard ranking family}
\usage{
Rank()
}
\value{
A Boosting family object
}
\description{
{Gradient-free Gradient Boosting family for the hard ranking loss function including its fast computation.}
}
\details{
{The hard ranking loss is used to compare different orderings, usually the true ordering of instances of a data
set according to their responses with the predicted counterparts. The usage of the \code{pcaPP} package avoids the
cumbersome computation that would require \deqn{frac{n}{2(n-1)}} comparisons. \code{Rank} returns a family object
as in the package \code{mboost}.}
}
\examples{
{y<-c(-3, 10.3,-8, 12, 14,-0.5, 29,-1.1,-5.7, 119)
 yhat<-c(0.02, 0.6, 0.1, 0.47, 0.82, 0.04, 0.77, 0.09, 0.01, 0.79)
 Rank()@risk(y,yhat)}
{x<-1:6
z<-6:1
Rank()@risk(x,z)}
{x<-1:6
z<-1:6
Rank()@risk(x,z)}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020,
Equations (5.2.2) and (5.2.3)}

{T. Hothorn, P. Bühlmann, T. Kneib, M. Schmid, and B. Hofner. mboost: Model-Based
Boosting, 2017}
}
