% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-matrix.R
\name{pmx_plot_eta_matrix}
\alias{pmx_plot_eta_matrix}
\title{Eta matrix plot}
\usage{
pmx_plot_eta_matrix(ctr, title, dname, type.eta, text_color, is.shrink, shrink,
  point, is.smooth, smooth, is.hline, hline, filter, strat.facet, facets,
  strat.color, trans, pmxgpar, labels, axis.title, axis.text, ranges, is.band,
  band, is.draft, draft, is.identity_line, identity_line, scale_x_log10,
  scale_y_log10, color.scales, ...)
}
\arguments{
\item{ctr}{pmx controller}

\item{title}{character the plot title}

\item{dname}{name of dataset to be used}

\item{type.eta}{\code{character} type of eat can be 'mode' or 'mean'.'mode' by default}

\item{text_color}{color of the correlation text in the upper matrix}

\item{is.shrink}{\code{logical} if TRUE add shrinkage to the plot}

\item{shrink}{\code{list} shrinkage graphical parameter}

\item{point}{\code{list} geom_point graphical parameter}

\item{is.smooth}{\code{logical} if TRUE add smoothing to lower matrix plots}

\item{smooth}{\code{list} geom_smooth graphical parameters}

\item{is.hline}{\code{logical} if TRUE add horizontal line to lower matrix plots}

\item{hline}{\code{list} geom_hline graphical parameters

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{eta_pairs}} ggPMX internal function for eta matrix plot.
\item \code{\link{pmx_update}} function.
}

\strong{eta_pairs parameters}}
}
\value{
ggplot2 object
}
\description{
Eta matrix plot
}
\examples{

\donttest{

# basic use  ---------------------------------------

ctr <- theophylline()
p <- ctr \%>\% pmx_plot_eta_matrix

# update graphical parameter  ----------------------

## update labels
ctr \%>\% pmx_plot_eta_matrix(
  labels = list(title = "Eta matrix new title")
)

## remove draft
ctr \%>\% pmx_plot_eta_matrix(is.draft = FALSE)

## change text color line
ctr \%>\% pmx_plot_eta_matrix(
  text_color="red",
  shrink=list(mapping=aes(color="magenta"))
  )

## custom point aes and static parameters
## we can customize any geom_point parameter
ctr \%>\% pmx_plot_eta_matrix(
  point = list(color = "blue", shape = 4)
)



# stratification  ----------------------------------

## IGNORE continuous stratification
ctr \%>\% pmx_plot_eta_matrix(strat.color = "WT0")
## IGNORE  categorical stratification
ctr \%>\% pmx_plot_eta_matrix(strat.facet = "SEX")

# subsetting  --------------------------------------

## we can use any expression involving the data
ctr \%>\% pmx_plot_eta_matrix(filter = EFFECT\%in\%  c("Cl","ka"))
}
}
