% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-vpc.R
\name{pmx_vpc_ci}
\alias{pmx_vpc_ci}
\title{Sets vpc confidence interval layer}
\usage{
pmx_vpc_ci(show = c("all", "median"), interval = c(0.05, 0.95),
  method = c("ribbon", "rectangle"), median = list(fill = "#3388cc",
  alpha = 0.3), extreme = list(fill = "#3388cc", alpha = 0.3))
}
\arguments{
\item{show}{\code{charcater} how areas are displayed:
\itemize{
\item {\strong{show="all"}} {areas will be displayed for each of the 3 percentiles. }
\item {\strong{show="median"}} {Show only median area.}
}}

\item{interval}{\code{numeric} quantiles values default to \code{c(.05,.95)}}

\item{method}{\code{charcater} which areas are displayed:
\itemize{
\item {\strong{method="ribbon"}} {areas are ribbons.}
\item {\strong{method="rectangle"}} {ares are horizontal rectangles.}
}}

\item{median}{\code{list} containing: \cr
\itemize{
\item {\strong{fill}} { \code{character} Color of the area representing the CI for the median. Default: "#3388cc".}
\item {\strong{alpha}} {\code{numeric} Transparency of the area representing the PI for the median. Default=0.3.}
}}

\item{extreme}{\code{list} containing: \cr
\itemize{
\item {\strong{fill}} {\code{character} Color of the area representing the CI for the extreme percentiles. Default: "#3388cc".}
\item {\strong{alpha}} {\code{numeric} Transparency of the area representing the PI for the extreme percentiles. Default=0.3.}
}}
}
\description{
Sets vpc confidence interval layer
}
\seealso{
Other vpc: \code{\link{pmx_plot_vpc}},
  \code{\link{pmx_vpc_bin}}, \code{\link{pmx_vpc_obs}},
  \code{\link{pmx_vpc_pi}}, \code{\link{pmx_vpc_rug}},
  \code{\link{pmx_vpc}}
}
\concept{vpc}
