% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-distribution.R
\name{distrib}
\alias{distrib}
\title{creates a graphic distribution object}
\usage{
distrib(labels, is.shrink, type = c("box", "hist"), is.jitter = FALSE,
  jitter = NULL, facets = NULL, histogram = NULL, shrink = NULL,
  dname = NULL, ...)
}
\arguments{
\item{labels}{list of texts/titles used within the plot}

\item{is.shrink}{\code{logical} if TRUE add shrinkage layer}

\item{type}{box for boxplot or histogram}

\item{is.jitter}{\code{logical} if TRUE add jitter operator for points}

\item{jitter}{list set jitter parameter}

\item{facets}{list set the facet setting in case of histogram plot}

\item{histogram}{\code{list} histogram graphical parameters}

\item{shrink}{\code{list} list of parameters to tune the shrinkage}

\item{dname}{name of dataset to be used}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\value{
distrib object
}
\description{
creates a graphic distribution object
}
\details{
\strong{labels} is a list that contains:
\itemize{
\item {\strong{title:}} {plot title default "EBE distribution"}
\item {\strong{subtitle:}} {plot subtitle default empty}
\item {\strong{x:}} {x axis label default to "Etas"}
\item {\strong{y:}} {y axis label default to empty}
\item {\strong{legend:}} {legend title default to "random Effect"}
}
\strong{shrink} is a list that contains:
\itemize{
\item {\strong{fun:}} {shrinkage function can be \code{sd} or \code{var}}
\item {\strong{size:}} {shrinkage text size}
\item {\strong{color:}} {shrinkage text color}
\item {\strong{vjust:}} {shrinkage position vertical adjustment}
}
}
\seealso{
Other plot_pmx: \code{\link{eta_cov}},
  \code{\link{eta_pairs}}, \code{\link{individual}},
  \code{\link{plot_pmx.distrib}},
  \code{\link{plot_pmx.eta_cov}},
  \code{\link{plot_pmx.eta_pairs}},
  \code{\link{plot_pmx.individual}},
  \code{\link{plot_pmx.pmx_dens}},
  \code{\link{plot_pmx.pmx_gpar}},
  \code{\link{plot_pmx.pmx_qq}},
  \code{\link{plot_pmx.residual}}, \code{\link{plot_pmx}}
}
\concept{plot_pmx}
