% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-filter.R
\name{pmx_update}
\alias{pmx_update}
\title{Update plot object}
\usage{
pmx_update(ctr, pname, strat.color = NULL, strat.facet = NULL,
  color.scales = NULL, filter = NULL, trans = NULL, ...,
  pmxgpar = NULL)
}
\arguments{
\item{ctr}{\code{pmxClass} controller object}

\item{pname}{character the plot name to update}

\item{strat.color}{\code{character} optional stratification parameter}

\item{strat.facet}{\code{formula} optional stratification parameter}

\item{color.scales}{\code{list} can be used with strat.color to set scale_color_manual
\code{\link{pmx_gpar}} function.}

\item{filter}{optional filter which will be applied to plotting data}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{...}{others graphical parameters given to set the plot}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the}
}
\value{
controller object with the plot updated
}
\description{
Update plot object
}
\details{
\strong{trans} is a transformation that user can apply to x, or y coordinates. The transformation
is applied to the data before the plotting. This gives more felxiblilty to the user and also conserves
all static positions like annotations ( draft specially)

For example:

 var_x apply variance to x coordinates the variance function

 var_xy apply variance to both
This mechanism is applied internally to scale log.
}
\seealso{
Other pmxclass: \code{\link{get_cats}},
  \code{\link{get_conts}}, \code{\link{get_covariates}},
  \code{\link{get_data}}, \code{\link{get_occ}},
  \code{\link{get_plot_config}}, \code{\link{get_plot}},
  \code{\link{get_strats}}, \code{\link{plot_names}},
  \code{\link{plots}}, \code{\link{set_data}},
  \code{\link{set_plot}}
}
\concept{pmxclass}
