% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{mR}
\alias{mR}
\title{Mean One-Point Moving Range}
\usage{
mR(y, na.rm = TRUE, ...)
}
\arguments{
\item{y}{Vector of values}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A number; mean one-point moving range.
}
\description{
Calculates the mean one-point moving range used when constructing a moving-range chart.
}
\examples{
set.seed(5555)
values <- rnorm(n = 100, mean = 25, sd = 1)
mR(values)
}
