% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_rfsrc.ggRandomForests}
\alias{gg_rfsrc}
\alias{gg_rfsrc.ggRandomForests}
\title{Predicted response data object}
\usage{
gg_rfsrc.ggRandomForests(object, surv_type = c("surv", "chf", "mortality",
  "hazard"), oob = TRUE, se, ...)
}
\arguments{
\item{object}{\code{randomForestSRC::rfsrc} object}

\item{surv_type}{("surv", "chf", "mortality", "hazard") for survival forests}

\item{oob}{boolean, should we return the oob prediction , or the full
forest prediction.}

\item{se}{for survival forests, calculated the se bootstrap confidence
interval}

\item{...}{not used}
}
\value{
\code{gg_rfsrc} object formatted for \code{\link{plot.gg_rfsrc}}
}
\description{
Extracts the predicted response values from the \code{randomForestSRC::rfsrc} object,
and formats data for plotting the response using \code{\link{plot.gg_rfsrc}}.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# iris_rf <- rfsrc(Species ~ ., data = iris)
data(iris_rf, package="ggRandomForests")
gg_dta<- gg_rfsrc(iris_rf)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq.obj <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
data(airq_rf, package="ggRandomForests")
gg_dta<- gg_rfsrc(airq_rf)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
data(veteran_rf, package = "ggRandomForests")
gg_dta <- gg_rfsrc(veteran_rf)
plot(gg_dta)
plot(gg_dta, se=.68)
}
\seealso{
\code{\link{plot.gg_rfsrc}} \code{rfsrc} \code{plot.rfsrc} \code{\link{gg_survival}}
}

