% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nelson}
\alias{nelson}
\title{nonparametric Nelson-Aalen estimates}
\usage{
nelson(interval, censor, data, strat = NULL, weight = NULL, ...)
}
\arguments{
\item{interval}{name of the interval variable in the training dataset.}

\item{censor}{name of the censoring variable in the training dataset.}

\item{data}{name of the survival training data.frame}

\item{strat}{stratifying variable in the training dataset, defaults to NULL}

\item{weight}{for each observation (default=NULL)}

\item{...}{arguments passed to the \code{survfit} function}
}
\description{
nonparametric Nelson-Aalen estimates
}
\examples{
\dontrun{
data(pbc, package="randomForestSRC")
pbc$time <- pbc$days/364.25

# This is the same as gg_survival
gg_dta <- nelson(interval="time", censor="status",
                     data=pbc)

plot(gg_dta, error="none")
plot(gg_dta)

# Stratified on treatment variable.
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc, strat="treatment")

plot(gg_dta, error="none")
plot(gg_dta)
}
}
\seealso{
\code{\link{gg_survival}} \code{\link{nelson}} \code{\link{plot.gg_survival}}
}

