% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggVennDiagram.R
\name{ggVennDiagram}
\alias{ggVennDiagram}
\title{ggVennDiagram main parser}
\usage{
ggVennDiagram(
  x,
  category.names = names(x),
  show_intersect = FALSE,
  label = c("count", "percent", "both", "none"),
  label_alpha = 0.5,
  label_geom = c("label", "text"),
  ...
)
}
\arguments{
\item{x}{list of items}

\item{category.names}{default is names(x)}

\item{show_intersect}{if TRUE the text can be visualized by `plotly`}

\item{label}{select one from c("count","percent","both","none")}

\item{label_alpha}{set 0 to remove label background}

\item{label_geom}{choose from c("label", "text")}

\item{...}{Other arguments passed on to downstream functions.}
}
\value{
A ggplot object
}
\description{
ggVennDiagram main parser
}
\examples{
library(ggVennDiagram)
x <- list(A=1:5,B=2:7,C=3:6,D=4:9)
ggVennDiagram(x)  # 4d venn
ggVennDiagram(x[1:3])  # 3d venn
ggVennDiagram(x[1:2])  # 2d venn
}
