% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset_plot.R
\name{upset-plot}
\alias{upset-plot}
\alias{plot_upset}
\title{Plot a upset plot}
\usage{
plot_upset(
  venn,
  nintersects = NULL,
  order.intersect.by = c("size", "name", "none"),
  order.set.by = c("size", "name", "none"),
  relative_height = 3,
  relative_width = 0.3,
  ...
)
}
\arguments{
\item{venn}{a class Venn object}

\item{nintersects}{number of intersects. If NULL, all intersections will show.}

\item{order.intersect.by}{'size', 'name', or "none"}

\item{order.set.by}{'size', 'name', or "none"}

\item{relative_height}{the relative height of top panel in upset plot}

\item{relative_width}{the relative width of left panel in upset plot}

\item{...}{useless}
}
\value{
an upset plot
}
\description{
This function generate a upset plot by creating a composite plot which contains subplots generated by ggplot2.
}
\examples{
 list = list(A = sample(LETTERS, 20),
             B = sample(LETTERS, 22),
             C = sample(LETTERS, 14),
             D = sample(LETTERS, 30, replace = TRUE))
 venn = Venn(list)
 plot_upset(venn)
 plot_upset(venn, order.intersect.by = "name")
 plot_upset(venn, nintersects = 6)
}
