% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-theme.R
\name{theme_ggalign}
\alias{theme_ggalign}
\title{Theme for Layout Plots}
\usage{
theme_ggalign(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic}}
  \describe{
    \item{\code{base_size}}{base font size, given in pts.}
    \item{\code{base_family}}{base font family}
    \item{\code{base_line_size}}{base size for line elements}
    \item{\code{base_rect_size}}{base size for rect elements}
  }}
}
\value{
A \code{\link[ggplot2:theme]{theme()}} object.
}
\description{
Default theme for \code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}} or \code{\link[=stack_layout]{stack_layout()}} object.
}
\details{
You can change the default theme using the option
\code{"ggalign.default_theme"}. This option should be
set to a function that returns a \code{\link[ggplot2:theme]{theme()}} object.
}
\examples{
# Setting a new default theme
old <- options(ggalign.default_theme = function() theme_bw())

# Creating a heatmap with the new theme
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro(k = 3L)

# Restoring the old default theme
options(old)
}
