% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-flow.r
\name{geom_flow}
\alias{geom_flow}
\title{Flows between lodes or strata}
\usage{
geom_flow(mapping = NULL, data = NULL, stat = "flow",
  position = "identity", width = 1/3, knot.pos = 1/6,
  aes.flow = "forward", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data;
override the default.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{width}{Numeric; the width of each stratum, as a proportion of the
distance between axes. Defaults to 1/3.}

\item{knot.pos}{The horizontal distance between a stratum (\code{width/2}
from its axis) and the knot of the x-spline, as a proportion of the
separation between strata. Defaults to 1/6.}

\item{aes.flow}{Character; how inter-lode flows assume aesthetics from lodes.
Options are "forward" and "backward".}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
\code{geom_flow} receives a dataset of the horizontal (\code{x}) and
vertical (\code{y}, \code{ymin}, \code{ymax}) positions of the \strong{lodes}
of an alluvial plot, the intersections of the alluvia with the strata.
It reconfigures these into alluvial segments connecting pairs of
corresponding lodes in adjacent strata and plots filled x-splines between
each such pair, using a provided knot position parameter \code{knot.pos}, and
filled rectangles at either end, using a provided \code{width}.
}
\section{Aesthetics}{

\code{geom_alluvium}, \code{geom_flow}, \code{geom_lode}, and \code{geom_stratum} understand the
following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{ymin}}
\item \strong{\code{ymax}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{linetype}
\item \code{size}
\item \code{group}
}

\code{group} is used internally; arguments are ignored.
}

\section{Defunct parameters}{

The previously defunct parameters \code{axis_width} and \code{ribbon_bend} have been
discontinued. Use \code{width} and \code{knot.pos} instead.
}

\examples{
# use of strata and labels
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age)) +
  geom_flow() +
  scale_x_discrete(limits = c("Class", "Sex", "Age")) +
  geom_stratum() + geom_text(stat = "stratum", infer.label = TRUE) +
  ggtitle("Alluvial plot of Titanic passenger demographic data")

# use of facets
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex)) +
  geom_flow(aes(fill = Age), width = .4) +
  geom_stratum(width = .4) +
  geom_text(stat = "stratum", infer.label = TRUE, size = 3) +
  scale_x_discrete(limits = c("Class", "Sex")) +
  facet_wrap(~ Survived, scales = "fixed")

# time series alluvia of WorldPhones data
wph <- as.data.frame(as.table(WorldPhones))
names(wph) <- c("Year", "Region", "Telephones")
ggplot(wph,
       aes(x = Year, alluvium = Region, y = Telephones)) +
  geom_flow(aes(fill = Region, colour = Region), width = 0)

# rightward flow aesthetics for vaccine survey data
data(vaccinations)
levels(vaccinations$response) <- rev(levels(vaccinations$response))
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           y = freq, fill = response, label = round(a, 3))) +
  geom_lode() + geom_flow() +
  geom_stratum(alpha = 0) +
  geom_text(stat = "stratum")
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}} for additional arguments and
\code{\link[=stat_alluvium]{stat_alluvium()}} and
\code{\link[=stat_flow]{stat_flow()}} for the corresponding stats.

Other alluvial geom layers: \code{\link{geom_alluvium}},
  \code{\link{geom_lode}}, \code{\link{geom_stratum}}
}
\concept{alluvial geom layers}
